/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.escape;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.escape.CharEscaper;
import com.google.common.escape.Escaper;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.HashMap;
import java.util.Map;

@Beta
@GwtCompatible
public final class CharEscaperBuilder {
    private final Map<Character, String> map = new HashMap<Character, String>();
    private int max = -1;

    @CanIgnoreReturnValue
    public CharEscaperBuilder addEscape(char c11, String r11) {
        this.map.put(Character.valueOf(c11), Preconditions.checkNotNull(r11));
        if (c11 > this.max) {
            this.max = c11;
        }
        return this;
    }

    @CanIgnoreReturnValue
    public CharEscaperBuilder addEscapes(char[] cs2, String r11) {
        Preconditions.checkNotNull(r11);
        for (char c11 : cs2) {
            this.addEscape(c11, r11);
        }
        return this;
    }

    public char[][] toArray() {
        char[][] result = new char[this.max + 1][];
        for (Map.Entry<Character, String> entry : this.map.entrySet()) {
            result[entry.getKey().charValue()] = entry.getValue().toCharArray();
        }
        return result;
    }

    public Escaper toEscaper() {
        return new CharArrayDecorator(this.toArray());
    }

    private static class CharArrayDecorator
    extends CharEscaper {
        private final char[][] replacements;
        private final int replaceLength;

        CharArrayDecorator(char[][] replacements) {
            this.replacements = replacements;
            this.replaceLength = replacements.length;
        }

        @Override
        public String escape(String s11) {
            int slen = s11.length();
            for (int index = 0; index < slen; ++index) {
                char c11 = s11.charAt(index);
                if (c11 >= this.replacements.length || this.replacements[c11] == null) continue;
                return this.escapeSlow(s11, index);
            }
            return s11;
        }

        @Override
        protected char[] escape(char c11) {
            return c11 < this.replaceLength ? this.replacements[c11] : null;
        }
    }
}

