/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.validation;

import com.android.bundle.RuntimeEnabledSdkConfigProto;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.exceptions.InvalidBundleException;
import com.android.tools.build.bundletool.validation.SubValidator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.errorprone.annotations.FormatMethod;
import com.google.errorprone.annotations.FormatString;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;

public final class RuntimeEnabledSdkConfigValidator
extends SubValidator {
    private static final String HEX_FINGERPRINT_REGEX = "[0-9A-F]{2}(:[0-9A-F]{2}){31}";

    @Override
    public void validateAllModules(ImmutableList<BundleModule> modules) {
        Map runtimeEnabledSdksPerPackageName = modules.stream().filter(module -> module.getRuntimeEnabledSdkConfig().isPresent()).map(module -> module.getRuntimeEnabledSdkConfig().get()).flatMap(runtimeEnabledSdkConfig -> runtimeEnabledSdkConfig.getRuntimeEnabledSdkList().stream()).collect(ImmutableListMultimap.toImmutableListMultimap(RuntimeEnabledSdkConfigProto.RuntimeEnabledSdk::getPackageName, Function.identity())).asMap();
        ((ImmutableMap)runtimeEnabledSdksPerPackageName).entrySet().forEach(sdksByPackageName -> {
            RuntimeEnabledSdkConfigValidator.validate(((Collection)sdksByPackageName.getValue()).size() == 1, "Found multiple dependencies on the same runtime-enabled SDK '%s'.", sdksByPackageName.getKey());
            RuntimeEnabledSdkConfigValidator.validateRuntimeEnabledSdk((RuntimeEnabledSdkConfigProto.RuntimeEnabledSdk)Iterables.getOnlyElement((Iterable)sdksByPackageName.getValue()));
        });
    }

    private static void validateRuntimeEnabledSdk(RuntimeEnabledSdkConfigProto.RuntimeEnabledSdk runtimeEnabledSdk) {
        RuntimeEnabledSdkConfigValidator.validate(!runtimeEnabledSdk.getPackageName().isEmpty(), "Found dependency on runtime-enabled SDK with an empty package name.", new Object[0]);
        RuntimeEnabledSdkConfigValidator.validate(runtimeEnabledSdk.getVersionMajor() >= 0, "Found dependency on runtime-enabled SDK '%s' with a negative major version.", runtimeEnabledSdk.getPackageName());
        RuntimeEnabledSdkConfigValidator.validate(runtimeEnabledSdk.getVersionMajor() <= 199999, "Found dependency on runtime-enabled SDK '%s' with illegal major version. Major version must be <= %d.", runtimeEnabledSdk.getPackageName(), 199999);
        RuntimeEnabledSdkConfigValidator.validate(runtimeEnabledSdk.getVersionMinor() >= 0, "Found dependency on runtime-enabled SDK '%s' with a negative minor version.", runtimeEnabledSdk.getPackageName());
        RuntimeEnabledSdkConfigValidator.validate(runtimeEnabledSdk.getVersionMinor() <= 9999, "Found dependency on runtime-enabled SDK '%s' with illegal minor version. Minor version must be <= %d.", runtimeEnabledSdk.getPackageName(), 9999);
        RuntimeEnabledSdkConfigValidator.validate(runtimeEnabledSdk.getCertificateDigest().matches(HEX_FINGERPRINT_REGEX), "Found dependency on runtime-enabled SDK '%s' with a signing certificate digest of unexpected format.", runtimeEnabledSdk.getPackageName());
    }

    @FormatMethod
    private static void validate(boolean condition, @FormatString String message2, Object ... args2) {
        if (!condition) {
            throw InvalidBundleException.builder().withUserMessage(message2, args2).build();
        }
    }
}

