/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.commands;

import com.android.bundle.DeviceGroup;
import com.android.bundle.DeviceProperties;
import com.android.bundle.DeviceTier;
import com.android.bundle.DeviceTierConfig;
import com.android.tools.build.bundletool.commands.AutoValue_EvaluateDeviceTargetingConfigCommand;
import com.android.tools.build.bundletool.commands.CommandHelp;
import com.android.tools.build.bundletool.device.DeviceTargetingConfigEvaluator;
import com.android.tools.build.bundletool.flags.Flag;
import com.android.tools.build.bundletool.flags.ParsedFlags;
import com.android.tools.build.bundletool.model.utils.files.BufferedIo;
import com.android.tools.build.bundletool.validation.DeviceTierConfigValidator;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableSet;
import com.google.protobuf.Message;
import com.google.protobuf.util.JsonFormat;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Path;
import java.util.Optional;
import java.util.stream.Collectors;

@AutoValue
public abstract class EvaluateDeviceTargetingConfigCommand {
    public static final String COMMAND_NAME = "evaluate-device-targeting-config";
    private static final Flag<Path> DEVICE_TARGETING_CONFIGURATION_LOCATION_FLAG = Flag.path("config");
    private static final Flag<Path> DEVICE_PROPERTIES_LOCATION_FLAG = Flag.path("device-properties");

    abstract Path getDeviceTargetingConfigurationPath();

    abstract Path getDevicePropertiesPath();

    static Builder builder() {
        return new AutoValue_EvaluateDeviceTargetingConfigCommand.Builder();
    }

    public static EvaluateDeviceTargetingConfigCommand fromFlags(ParsedFlags flags) {
        return EvaluateDeviceTargetingConfigCommand.builder().setDeviceTargetingConfigurationPath(DEVICE_TARGETING_CONFIGURATION_LOCATION_FLAG.getRequiredValue(flags)).setDevicePropertiesPath(DEVICE_PROPERTIES_LOCATION_FLAG.getRequiredValue(flags)).build();
    }

    public void execute(PrintStream out) throws IOException {
        try (BufferedReader configReader = BufferedIo.reader(this.getDeviceTargetingConfigurationPath());
             BufferedReader devicePropertiesReader = BufferedIo.reader(this.getDevicePropertiesPath());){
            DeviceTierConfig.Builder configBuilder = DeviceTierConfig.newBuilder();
            JsonFormat.parser().merge(configReader, (Message.Builder)configBuilder);
            DeviceTierConfig config = configBuilder.build();
            DeviceTierConfigValidator.validateDeviceTierConfig(config);
            DeviceProperties.Builder devicePropertiesBuilder = DeviceProperties.newBuilder();
            JsonFormat.parser().merge(devicePropertiesReader, (Message.Builder)devicePropertiesBuilder);
            DeviceProperties deviceProperties = devicePropertiesBuilder.build();
            this.printTier(DeviceTargetingConfigEvaluator.getSelectedDeviceTier(config, deviceProperties), out);
            this.printGroups(DeviceTargetingConfigEvaluator.getMatchingDeviceGroups(config, deviceProperties), out);
        }
    }

    private void printTier(Optional<DeviceTier> selectedTier, PrintStream out) {
        if (selectedTier.isPresent()) {
            out.println("Tier: " + selectedTier.get().getLevel());
        } else {
            out.println("Tier: 0 (default)");
        }
    }

    private void printGroups(ImmutableSet<DeviceGroup> deviceGroups, PrintStream out) {
        if (deviceGroups.isEmpty()) {
            out.println("Groups:");
        } else {
            out.println("Groups: '" + deviceGroups.stream().map(DeviceGroup::getName).collect(Collectors.joining("', '")) + "'");
        }
    }

    public static CommandHelp help() {
        return CommandHelp.builder().setCommandName(COMMAND_NAME).setCommandDescription(CommandHelp.CommandDescription.builder().setShortDescription("Evaluates which groups and tier a specific device would fall into, in a provided device targeting config.").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(DEVICE_TARGETING_CONFIGURATION_LOCATION_FLAG.getName()).setExampleValue("path/to/targeting/config.json").setDescription("Path to device targeting configuration JSON file.").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(DEVICE_PROPERTIES_LOCATION_FLAG.getName()).setExampleValue("path/to/device_properties.json").setDescription("Path to a JSON representation of a specific device.").build()).build();
    }

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        abstract Builder setDeviceTargetingConfigurationPath(Path var1);

        abstract Builder setDevicePropertiesPath(Path var1);

        abstract EvaluateDeviceTargetingConfigCommand build();
    }
}

