const zh = {
  piano: {
    note: {
      Cb: 'Cb',
      C: 'C',
      'C#': 'C#',
      Db: 'Db',
      D: 'D',
      'D#': 'D#',
      Eb: 'Eb',
      E: 'E',
      'E#': 'E#',
      Fb: 'Fb',
      F: 'F',
      'F#': 'F#',
      Gb: 'Gb',
      G: 'G',
      'G#': 'G#',
      Ab: 'Ab',
      A: 'A',
      'A#': 'A#',
      Bb: 'Bb',
      B: 'B',
      'B#': 'B#',
    },
    numeral: {
      i: 'i',
      I: 'I',
      ii: 'ii',
      iiº: 'iiº',
      II: 'II',
      iii: 'iii',
      III: 'III',
      'III+': 'III+',
      iv: 'iv',
      IV: 'IV',
      v: 'v',
      V: 'V',
      vi: 'vi',
      viº: 'viº',
      VI: 'VI',
      viiº: 'viiº',
      VII: 'VII',
    },
  },
  scales: {
    // Major
    'c-flat-major': 'Cb 大调',
    'c-major': 'C 大调',
    'c-sharp-major': 'C# 大调',
    'd-flat-major': 'Db 大调',
    'd-major': 'D 大调',
    'd-sharp-major': 'D# 大调',
    'e-flat-major': 'Eb 大调',
    'e-major': 'E 大调',
    'e-sharp-major': 'E# 大调',
    'f-flat-major': 'Fb 大调',
    'f-major': 'F 大调',
    'f-sharp-major': 'F# 大调',
    'g-flat-major': 'Gb 大调',
    'g-major': 'G 大调',
    'g-sharp-major': 'G# 大调',
    'a-flat-major': 'Ab 大调',
    'a-major': 'A 大调',
    'a-sharp-major': 'A# 大调',
    'b-flat-major': 'Bb 大调',
    'b-major': 'B 大调',
    'b-sharp-major': 'B# 大调',
    // Minor (Natural)
    'c-minor-natural': 'C 自然小调',
    'c-sharp-minor-natural': 'C# 自然小调',
    'd-flat-minor-natural': 'Db 自然小调',
    'd-minor-natural': 'D 自然小调',
    'd-sharp-minor-natural': 'D# 自然小调',
    'e-flat-minor-natural': 'Eb 自然小调',
    'e-minor-natural': 'E 自然小调',
    'e-sharp-minor-natural': 'E# 自然小调',
    'f-minor-natural': 'F 自然小调',
    'f-sharp-minor-natural': 'F# 自然小调',
    'g-flat-minor-natural': 'Gb 自然小调',
    'g-minor-natural': 'G 自然小调',
    'g-sharp-minor-natural': 'G# 自然小调',
    'a-flat-minor-natural': 'Ab 自然小调',
    'a-minor-natural': 'A 自然小调',
    'a-sharp-minor-natural': 'A# 自然小调',
    'b-flat-minor-natural': 'Bb 自然小调',
    'b-minor-natural': 'B 自然小调',
    'b-sharp-minor-natural': 'B# 自然小调',
    // Minor (Melodic)
    'c-minor-melodic': 'C 旋律小调',
    'c-sharp-minor-melodic': 'C# 旋律小调',
    'd-flat-minor-melodic': 'Db 旋律小调',
    'd-minor-melodic': 'D 旋律小调',
    'd-sharp-minor-melodic': 'D# 旋律小调',
    'e-flat-minor-melodic': 'Eb 旋律小调',
    'e-minor-melodic': 'E 旋律小调',
    'e-sharp-minor-melodic': 'E# 旋律小调',
    'f-minor-melodic': 'F 旋律小调',
    'f-sharp-minor-melodic': 'F# 旋律小调',
    'g-flat-minor-melodic': 'Gb 旋律小调',
    'g-minor-melodic': 'G 旋律小调',
    'g-sharp-minor-melodic': 'G# 旋律小调',
    'a-flat-minor-melodic': 'Ab 旋律小调',
    'a-minor-melodic': 'A 旋律小调',
    'a-sharp-minor-melodic': 'A# 旋律小调',
    'b-flat-minor-melodic': 'Bb 旋律小调',
    'b-minor-melodic': 'B 旋律小调',
    'b-sharp-minor-melodic': 'B# 旋律小调',
  },
  practiceModes: {
    scales: '音阶',
    chords: '和弦',
    seventhChords: '七和弦',
    fifths: '五度',
  },
  pages: {
    practice: {
      scale: {
        title: '音阶',
        pingPongHint: '乒乓模式\n来回练习',
        hardModeHint: '困难模式',
      },
      mode: {
        title: '模式',
        quizModeHint: '测验模式',
        settingsHint: '打开设置',
      },
    },
    quiz: {
      title: '测验',
      questions: {
        key: '在键盘上按 {{key}}',
        fifth: '哪一个 {{key}} 是纯五度',
      },
    },
  },
  settings: {
    title: '设置',
    options: {
      'show-keyboard': '显示键盘',
      'mute-sound': '静音',
      'midi-input-id': 'MIDI 输入',
      language: '语言',
      'is-sentry-on': '发送崩溃报告',
    },
  },
}

export default zh
