const ja = {
  piano: {
    note: {
      Cb: 'Cb',
      C: 'C',
      'C#': 'C#',
      Db: 'Db',
      D: 'D',
      'D#': 'D#',
      Eb: 'Eb',
      E: 'E',
      'E#': 'E#',
      Fb: 'Fb',
      F: 'F',
      'F#': 'F#',
      Gb: 'Gb',
      G: 'G',
      'G#': 'G#',
      Ab: 'Ab',
      A: 'A',
      'A#': 'A#',
      Bb: 'Bb',
      B: 'B',
      'B#': 'B#',
    },
    numeral: {
      i: 'i',
      I: 'I',
      ii: 'ii',
      iiº: 'iiº',
      II: 'II',
      iii: 'iii',
      III: 'III',
      'III+': 'III+',
      iv: 'iv',
      IV: 'IV',
      v: 'v',
      V: 'V',
      vi: 'vi',
      viº: 'viº',
      VI: 'VI',
      viiº: 'viiº',
      VII: 'VII',
    },
  },
  scales: {
    // Major
    'c-flat-major': 'Cb メジャー',
    'c-major': 'C メジャー',
    'c-sharp-major': 'C# メジャー',
    'd-flat-major': 'Db メジャー',
    'd-major': 'D メジャー',
    'd-sharp-major': 'D# メジャー',
    'e-flat-major': 'Eb メジャー',
    'e-major': 'E メジャー',
    'e-sharp-major': 'E# メジャー',
    'f-flat-major': 'Fb メジャー',
    'f-major': 'F メジャー',
    'f-sharp-major': 'F# メジャー',
    'g-flat-major': 'Gb メジャー',
    'g-major': 'G メジャー',
    'g-sharp-major': 'G# メジャー',
    'a-flat-major': 'Ab メジャー',
    'a-major': 'A メジャー',
    'a-sharp-major': 'A# メジャー',
    'b-flat-major': 'Bb メジャー',
    'b-major': 'B メジャー',
    'b-sharp-major': 'B# メジャー',
    // Minor (Natural)
    'c-minor-natural': 'C ナチュラルマイナー',
    'c-sharp-minor-natural': 'C# ナチュラルマイナー',
    'd-flat-minor-natural': 'Db ナチュラルマイナー',
    'd-minor-natural': 'D ナチュラルマイナー',
    'd-sharp-minor-natural': 'D# ナチュラルマイナー',
    'e-flat-minor-natural': 'Eb ナチュラルマイナー',
    'e-minor-natural': 'E ナチュラルマイナー',
    'e-sharp-minor-natural': 'E# ナチュラルマイナー',
    'f-minor-natural': 'F ナチュラルマイナー',
    'f-sharp-minor-natural': 'F# ナチュラルマイナー',
    'g-flat-minor-natural': 'Gb ナチュラルマイナー',
    'g-minor-natural': 'G ナチュラルマイナー',
    'g-sharp-minor-natural': 'G# ナチュラルマイナー',
    'a-flat-minor-natural': 'Ab ナチュラルマイナー',
    'a-minor-natural': 'A ナチュラルマイナー',
    'a-sharp-minor-natural': 'A# ナチュラルマイナー',
    'b-flat-minor-natural': 'Bb ナチュラルマイナー',
    'b-minor-natural': 'B ナチュラルマイナー',
    'b-sharp-minor-natural': 'B# ナチュラルマイナー',
    // Minor (Melodic)
    'c-minor-melodic': 'C メロディックマイナー',
    'c-sharp-minor-melodic': 'C# メロディックマイナー',
    'd-flat-minor-melodic': 'Db メロディックマイナー',
    'd-minor-melodic': 'D メロディックマイナー',
    'd-sharp-minor-melodic': 'D# メロディックマイナー',
    'e-flat-minor-melodic': 'Eb メロディックマイナー',
    'e-minor-melodic': 'E メロディックマイナー',
    'e-sharp-minor-melodic': 'E# メロディックマイナー',
    'f-minor-melodic': 'F メロディックマイナー',
    'f-sharp-minor-melodic': 'F# メロディックマイナー',
    'g-flat-minor-melodic': 'Gb メロディックマイナー',
    'g-minor-melodic': 'G メロディックマイナー',
    'g-sharp-minor-melodic': 'G# メロディックマイナー',
    'a-flat-minor-melodic': 'Ab メロディックマイナー',
    'a-minor-melodic': 'A メロディックマイナー',
    'a-sharp-minor-melodic': 'A# メロディックマイナー',
    'b-flat-minor-melodic': 'Bb メロディックマイナー',
    'b-minor-melodic': 'B メロディックマイナー',
    'b-sharp-minor-melodic': 'B# メロディックマイナー',
  },
  practiceModes: {
    scales: 'スケール',
    chords: 'コード',
    seventhChords: 'セブンスコード',
    fifths: '五度',
  },
  pages: {
    practice: {
      scale: {
        title: 'スケール',
        pingPongHint: 'ピンポンモード\n往復練習ができます',
        hardModeHint: 'ハードモード',
      },
      mode: {
        title: 'モード',
        quizModeHint: 'クイズモード',
        settingsHint: '設定を開く',
      },
    },
    quiz: {
      title: 'クイズ',
      questions: {
        key: '鍵盤の {{key}} を押してください',
        fifth: 'どれが {{key}} の完全五度ですか',
      },
    },
  },
  settings: {
    title: '設定',
    options: {
      'show-keyboard': '鍵盤を表示する',
      'mute-sound': 'サウンドをミュートする',
      'midi-input-id': 'MIDI 入力',
      language: '言語',
      'is-sentry-on': 'クラッシュレポートを送信する',
    },
  },
}

export default ja
