const fr = {
  piano: {
    note: {
      Cb: 'Do♭',
      C: 'Do',
      'C#': 'Do#',
      Db: 'Ré♭',
      D: 'Ré',
      'D#': 'Ré#',
      Eb: 'Mi♭',
      E: 'Mi',
      'E#': 'Mi#',
      Fb: 'Fa♭',
      F: 'Fa',
      'F#': 'Fa#',
      Gb: 'Sol♭',
      G: 'Sol',
      'G#': 'Sol#',
      Ab: 'La♭',
      A: 'La',
      'A#': 'La#',
      Bb: 'Si♭',
      B: 'Si',
      'B#': 'Si#',
    },
    numeral: {
      i: 'i',
      I: 'I',
      ii: 'ii',
      iiº: 'iiº',
      II: 'II',
      iii: 'iii',
      III: 'III',
      'III+': 'III+',
      iv: 'iv',
      IV: 'IV',
      v: 'v',
      V: 'V',
      vi: 'vi',
      viº: 'viº',
      VI: 'VI',
      viiº: 'viiº',
      VII: 'VII',
    },
  },
  scales: {
    // Major
    'c-flat-major': 'Do♭ majeur',
    'c-major': 'Do majeur',
    'c-sharp-major': 'Do# majeur',
    'd-flat-major': 'Ré♭ majeur',
    'd-major': 'Ré majeur',
    'd-sharp-major': 'Ré# majeur',
    'e-flat-major': 'Mi♭ majeur',
    'e-major': 'Mi majeur',
    'e-sharp-major': 'Mi# majeur',
    'f-flat-major': 'Fa♭ majeur',
    'f-major': 'Fa majeur',
    'f-sharp-major': 'Fa# majeur',
    'g-flat-major': 'Sol♭ majeur',
    'g-major': 'Sol majeur',
    'g-sharp-major': 'Sol# majeur',
    'a-flat-major': 'La♭ majeur',
    'a-major': 'La majeur',
    'a-sharp-major': 'La# majeur',
    'b-flat-major': 'Si♭ majeur',
    'b-major': 'Si majeur',
    'b-sharp-major': 'Si# majeur',
    // Minor (Natural)
    'c-minor-natural': 'Do naturel mineur',
    'c-sharp-minor-natural': 'Do# naturel mineur',
    'd-flat-minor-natural': 'Ré♭ naturel mineur',
    'd-minor-natural': 'Ré naturel mineur',
    'd-sharp-minor-natural': 'Ré# naturel mineur',
    'e-flat-minor-natural': 'Mi♭ naturel mineur',
    'e-minor-natural': 'Mi naturel mineur',
    'e-sharp-minor-natural': 'Mi# naturel mineur',
    'f-minor-natural': 'Fa naturel mineur',
    'f-sharp-minor-natural': 'Fa# naturel mineur',
    'g-flat-minor-natural': 'Sol♭ naturel mineur',
    'g-minor-natural': 'Sol naturel mineur',
    'g-sharp-minor-natural': 'Sol# naturel mineur',
    'a-flat-minor-natural': 'La♭ naturel mineur',
    'a-minor-natural': 'La naturel mineur',
    'a-sharp-minor-natural': 'La# naturel mineur',
    'b-flat-minor-natural': 'Si♭ naturel mineur',
    'b-minor-natural': 'Si naturel mineur',
    'b-sharp-minor-natural': 'Si# naturel mineur',
    // Minor (Melodic)
    'c-minor-melodic': 'Do mineur mélodique',
    'c-sharp-minor-melodic': 'Do# mineur mélodique',
    'd-flat-minor-melodic': 'Ré♭ mineur mélodique',
    'd-minor-melodic': 'Ré mineur mélodique',
    'd-sharp-minor-melodic': 'Ré# mineur mélodique',
    'e-flat-minor-melodic': 'Mi♭ mineur mélodique',
    'e-minor-melodic': 'Mi mineur mélodique',
    'e-sharp-minor-melodic': 'Mi# mineur mélodique',
    'f-minor-melodic': 'Fa mineur mélodique',
    'f-sharp-minor-melodic': 'Fa# mineur mélodique',
    'g-flat-minor-melodic': 'Sol♭ mineur mélodique',
    'g-minor-melodic': 'Sol mineur mélodique',
    'g-sharp-minor-melodic': 'Sol# mineur mélodique',
    'a-flat-minor-melodic': 'La♭ mineur mélodique',
    'a-minor-melodic': 'La mineur mélodique',
    'a-sharp-minor-melodic': 'La# mineur mélodique',
    'b-flat-minor-melodic': 'Si♭ mineur mélodique',
    'b-minor-melodic': 'Si mineur mélodique',
    'b-sharp-minor-melodic': 'Si# mineur mélodique',
  },
  practiceModes: {
    scales: 'Gammes',
    chords: 'Accords',
    seventhChords: 'Accords de septième',
    fifths: 'Cycle des quintes',
  },
  pages: {
    practice: {
      scale: {
        title: 'Gamme',
        pingPongHint: 'Mode ping-pong de pratique des gammes',
        hardModeHint: 'Mode difficile',
      },
      mode: {
        title: 'Mode',
        quizModeHint: 'Passer au mode quiz',
        settingsHint: 'Ouvrir les paramètres',
      },
    },
    quiz: {
      title: 'Quiz',
      questions: {
        key: 'Appuyer sur {{key}} sur votre clavier',
        fifth: 'Quelle est la quinte pure de {{key}}',
      },
    },
  },
  settings: {
    title: 'Paramètres',
    options: {
      'show-keyboard': 'Afficher le clavier',
      'mute-sound': 'Couper le son',
      'midi-input-id': 'Entrée MIDI',
      language: 'Langue',
      'is-sentry-on': 'Envoyer les rapports de bug',
    },
  },
}

export default fr
