const en = {
  piano: {
    note: {
      Cb: 'Cb',
      C: 'C',
      'C#': 'C#',
      Db: 'Db',
      D: 'D',
      'D#': 'D#',
      Eb: 'Eb',
      E: 'E',
      'E#': 'E#',
      Fb: 'Fb',
      F: 'F',
      'F#': 'F#',
      Gb: 'Gb',
      G: 'G',
      'G#': 'G#',
      Ab: 'Ab',
      A: 'A',
      'A#': 'A#',
      Bb: 'Bb',
      B: 'B',
      'B#': 'B#',
    },
    numeral: {
      i: 'i',
      I: 'I',
      ii: 'ii',
      iiº: 'iiº',
      II: 'II',
      iii: 'iii',
      III: 'III',
      'III+': 'III+',
      iv: 'iv',
      IV: 'IV',
      v: 'v',
      V: 'V',
      vi: 'vi',
      viº: 'viº',
      VI: 'VI',
      viiº: 'viiº',
      VII: 'VII',
    },
  },
  scales: {
    // Major
    'c-flat-major': 'Cb Major',
    'c-major': 'C Major',
    'c-sharp-major': 'C# Major',
    'd-flat-major': 'Db Major',
    'd-major': 'D Major',
    'd-sharp-major': 'D# Major',
    'e-flat-major': 'Eb Major',
    'e-major': 'E Major',
    'e-sharp-major': 'E# Major',
    'f-flat-major': 'Fb Major',
    'f-major': 'F Major',
    'f-sharp-major': 'F# Major',
    'g-flat-major': 'Gb Major',
    'g-major': 'G Major',
    'g-sharp-major': 'G# Major',
    'a-flat-major': 'Ab Major',
    'a-major': 'A Major',
    'a-sharp-major': 'A# Major',
    'b-flat-major': 'Bb Major',
    'b-major': 'B Major',
    'b-sharp-major': 'B# Major',
    // Minor (Natural)
    'c-minor-natural': 'C Natural Minor',
    'c-sharp-minor-natural': 'C# Natural Minor',
    'd-flat-minor-natural': 'Db Natural Minor',
    'd-minor-natural': 'D Natural Minor',
    'd-sharp-minor-natural': 'D# Natural Minor',
    'e-flat-minor-natural': 'Eb Natural Minor',
    'e-minor-natural': 'E Natural Minor',
    'e-sharp-minor-natural': 'E# Natural Minor',
    'f-minor-natural': 'F Natural Minor',
    'f-sharp-minor-natural': 'F# Natural Minor',
    'g-flat-minor-natural': 'Gb Natural Minor',
    'g-minor-natural': 'G Natural Minor',
    'g-sharp-minor-natural': 'G# Natural Minor',
    'a-flat-minor-natural': 'Ab Natural Minor',
    'a-minor-natural': 'A Natural Minor',
    'a-sharp-minor-natural': 'A# Natural Minor',
    'b-flat-minor-natural': 'Bb Natural Minor',
    'b-minor-natural': 'B Natural Minor',
    'b-sharp-minor-natural': 'B# Natural Minor',
    // Minor (Melodic)
    'c-minor-melodic': 'C Melodic Minor',
    'c-sharp-minor-melodic': 'C# Melodic Minor',
    'd-flat-minor-melodic': 'Db Melodic Minor',
    'd-minor-melodic': 'D Melodic Minor',
    'd-sharp-minor-melodic': 'D# Melodic Minor',
    'e-flat-minor-melodic': 'Eb Melodic Minor',
    'e-minor-melodic': 'E Melodic Minor',
    'e-sharp-minor-melodic': 'E# Melodic Minor',
    'f-minor-melodic': 'F Melodic Minor',
    'f-sharp-minor-melodic': 'F# Melodic Minor',
    'g-flat-minor-melodic': 'Gb Melodic Minor',
    'g-minor-melodic': 'G Melodic Minor',
    'g-sharp-minor-melodic': 'G# Melodic Minor',
    'a-flat-minor-melodic': 'Ab Melodic Minor',
    'a-minor-melodic': 'A Melodic Minor',
    'a-sharp-minor-melodic': 'A# Melodic Minor',
    'b-flat-minor-melodic': 'Bb Melodic Minor',
    'b-minor-melodic': 'B Melodic Minor',
    'b-sharp-minor-melodic': 'B# Melodic Minor',
  },
  practiceModes: {
    scales: 'Scales',
    chords: 'Chords',
    seventhChords: 'Seventh Chords',
    fifths: 'Fifths',
  },
  pages: {
    practice: {
      scale: {
        title: 'Scale',
        pingPongHint: 'Toggle ping-pong scale practice',
        hardModeHint: 'Toggle hard mode',
      },
      mode: {
        title: 'Mode',
        quizModeHint: 'Switch to quiz mode',
        settingsHint: 'Open settings',
      },
    },
    quiz: {
      title: 'Quiz',
      questions: {
        key: 'Press {{key}} on your keyboard',
        fifth: 'Which is a perfect fifth of {{key}}',
      },
    },
  },
  settings: {
    title: 'Settings',
    options: {
      'show-keyboard': 'Show keyboard',
      'mute-sound': 'Mute sound',
      'midi-input-id': 'MIDI input',
      language: 'Language',
      'is-sentry-on': 'Send crash reports',
      'piano-sound': 'Piano sound',
      sounds: {
        acoustic_grand_piano: 'Grand Piano',
        brass_section: 'Brass Section',
        church_organ: 'Church Organ',
        flute: 'Flute',
        ocarina: 'Ocarina',
        french_horn: 'French Horn',
        acoustic_bass: 'Acoustic Bass',
        electric_bass_finger: 'Electric Bass',
        synth_strings_2: 'Synth Strings',
        clavinet: 'Clavinet',
        lead_2_sawtooth: 'Lead Sawtooth',
        music_box: 'Music Box',
        xylophone: 'Xylophone',
        violin: 'Violin',
        vibraphone: 'Vibraphone',
      },
    },
  },
}

export default en
