//
//  MSMarcoFixture.swift
//
//
//  Created by Zach Nagengast on 4/13/23.
//

import Foundation
import XCTest

struct PassageData: Codable {
    let answers: [String]
    let passages: Passages
    let query: String
    let queryId: Int
    let queryType: String
    let wellFormedAnswers: [String]

    enum CodingKeys: String, CodingKey {
        case answers
        case passages
        case query
        case queryId = "query_id"
        case queryType = "query_type"
        case wellFormedAnswers
    }
}

struct Passages: Codable {
    let isSelected: [Int]
    let passageText: [String]
    let url: [String]

    enum CodingKeys: String, CodingKey {
        case isSelected = "is_selected"
        case passageText = "passage_text"
        case url
    }
}

struct TestPassage {
    var text: String
    var metadata: [String: String]
    var tokens: [Int]
    var tokenTypeIds: [Int]
    var attentionMask: [Int]
    var embeddings: [Float]
}

func decodeJson(data: Data) -> [PassageData]? {
    let decoder = JSONDecoder()
    do {
        let passageData = try decoder.decode([PassageData].self, from: data)
        return passageData
    } catch {
        print("Error decoding JSON: \(error)")
        return nil
    }
}

struct MSMarco {
    static let passages: [Passages] = {
        var jsonData: Data?

        let bundle = Bundle.module
        if let jsonUrl = bundle.url(forResource: "ms_marco_validation_v2.1_subset", withExtension: "json") {
            do {
                jsonData = try Data(contentsOf: jsonUrl)
            } catch {
                print("Failed to load JSON data from bundle: \(bundle)")
            }
        }

        guard let unwrappedJsonData = jsonData else {
            fatalError("Failed to find and load JSON data from all available bundles.")
        }

        var passages: [Passages] = []
        if let passageData = decodeJson(data: unwrappedJsonData) {
            for entry in passageData {
                passages.append(entry.passages)
            }
        }

        return passages
    }()

    static let passageTexts: [String] = {
        var passageTexts: [String] = []
        for passage in passages {
            passageTexts.append(contentsOf: passage.passageText)
        }

        return passageTexts
    }()

    static let passageUrls: [String] = {
        var passageUrls: [String] = []
        for passage in passages {
            passageUrls.append(contentsOf: passage.url)
        }

        return passageUrls
    }()

    static let testPassage: TestPassage = {
        var comparisons = TestPassage(
            text: "This is a test sentence, which can be used for making sure the model is encoding things correctly",
            metadata: ["source": "https://www.test.com/test"],
            tokens: [101, 2023, 2003, 1037, 3231, 6251, 1010, 2029, 2064, 2022, 2109, 2005, 2437, 2469, 1996, 2944, 2003, 17181, 2477, 11178, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            tokenTypeIds: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1],
            attentionMask: [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            embeddings: [0.27148438, -0.12084961, -0.21203613, 0.25610352, 0.60253906, 0.15734863, 0.13903809, -0.28833008, -0.031707764, 0.15563965, -0.24865723, 0.072753906, -0.23950195, -0.053771973, -0.12365723, 0.070373535, -0.030593872, -0.017044067, 0.3876953, 0.043823242, -0.19604492, 0.23095703, -0.41186523, 0.024002075, 0.15039062, -0.40527344, 0.18579102, 0.15209961, -0.45336914, 0.2253418, -0.08062744, 0.072509766, 0.24389648, -0.2376709, 0.09625244, 0.4255371, -0.33007812, 0.049316406, 0.0848999, -0.34936523, -0.07910156, -0.20751953, -0.20910645, 0.17419434, -0.24121094, 0.2130127, -0.3034668, -0.23547363, -0.105773926, -0.020828247, -0.04067993, 0.5522461, -0.27197266, 0.026321411, -0.54589844, -0.20935059, 0.33862305, -0.5136719, 0.3022461, -0.09765625, 0.23059082, 0.060028076, -0.24694824, -0.33666992, 0.1763916, -0.040496826, 0.25073242, -0.08325195, -0.49145508, -0.2121582, -0.08679199, -0.06561279, -0.31469727, -0.09185791, -0.08001709, -0.040283203, 0.042053223, 0.2541504, 0.17834473, 0.10119629, -0.18908691, 0.109069824, -0.28271484, 0.092285156, 0.49291992, 0.06762695, 0.14855957, 0.22680664, -0.3413086, 0.37036133, -0.24060059, 0.1517334, -0.3083496, -0.011764526, -0.08630371, 0.038635254, -0.2479248, -0.2019043, 0.07470703, 0.2097168, -0.021850586, -0.5415039, 0.41552734, 0.37768555, -0.017410278, 0.011428833, -0.111572266, -0.013366699, 0.105895996, 0.3869629, 0.34179688, -0.103149414, 0.37060547, 0.029907227, -0.19519043, -0.34765625, -0.47680664, 0.1829834, -0.22045898, 0.38549805, 0.08404541, 0.109680176, -0.07702637, 0.023086548, 0.20288086, 0.11407471, 0.28759766, 0.32714844, -0.15856934, -0.21142578, 0.0103302, 0.2475586, 0.026000977, 0.13452148, -0.03717041, -0.0072784424, -0.37548828, -0.21154785, -0.28393555, 0.070617676, 0.10406494, 0.14318848, 0.24169922, 0.030563354, -0.10845947, 0.19836426, 0.029083252, 0.4025879, 0.11077881, -0.05847168, 0.14746094, 0.23339844, -0.11230469, -0.20935059, -0.03479004, 0.38232422, -0.27172852, 0.14526367, -0.25170898, 0.00932312, 0.04473877, 0.10418701, -0.25146484, 0.064819336, 0.26489258, 0.068725586, 0.17602539, 0.16223145, -0.20776367, -0.068725586, -0.036987305, 0.027420044, 0.11816406, -0.23962402, -0.4699707, -0.023284912, 0.17224121, 0.10510254, -0.13745117, -0.035369873, -0.23303223, 0.22277832, -0.2722168, 0.1184082, 0.0003323555, -0.038848877, -0.3383789, -0.5566406, -0.3095703, -0.26000977, -0.0020389557, -0.13024902, -0.12731934, -0.26611328, 0.33374023, 0.03778076, 0.09210205, 0.5473633, -0.42211914, 0.26953125, -0.0032577515, 0.34936523, -0.043395996, -0.23010254, -0.05026245, -0.27319336, 0.023101807, -0.26000977, -0.42529297, 0.013809204, -0.44726562, 0.2442627, 0.10845947, -0.1027832, -0.31347656, -0.30273438, 0.01687622, 0.2993164, 0.023101807, -0.3347168, 0.083984375, 0.09979248, -0.40576172, -0.02532959, -0.22192383, -0.0069618225, 0.18530273, -0.058410645, 0.38256836, -0.072021484, -0.09954834, -0.050231934, -0.02078247, -0.029693604, -0.30517578, 0.06628418, 0.12634277, 0.2685547, -0.046020508, -0.14453125, -0.05621338, -0.011749268, -0.23120117, 0.25170898, 0.032196045, -0.075805664, 0.007068634, 0.08477783, 0.013847351, 0.08416748, -0.32788086, 0.097351074, -0.14196777, -0.10827637, -0.3972168, -0.25610352, -0.20336914, 0.043884277, -0.1706543, 0.2512207, 0.1459961, -0.008232117, -0.14868164, -0.32177734, -0.075683594, -0.2232666, 0.09411621, 0.02507019, -0.06555176, 0.12384033, 0.28393555, -0.08117676, -0.069885254, 0.06311035, 0.10266113, -0.015945435, -0.004131317, 0.65527344, 0.08648682, -0.26635742, -0.08300781, -0.11755371, 0.21826172, 0.3828125, 0.10101318, 0.0009880066, -0.06677246, 0.36938477, -0.072509766, -0.11590576, 0.32788086, 0.43237305, -0.06604004, -0.0881958, 0.11584473, 0.13989258, -0.08935547, -0.09289551, -0.012367249, 0.11248779, -0.30615234, 0.30395508, 0.12371826, 0.097473145, 0.060058594, 0.5073242, -0.020507812, 0.4165039, -8.6015625, 0.05911255, -0.0034332275, -0.23803711, 0.17553711, 0.1015625, -0.12561035, 0.030258179, -0.09881592, -0.059173584, -0.38256836, 0.06591797, -0.3154297, 0.3527832, -0.20996094, -0.02330017, -0.0647583, -0.3527832, 0.15930176, 0.43530273, -0.123168945, -0.08648682, 0.0703125, 0.111328125, -0.4194336, -0.19555664, -0.32055664, 0.11633301, 0.06298828, -0.359375, 0.014045715, -0.40478516, 0.0715332, -0.008460999, -0.21130371, 0.1038208, 0.009490967, -0.32104492, 0.087402344, 0.15661621, -0.109069824, -0.088378906, 0.19836426, -0.19006348, -0.09552002, 0.2644043, 0.006038666, 0.17956543, 0.1973877, -0.43774414, 0.12866211, 0.30004883, -0.05050659, 0.24719238, -0.025619507, -0.15979004, 0.27026367, -0.07763672, -0.042022705, -0.23815918, -0.06021118, -0.46166992, -0.49902344, -0.4807129, 0.16223145, -0.3371582, -0.040740967, -0.31152344, -0.13427734, -0.04537964, -0.3503418, -0.07757568, -0.08331299, -0.9682617, -0.0869751, -0.27148438, 0.17443848, 0.17126465, -0.1730957, 0.13952637, -0.2154541, -0.49682617, 0.0012083054, 0.07055664, 0.4855957, -0.1685791, -0.61376953, 0.24279785, 0.30908203, -0.119384766, 0.41601562, -0.054138184, 0.014404297, -0.07159424, -0.10443115, -0.082214355, 0.39624023, 0.0090408325, 0.16772461, 0.016906738, -0.3930664, -0.23547363, 0.15588379, 0.15466309, -0.17260742, 0.017089844, -0.16320801, -0.03515625, 0.3383789, 0.0040130615, 0.037109375, -0.12585449, 0.12963867, 0.024734497, 0.17602539, -0.1619873, 0.26391602, 0.066345215, 0.28466797, 0.039733887, -0.17907715, -0.08496094, -0.06713867, 0.122924805, -0.12548828, -0.3569336, 0.18164062, 0.10266113, -0.074401855, -0.04498291, -0.08502197, 0.17749023, 0.10925293, 0.0847168, 0.3178711, 0.0010156631, -0.04031372, 0.15588379, -0.01737976, 0.056610107, 0.30029297, -0.03857422, 0.06628418, -0.16687012, -0.013969421, 0.014511108, 0.111694336, -0.15734863, -0.05368042, -0.08807373, -0.03161621, 0.088134766, 0.06854248, -0.2993164, 0.3713379, 0.2824707, -0.18859863, -0.65234375, 0.14953613, -0.08178711, 0.14990234, 0.03604126, 0.034820557, 0.1159668, -0.16271973, -0.109436035, -0.096191406, 0.07409668, 0.092285156, 0.2578125, -0.24450684, -0.09838867, 0.08013916, 0.23669434, 0.11437988, 0.40527344, 0.08343506, -0.15930176, -0.050079346, 0.23266602, -0.36499023, -0.10675049, -0.05670166, -0.36621094, 0.38134766, 0.05407715, 0.42163086, 0.45458984, -0.19482422, -0.27368164, 0.10913086, 0.1628418, -0.1887207, -0.015823364, -0.28686523, 0.08166504, 0.087402344, 0.06762695, 0.20581055, 0.17504883, -0.06427002, -0.111816406, 0.035217285, 0.010261536, 0.014633179, -0.33129883, -0.08758545, 0.49487305, 0.28637695, -0.11584473, 0.10662842, -0.28686523, -0.1430664, -0.017364502, 0.16442871, -0.10003662, 0.25463867, 0.004360199, 0.05593872, 0.020065308, 0.024368286, -0.17944336, 0.023834229, -0.02659607, 0.07922363, -0.25732422, -0.20422363, -0.19494629, 0.0013780594, 0.34350586, -0.10131836, 0.32226562, -0.3642578, 0.107788086, -0.27929688, -0.5961914, -0.015533447, -0.121154785, -0.115600586, -0.034729004, 0.10913086, 0.2770996, -0.026641846, -0.38623047, -0.08746338, 0.054779053, 0.2775879, 0.35620117, -0.0027370453, 0.12231445, -0.018325806, -0.22924805, -0.4050293, 0.21081543, 0.44262695, -0.1517334, 0.17260742, 0.10479736, -0.40600586, -0.08630371, 0.16381836, -0.13659668, -0.5, -0.19580078, -0.018493652, 0.28393555, 0.096069336, 0.27197266, 0.14733887, -0.3215332, 0.5415039, -0.24182129, 0.18347168, 0.37768555, 0.017410278, 0.00573349, -0.17114258, 0.4243164, 0.09246826, 0.0748291, -0.117614746, -0.12188721, -0.107299805, 0.22351074, -0.05834961, -0.33129883, 0.23986816, 0.030761719, 0.25170898, -0.22265625, -0.23266602, 0.4206543, -0.119628906, 0.26831055, -0.39379883, -0.20153809, 0.38989258, 0.19238281, 0.08770752, -0.3959961, 0.09539795, 0.15112305, 0.3100586, -0.18859863, -0.22729492, -0.09509277, -0.044067383, -0.019195557, -0.15783691, 0.013946533, 0.3395996, 0.052520752, 0.39331055, 0.059417725, 0.1862793, -0.16540527, 0.11553955, -0.2446289, 0.2849121, 0.24060059, -0.08544922, -0.171875, 0.26904297, -0.12963867, -0.515625, 0.15283203, 0.018707275, 0.057128906, -0.057434082, 0.2614746, 0.024612427, 0.12731934, 0.40234375, 0.27368164, -0.5253906, -0.18395996, 0.14526367, 0.05218506, 0.46704102, -0.20593262, 0.050689697, 0.07928467, -0.50341797, -0.18310547, 0.121154785, -0.1595459, 0.14819336, 0.31274414, -0.44506836, 0.09503174, -0.09967041, 0.25, 0.43408203, 0.039886475, 0.2244873, -0.00248909, -0.060791016, 0.05178833, 0.055755615, 0.43408203, -0.1595459, 0.039642334, 0.37451172, 0.1763916, -0.17004395, 0.15881348, 0.12335205, 0.25708008, 0.31079102, -0.19262695, -0.06536865, -0.10028076, -0.053710938, -0.034698486, -0.16894531, 0.48510742, -0.21142578, 0.04888916, -0.23254395, 0.0019931793, -0.031204224, 0.35864258, 0.20788574, 0.039367676, 0.13122559, -0.04208374, 0.09564209, 0.20263672, 0.06173706, 0.01550293, -0.46362305, -0.08746338, 0.13928223, 0.60302734, 0.20703125, 0.091430664, -0.0524292, -0.022277832, 0.33276367, 0.11529541, 0.1809082, -0.29370117, 0.10772705, -0.06402588, 0.094055176, 0.30737305, 0.3383789, 0.24304199, 0.114868164, -0.15881348, 0.3864746, 0.09881592, -0.21154785, 0.08074951, -0.5810547, -0.11975098, -0.019226074, -0.01260376, 0.34106445, 0.09112549, -0.5698242, 0.2010498, -0.012268066, -0.17687988, -0.14978027, 0.61865234, 0.20227051, 0.04345703, -0.46850586, -0.14941406, 0.0073547363, -0.19396973, 0.04901123, 0.28955078, -0.3100586, -0.032714844, -0.18518066, 0.0859375, -0.018676758, 0.08282471, -0.14575195, 0.1538086, -0.03564453, 0.11303711, 0.453125, 0.38134766, 0.06604004, -0.114868164, -0.008682251, 0.06530762, 0.0026378632, -0.23547363, -0.11804199, -0.1907959, -0.27294922, 0.3095703, 0.37158203, -0.15319824, -0.14111328, -0.15039062]
        )

        return comparisons
    }()
}
