#!/bin/sh

set -e

if command -v realpath >/dev/null 2>&1
then
    readonly script_dir="$(dirname "$(realpath "$0")")"
else
    readonly script_dir="$(cd "$(dirname "$0")" && pwd)"
fi

dotnet restore ./RabbitMQDotNetClient.sln
dotnet run -p "$script_dir/projects/client/Apigen/Apigen.csproj" --apiName:AMQP_0_9_1 \
    "$script_dir/docs/specs/amqp0-9-1.stripped.xml" \
    "$script_dir/gensrc/autogenerated-api-0-9-1.cs"

if command -v msbuild >/dev/null 2>&1
then
    # we have to use msbuild or else multi-targeting doesn't work
    msbuild "$script_dir/projects/client/RabbitMQ.Client/RabbitMQ.Client.csproj"
else
    dotnet msbuild "$script_dir/projects/client/RabbitMQ.Client/RabbitMQ.Client.csproj"
fi
dotnet build "$script_dir/projects/client/Unit/Unit.csproj"
