## Proposed Changes

Please describe the big picture of your changes here to communicate to the
RabbitMQ team why we should accept this pull request. If it fixes a bug or
resolves a feature request, be sure to link to that issue.

A pull request that doesn't explain **why** the change was made has a much
lower chance of being accepted.

If English isn't your first language, don't worry about it and try to
communicate the problem you are trying to solve to the best of your abilities.
As long as we can understand the intent, it's all good.

## Types of Changes

What types of changes does your code introduce to this project?
_Put an `x` in the boxes that apply_

- [ ] Bugfix (non-breaking change which fixes issue #NNNN)
- [ ] New feature (non-breaking change which adds functionality)
- [ ] Breaking change (fix or feature that would cause existing functionality to not work as expected)
- [ ] Documentation (correction or otherwise)
- [ ] Cosmetics (whitespace, appearance)

## Checklist

_Put an `x` in the boxes that apply. You can also fill these out after creating
the PR. If you're unsure about any of them, don't hesitate to ask on the
mailing list. We're here to help! This is simply a reminder of what we are
going to look for before merging your code._

- [ ] I have read the `CONTRIBUTING.md` document
- [ ] I have signed the CA (see https://cla.pivotal.io/sign/rabbitmq)
- [ ] All tests pass locally with my changes
- [ ] I have added tests that prove my fix is effective or that my feature works
- [ ] I have added necessary documentation (if appropriate)
- [ ] Any dependent changes have been merged and published in related repositories

## Further Comments

If this is a relatively large or complex change, kick off the discussion by
explaining why you chose the solution you did and what alternatives you
considered, etc.
