/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.pathprovider;

import android.content.Context;
import android.os.Environment;
import io.flutter.plugin.common.MethodCall;
import io.flutter.plugin.common.MethodChannel;
import io.flutter.plugin.common.PluginRegistry;
import io.flutter.util.PathUtils;

public class PathProviderPlugin
implements MethodChannel.MethodCallHandler {
    private final PluginRegistry.Registrar mRegistrar;

    public static void registerWith(PluginRegistry.Registrar registrar) {
        MethodChannel channel = new MethodChannel(registrar.messenger(), "plugins.flutter.io/path_provider");
        PathProviderPlugin instance = new PathProviderPlugin(registrar);
        channel.setMethodCallHandler((MethodChannel.MethodCallHandler)instance);
    }

    private PathProviderPlugin(PluginRegistry.Registrar registrar) {
        this.mRegistrar = registrar;
    }

    public void onMethodCall(MethodCall call, MethodChannel.Result result) {
        switch (call.method) {
            case "getTemporaryDirectory": {
                result.success((Object)this.getPathProviderTemporaryDirectory());
                break;
            }
            case "getApplicationDocumentsDirectory": {
                result.success((Object)this.getPathProviderApplicationDocumentsDirectory());
                break;
            }
            case "getStorageDirectory": {
                result.success((Object)this.getPathProviderStorageDirectory());
                break;
            }
            default: {
                result.notImplemented();
            }
        }
    }

    private String getPathProviderTemporaryDirectory() {
        return this.mRegistrar.context().getCacheDir().getPath();
    }

    private String getPathProviderApplicationDocumentsDirectory() {
        return PathUtils.getDataDirectory((Context)this.mRegistrar.context());
    }

    private String getPathProviderStorageDirectory() {
        return Environment.getExternalStorageDirectory().getAbsolutePath();
    }
}

