/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.camera;

import android.app.Activity;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.media.CamcorderProfile;
import android.util.Size;
import io.flutter.plugins.camera.Camera;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class CameraUtils {
    private CameraUtils() {
    }

    static Size computeBestPreviewSize(String cameraName, Camera.ResolutionPreset preset) {
        if (preset.ordinal() > Camera.ResolutionPreset.high.ordinal()) {
            preset = Camera.ResolutionPreset.high;
        }
        CamcorderProfile profile = CameraUtils.getBestAvailableCamcorderProfileForResolutionPreset(cameraName, preset);
        return new Size(profile.videoFrameWidth, profile.videoFrameHeight);
    }

    static Size computeBestCaptureSize(StreamConfigurationMap streamConfigurationMap) {
        return Collections.max(Arrays.asList(streamConfigurationMap.getOutputSizes(256)), new CompareSizesByArea());
    }

    public static List<Map<String, Object>> getAvailableCameras(Activity activity) throws CameraAccessException {
        CameraManager cameraManager = (CameraManager)activity.getSystemService("camera");
        String[] cameraNames = cameraManager.getCameraIdList();
        ArrayList<Map<String, Object>> cameras = new ArrayList<Map<String, Object>>();
        for (String cameraName : cameraNames) {
            HashMap<String, Object> details = new HashMap<String, Object>();
            CameraCharacteristics characteristics = cameraManager.getCameraCharacteristics(cameraName);
            details.put("name", cameraName);
            int sensorOrientation = (Integer)characteristics.get(CameraCharacteristics.SENSOR_ORIENTATION);
            details.put("sensorOrientation", sensorOrientation);
            int lensFacing = (Integer)characteristics.get(CameraCharacteristics.LENS_FACING);
            switch (lensFacing) {
                case 0: {
                    details.put("lensFacing", "front");
                    break;
                }
                case 1: {
                    details.put("lensFacing", "back");
                    break;
                }
                case 2: {
                    details.put("lensFacing", "external");
                }
            }
            cameras.add(details);
        }
        return cameras;
    }

    static CamcorderProfile getBestAvailableCamcorderProfileForResolutionPreset(String cameraName, Camera.ResolutionPreset preset) {
        int cameraId = Integer.parseInt(cameraName);
        switch (preset) {
            case max: {
                if (CamcorderProfile.hasProfile((int)cameraId, (int)1)) {
                    return CamcorderProfile.get((int)1);
                }
            }
            case ultraHigh: {
                if (CamcorderProfile.hasProfile((int)cameraId, (int)8)) {
                    return CamcorderProfile.get((int)8);
                }
            }
            case veryHigh: {
                if (CamcorderProfile.hasProfile((int)cameraId, (int)6)) {
                    return CamcorderProfile.get((int)6);
                }
            }
            case high: {
                if (CamcorderProfile.hasProfile((int)cameraId, (int)5)) {
                    return CamcorderProfile.get((int)5);
                }
            }
            case medium: {
                if (CamcorderProfile.hasProfile((int)cameraId, (int)4)) {
                    return CamcorderProfile.get((int)4);
                }
            }
            case low: {
                if (!CamcorderProfile.hasProfile((int)cameraId, (int)7)) break;
                return CamcorderProfile.get((int)7);
            }
        }
        if (CamcorderProfile.hasProfile((int)Integer.parseInt(cameraName), (int)0)) {
            return CamcorderProfile.get((int)0);
        }
        throw new IllegalArgumentException("No capture session available for current capture session.");
    }

    private static class CompareSizesByArea
    implements Comparator<Size> {
        private CompareSizesByArea() {
        }

        @Override
        public int compare(Size lhs, Size rhs) {
            return Long.signum((long)lhs.getWidth() * (long)lhs.getHeight() - (long)rhs.getWidth() * (long)rhs.getHeight());
        }
    }
}

