/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.camera;

import android.hardware.camera2.CameraAccessException;
import android.os.Build;
import androidx.annotation.NonNull;
import io.flutter.plugin.common.EventChannel;
import io.flutter.plugin.common.MethodCall;
import io.flutter.plugin.common.MethodChannel;
import io.flutter.plugin.common.PluginRegistry;
import io.flutter.plugins.camera.Camera;
import io.flutter.plugins.camera.CameraPermissions;
import io.flutter.plugins.camera.CameraUtils;
import io.flutter.view.FlutterView;

public class CameraPlugin
implements MethodChannel.MethodCallHandler {
    private final CameraPermissions cameraPermissions = new CameraPermissions();
    private final FlutterView view;
    private final PluginRegistry.Registrar registrar;
    private final EventChannel imageStreamChannel;
    private Camera camera;

    private CameraPlugin(PluginRegistry.Registrar registrar) {
        this.registrar = registrar;
        this.view = registrar.view();
        this.imageStreamChannel = new EventChannel(registrar.messenger(), "plugins.flutter.io/camera/imageStream");
    }

    public static void registerWith(PluginRegistry.Registrar registrar) {
        if (Build.VERSION.SDK_INT < 21) {
            return;
        }
        MethodChannel channel = new MethodChannel(registrar.messenger(), "plugins.flutter.io/camera");
        channel.setMethodCallHandler((MethodChannel.MethodCallHandler)new CameraPlugin(registrar));
    }

    private void instantiateCamera(MethodCall call, MethodChannel.Result result) throws CameraAccessException {
        String cameraName = (String)call.argument("cameraName");
        String resolutionPreset = (String)call.argument("resolutionPreset");
        boolean enableAudio = (Boolean)call.argument("enableAudio");
        this.camera = new Camera(this.registrar.activity(), this.view, cameraName, resolutionPreset, enableAudio);
        EventChannel cameraEventChannel = new EventChannel(this.registrar.messenger(), "flutter.io/cameraPlugin/cameraEvents" + this.camera.getFlutterTexture().id());
        this.camera.setupCameraEventChannel(cameraEventChannel);
        this.camera.open(result);
    }

    public void onMethodCall(@NonNull MethodCall call, @NonNull MethodChannel.Result result) {
        switch (call.method) {
            case "availableCameras": {
                try {
                    result.success(CameraUtils.getAvailableCameras(this.registrar.activity()));
                }
                catch (Exception e) {
                    this.handleException(e, result);
                }
                break;
            }
            case "initialize": {
                if (this.camera != null) {
                    this.camera.close();
                }
                this.cameraPermissions.requestPermissions(this.registrar, (Boolean)call.argument("enableAudio"), (errCode, errDesc) -> {
                    if (errCode == null) {
                        try {
                            this.instantiateCamera(call, result);
                        }
                        catch (Exception e) {
                            this.handleException(e, result);
                        }
                    } else {
                        result.error(errCode, errDesc, null);
                    }
                });
                break;
            }
            case "takePicture": {
                this.camera.takePicture((String)call.argument("path"), result);
                break;
            }
            case "prepareForVideoRecording": {
                result.success(null);
                break;
            }
            case "startVideoRecording": {
                this.camera.startVideoRecording((String)call.argument("filePath"), result);
                break;
            }
            case "stopVideoRecording": {
                this.camera.stopVideoRecording(result);
                break;
            }
            case "pauseVideoRecording": {
                this.camera.pauseVideoRecording(result);
                break;
            }
            case "resumeVideoRecording": {
                this.camera.resumeVideoRecording(result);
                break;
            }
            case "startImageStream": {
                try {
                    this.camera.startPreviewWithImageStream(this.imageStreamChannel);
                    result.success(null);
                }
                catch (Exception e) {
                    this.handleException(e, result);
                }
                break;
            }
            case "stopImageStream": {
                try {
                    this.camera.startPreview();
                    result.success(null);
                }
                catch (Exception e) {
                    this.handleException(e, result);
                }
                break;
            }
            case "dispose": {
                if (this.camera != null) {
                    this.camera.dispose();
                }
                result.success(null);
                break;
            }
            default: {
                result.notImplemented();
            }
        }
    }

    private void handleException(Exception exception, MethodChannel.Result result) {
        if (exception instanceof CameraAccessException) {
            result.error("CameraAccess", exception.getMessage(), null);
        }
        throw (RuntimeException)exception;
    }
}

