/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.firebasemlvision;

import androidx.annotation.NonNull;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.firebase.ml.vision.FirebaseVision;
import com.google.firebase.ml.vision.common.FirebaseVisionImage;
import com.google.firebase.ml.vision.common.FirebaseVisionPoint;
import com.google.firebase.ml.vision.face.FirebaseVisionFace;
import com.google.firebase.ml.vision.face.FirebaseVisionFaceContour;
import com.google.firebase.ml.vision.face.FirebaseVisionFaceDetector;
import com.google.firebase.ml.vision.face.FirebaseVisionFaceDetectorOptions;
import com.google.firebase.ml.vision.face.FirebaseVisionFaceLandmark;
import io.flutter.plugin.common.MethodChannel;
import io.flutter.plugins.firebasemlvision.Detector;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class FaceDetector
implements Detector {
    private final FirebaseVisionFaceDetector detector;

    FaceDetector(FirebaseVision vision, Map<String, Object> options) {
        this.detector = vision.getVisionFaceDetector(this.parseOptions(options));
    }

    @Override
    public void handleDetection(FirebaseVisionImage image, final MethodChannel.Result result) {
        this.detector.detectInImage(image).addOnSuccessListener((OnSuccessListener)new OnSuccessListener<List<FirebaseVisionFace>>(){

            public void onSuccess(List<FirebaseVisionFace> firebaseVisionFaces) {
                ArrayList faces = new ArrayList(firebaseVisionFaces.size());
                for (FirebaseVisionFace face : firebaseVisionFaces) {
                    HashMap<String, Object> faceData = new HashMap<String, Object>();
                    faceData.put("left", Double.valueOf(face.getBoundingBox().left));
                    faceData.put("top", Double.valueOf(face.getBoundingBox().top));
                    faceData.put("width", Double.valueOf(face.getBoundingBox().width()));
                    faceData.put("height", Double.valueOf(face.getBoundingBox().height()));
                    faceData.put("headEulerAngleY", Float.valueOf(face.getHeadEulerAngleY()));
                    faceData.put("headEulerAngleZ", Float.valueOf(face.getHeadEulerAngleZ()));
                    if (face.getSmilingProbability() != -1.0f) {
                        faceData.put("smilingProbability", Float.valueOf(face.getSmilingProbability()));
                    }
                    if (face.getLeftEyeOpenProbability() != -1.0f) {
                        faceData.put("leftEyeOpenProbability", Float.valueOf(face.getLeftEyeOpenProbability()));
                    }
                    if (face.getRightEyeOpenProbability() != -1.0f) {
                        faceData.put("rightEyeOpenProbability", Float.valueOf(face.getRightEyeOpenProbability()));
                    }
                    if (face.getTrackingId() != -1) {
                        faceData.put("trackingId", face.getTrackingId());
                    }
                    faceData.put("landmarks", FaceDetector.this.getLandmarkData(face));
                    faceData.put("contours", FaceDetector.this.getContourData(face));
                    faces.add(faceData);
                }
                result.success(faces);
            }
        }).addOnFailureListener(new OnFailureListener(){

            public void onFailure(@NonNull Exception exception) {
                result.error("faceDetectorError", exception.getLocalizedMessage(), null);
            }
        });
    }

    private Map<String, double[]> getLandmarkData(FirebaseVisionFace face) {
        HashMap<String, double[]> landmarks = new HashMap<String, double[]>();
        landmarks.put("bottomMouth", this.landmarkPosition(face, 0));
        landmarks.put("leftCheek", this.landmarkPosition(face, 1));
        landmarks.put("leftEar", this.landmarkPosition(face, 3));
        landmarks.put("leftEye", this.landmarkPosition(face, 4));
        landmarks.put("leftMouth", this.landmarkPosition(face, 5));
        landmarks.put("noseBase", this.landmarkPosition(face, 6));
        landmarks.put("rightCheek", this.landmarkPosition(face, 7));
        landmarks.put("rightEar", this.landmarkPosition(face, 9));
        landmarks.put("rightEye", this.landmarkPosition(face, 10));
        landmarks.put("rightMouth", this.landmarkPosition(face, 11));
        return landmarks;
    }

    private Map<String, List<double[]>> getContourData(FirebaseVisionFace face) {
        HashMap<String, List<double[]>> contours = new HashMap<String, List<double[]>>();
        contours.put("allPoints", this.contourPosition(face, 1));
        contours.put("face", this.contourPosition(face, 2));
        contours.put("leftEye", this.contourPosition(face, 7));
        contours.put("leftEyebrowBottom", this.contourPosition(face, 4));
        contours.put("leftEyebrowTop", this.contourPosition(face, 3));
        contours.put("lowerLipBottom", this.contourPosition(face, 12));
        contours.put("lowerLipTop", this.contourPosition(face, 11));
        contours.put("noseBottom", this.contourPosition(face, 14));
        contours.put("noseBridge", this.contourPosition(face, 13));
        contours.put("rightEye", this.contourPosition(face, 8));
        contours.put("rightEyebrowBottom", this.contourPosition(face, 6));
        contours.put("rightEyebrowTop", this.contourPosition(face, 5));
        contours.put("upperLipBottom", this.contourPosition(face, 10));
        contours.put("upperLipTop", this.contourPosition(face, 9));
        return contours;
    }

    private double[] landmarkPosition(FirebaseVisionFace face, int landmarkInt) {
        FirebaseVisionFaceLandmark landmark = face.getLandmark(landmarkInt);
        if (landmark != null) {
            return new double[]{landmark.getPosition().getX().floatValue(), landmark.getPosition().getY().floatValue()};
        }
        return null;
    }

    private List<double[]> contourPosition(FirebaseVisionFace face, int contourInt) {
        FirebaseVisionFaceContour contour = face.getContour(contourInt);
        if (contour != null) {
            List contourPoints = contour.getPoints();
            ArrayList<double[]> result = new ArrayList<double[]>();
            for (int i = 0; i < contourPoints.size(); ++i) {
                result.add(new double[]{((FirebaseVisionPoint)contourPoints.get(i)).getX().floatValue(), ((FirebaseVisionPoint)contourPoints.get(i)).getY().floatValue()});
            }
            return result;
        }
        return null;
    }

    private FirebaseVisionFaceDetectorOptions parseOptions(Map<String, Object> options) {
        int mode;
        int classification = (Boolean)options.get("enableClassification") != false ? 2 : 1;
        int landmark = (Boolean)options.get("enableLandmarks") != false ? 2 : 1;
        int contours = (Boolean)options.get("enableContours") != false ? 2 : 1;
        switch ((String)options.get("mode")) {
            case "accurate": {
                mode = 2;
                break;
            }
            case "fast": {
                mode = 1;
                break;
            }
            default: {
                throw new IllegalArgumentException("Not a mode:" + options.get("mode"));
            }
        }
        FirebaseVisionFaceDetectorOptions.Builder builder = new FirebaseVisionFaceDetectorOptions.Builder().setClassificationMode(classification).setLandmarkMode(landmark).setContourMode(contours).setMinFaceSize((float)((Double)options.get("minFaceSize")).doubleValue()).setPerformanceMode(mode);
        if (((Boolean)options.get("enableTracking")).booleanValue()) {
            builder.enableTracking();
        }
        return builder.build();
    }

    @Override
    public void close() throws IOException {
        this.detector.close();
    }
}

