/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.camera;

import android.app.Activity;
import android.content.Context;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import io.flutter.plugin.common.PluginRegistry;

public class CameraPermissions {
    private static final int CAMERA_REQUEST_ID = 9796;
    private boolean ongoing = false;

    public void requestPermissions(PluginRegistry.Registrar registrar, boolean enableAudio, ResultCallback callback) {
        Activity activity;
        if (this.ongoing) {
            callback.onResult("cameraPermission", "Camera permission request ongoing");
        }
        if (!this.hasCameraPermission(activity = registrar.activity()) || enableAudio && !this.hasAudioPermission(activity)) {
            String[] stringArray;
            registrar.addRequestPermissionsResultListener((PluginRegistry.RequestPermissionsResultListener)new CameraRequestPermissionsListener((errorCode, errorDescription) -> {
                this.ongoing = false;
                callback.onResult(errorCode, errorDescription);
            }));
            this.ongoing = true;
            if (enableAudio) {
                String[] stringArray2 = new String[2];
                stringArray2[0] = "android.permission.CAMERA";
                stringArray = stringArray2;
                stringArray2[1] = "android.permission.RECORD_AUDIO";
            } else {
                String[] stringArray3 = new String[1];
                stringArray = stringArray3;
                stringArray3[0] = "android.permission.CAMERA";
            }
            ActivityCompat.requestPermissions((Activity)activity, (String[])stringArray, (int)9796);
        } else {
            callback.onResult(null, null);
        }
    }

    private boolean hasCameraPermission(Activity activity) {
        return ContextCompat.checkSelfPermission((Context)activity, (String)"android.permission.CAMERA") == 0;
    }

    private boolean hasAudioPermission(Activity activity) {
        return ContextCompat.checkSelfPermission((Context)activity, (String)"android.permission.RECORD_AUDIO") == 0;
    }

    static interface ResultCallback {
        public void onResult(String var1, String var2);
    }

    private static class CameraRequestPermissionsListener
    implements PluginRegistry.RequestPermissionsResultListener {
        final ResultCallback callback;

        private CameraRequestPermissionsListener(ResultCallback callback) {
            this.callback = callback;
        }

        public boolean onRequestPermissionsResult(int id, String[] permissions, int[] grantResults) {
            if (id == 9796) {
                if (grantResults[0] != 0) {
                    this.callback.onResult("cameraPermission", "MediaRecorderCamera permission not granted");
                } else if (grantResults.length > 1 && grantResults[1] != 0) {
                    this.callback.onResult("cameraPermission", "MediaRecorderAudio permission not granted");
                } else {
                    this.callback.onResult(null, null);
                }
                return true;
            }
            return false;
        }
    }
}

