/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.firebasemlvision;

import android.graphics.Point;
import android.graphics.Rect;
import androidx.annotation.NonNull;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.firebase.ml.vision.FirebaseVision;
import com.google.firebase.ml.vision.common.FirebaseVisionImage;
import com.google.firebase.ml.vision.text.FirebaseVisionText;
import com.google.firebase.ml.vision.text.FirebaseVisionTextRecognizer;
import com.google.firebase.ml.vision.text.RecognizedLanguage;
import io.flutter.plugin.common.MethodChannel;
import io.flutter.plugins.firebasemlvision.Detector;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TextRecognizer
implements Detector {
    private final FirebaseVisionTextRecognizer recognizer;

    TextRecognizer(FirebaseVision vision, Map<String, Object> options) {
        String modelType = (String)options.get("modelType");
        if (modelType.equals("onDevice")) {
            this.recognizer = vision.getOnDeviceTextRecognizer();
        } else if (modelType.equals("cloud")) {
            this.recognizer = vision.getCloudTextRecognizer();
        } else {
            String message = String.format("No model for type: %s", modelType);
            throw new IllegalArgumentException(message);
        }
    }

    @Override
    public void handleDetection(FirebaseVisionImage image, final MethodChannel.Result result) {
        this.recognizer.processImage(image).addOnSuccessListener((OnSuccessListener)new OnSuccessListener<FirebaseVisionText>(){

            public void onSuccess(FirebaseVisionText firebaseVisionText) {
                HashMap<String, Object> visionTextData = new HashMap<String, Object>();
                visionTextData.put("text", firebaseVisionText.getText());
                ArrayList allBlockData = new ArrayList();
                for (FirebaseVisionText.TextBlock block : firebaseVisionText.getTextBlocks()) {
                    HashMap blockData = new HashMap();
                    TextRecognizer.this.addData(blockData, block.getBoundingBox(), block.getConfidence(), block.getCornerPoints(), block.getRecognizedLanguages(), block.getText());
                    ArrayList allLineData = new ArrayList();
                    for (FirebaseVisionText.Line line : block.getLines()) {
                        HashMap lineData = new HashMap();
                        TextRecognizer.this.addData(lineData, line.getBoundingBox(), line.getConfidence(), line.getCornerPoints(), line.getRecognizedLanguages(), line.getText());
                        ArrayList allElementData = new ArrayList();
                        for (FirebaseVisionText.Element element : line.getElements()) {
                            HashMap elementData = new HashMap();
                            TextRecognizer.this.addData(elementData, element.getBoundingBox(), element.getConfidence(), element.getCornerPoints(), element.getRecognizedLanguages(), element.getText());
                            allElementData.add(elementData);
                        }
                        lineData.put("elements", allElementData);
                        allLineData.add(lineData);
                    }
                    blockData.put("lines", allLineData);
                    allBlockData.add(blockData);
                }
                visionTextData.put("blocks", allBlockData);
                result.success(visionTextData);
            }
        }).addOnFailureListener(new OnFailureListener(){

            public void onFailure(@NonNull Exception exception) {
                result.error("textRecognizerError", exception.getLocalizedMessage(), null);
            }
        });
    }

    private void addData(Map<String, Object> addTo, Rect boundingBox, Float confidence, Point[] cornerPoints, List<RecognizedLanguage> languages, String text) {
        if (boundingBox != null) {
            addTo.put("left", boundingBox.left);
            addTo.put("top", boundingBox.top);
            addTo.put("width", boundingBox.width());
            addTo.put("height", boundingBox.height());
        }
        addTo.put("confidence", confidence == null ? null : Double.valueOf(confidence.floatValue()));
        ArrayList<double[]> points = new ArrayList<double[]>();
        if (cornerPoints != null) {
            for (Point point : cornerPoints) {
                points.add(new double[]{point.x, point.y});
            }
        }
        addTo.put("points", points);
        ArrayList allLanguageData = new ArrayList();
        for (RecognizedLanguage language : languages) {
            HashMap<String, String> languageData = new HashMap<String, String>();
            languageData.put("languageCode", language.getLanguageCode());
            allLanguageData.add(languageData);
        }
        addTo.put("recognizedLanguages", allLanguageData);
        addTo.put("text", text);
    }

    @Override
    public void close() throws IOException {
        this.recognizer.close();
    }
}

