/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.firebasemlvision;

import androidx.annotation.NonNull;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.firebase.ml.vision.FirebaseVision;
import com.google.firebase.ml.vision.common.FirebaseVisionImage;
import com.google.firebase.ml.vision.label.FirebaseVisionCloudImageLabelerOptions;
import com.google.firebase.ml.vision.label.FirebaseVisionImageLabel;
import com.google.firebase.ml.vision.label.FirebaseVisionImageLabeler;
import com.google.firebase.ml.vision.label.FirebaseVisionOnDeviceImageLabelerOptions;
import io.flutter.plugin.common.MethodChannel;
import io.flutter.plugins.firebasemlvision.Detector;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class ImageLabeler
implements Detector {
    private final FirebaseVisionImageLabeler labeler;

    ImageLabeler(FirebaseVision vision, Map<String, Object> options) {
        String modelType = (String)options.get("modelType");
        if (modelType.equals("onDevice")) {
            this.labeler = vision.getOnDeviceImageLabeler(this.parseOptions(options));
        } else if (modelType.equals("cloud")) {
            this.labeler = vision.getCloudImageLabeler(this.parseCloudOptions(options));
        } else {
            String message = String.format("No model for type: %s", modelType);
            throw new IllegalArgumentException(message);
        }
    }

    @Override
    public void handleDetection(FirebaseVisionImage image, final MethodChannel.Result result) {
        this.labeler.processImage(image).addOnSuccessListener((OnSuccessListener)new OnSuccessListener<List<FirebaseVisionImageLabel>>(){

            public void onSuccess(List<FirebaseVisionImageLabel> firebaseVisionLabels) {
                ArrayList labels = new ArrayList(firebaseVisionLabels.size());
                for (FirebaseVisionImageLabel label : firebaseVisionLabels) {
                    HashMap<String, Object> labelData = new HashMap<String, Object>();
                    labelData.put("confidence", Double.valueOf(label.getConfidence()));
                    labelData.put("entityId", label.getEntityId());
                    labelData.put("text", label.getText());
                    labels.add(labelData);
                }
                result.success(labels);
            }
        }).addOnFailureListener(new OnFailureListener(){

            public void onFailure(@NonNull Exception e) {
                result.error("imageLabelerError", e.getLocalizedMessage(), null);
            }
        });
    }

    private FirebaseVisionOnDeviceImageLabelerOptions parseOptions(Map<String, Object> optionsData) {
        float conf = (float)((Double)optionsData.get("confidenceThreshold")).doubleValue();
        return new FirebaseVisionOnDeviceImageLabelerOptions.Builder().setConfidenceThreshold(conf).build();
    }

    private FirebaseVisionCloudImageLabelerOptions parseCloudOptions(Map<String, Object> optionsData) {
        float conf = (float)((Double)optionsData.get("confidenceThreshold")).doubleValue();
        return new FirebaseVisionCloudImageLabelerOptions.Builder().setConfidenceThreshold(conf).build();
    }

    @Override
    public void close() throws IOException {
        this.labeler.close();
    }
}

