/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.firebasemlvision;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.net.Uri;
import android.util.SparseArray;
import androidx.exifinterface.media.ExifInterface;
import com.google.firebase.ml.vision.FirebaseVision;
import com.google.firebase.ml.vision.common.FirebaseVisionImage;
import com.google.firebase.ml.vision.common.FirebaseVisionImageMetadata;
import io.flutter.plugin.common.MethodCall;
import io.flutter.plugin.common.MethodChannel;
import io.flutter.plugin.common.PluginRegistry;
import io.flutter.plugins.firebasemlvision.BarcodeDetector;
import io.flutter.plugins.firebasemlvision.Detector;
import io.flutter.plugins.firebasemlvision.FaceDetector;
import io.flutter.plugins.firebasemlvision.ImageLabeler;
import io.flutter.plugins.firebasemlvision.TextRecognizer;
import java.io.File;
import java.io.IOException;
import java.util.Map;

public class FirebaseMlVisionPlugin
implements MethodChannel.MethodCallHandler {
    private final SparseArray<Detector> detectors = new SparseArray();
    private PluginRegistry.Registrar registrar;

    private FirebaseMlVisionPlugin(PluginRegistry.Registrar registrar) {
        this.registrar = registrar;
    }

    public static void registerWith(PluginRegistry.Registrar registrar) {
        MethodChannel channel = new MethodChannel(registrar.messenger(), "plugins.flutter.io/firebase_ml_vision");
        channel.setMethodCallHandler((MethodChannel.MethodCallHandler)new FirebaseMlVisionPlugin(registrar));
    }

    public void onMethodCall(MethodCall call, MethodChannel.Result result) {
        switch (call.method) {
            case "BarcodeDetector#detectInImage": 
            case "FaceDetector#processImage": 
            case "ImageLabeler#processImage": 
            case "TextRecognizer#processImage": {
                this.handleDetection(call, result);
                break;
            }
            case "BarcodeDetector#close": 
            case "FaceDetector#close": 
            case "ImageLabeler#close": 
            case "TextRecognizer#close": {
                this.closeDetector(call, result);
                break;
            }
            default: {
                result.notImplemented();
            }
        }
    }

    private void handleDetection(MethodCall call, MethodChannel.Result result) {
        FirebaseVisionImage image;
        Map options = (Map)call.argument("options");
        Map imageData = (Map)call.arguments();
        try {
            image = this.dataToVisionImage(imageData);
        }
        catch (IOException exception) {
            result.error("MLVisionDetectorIOError", exception.getLocalizedMessage(), null);
            return;
        }
        Detector detector = this.getDetector(call);
        if (detector == null) {
            switch (call.method.split("#")[0]) {
                case "BarcodeDetector": {
                    detector = new BarcodeDetector(FirebaseVision.getInstance(), options);
                    break;
                }
                case "FaceDetector": {
                    detector = new FaceDetector(FirebaseVision.getInstance(), options);
                    break;
                }
                case "ImageLabeler": {
                    detector = new ImageLabeler(FirebaseVision.getInstance(), options);
                    break;
                }
                case "TextRecognizer": {
                    detector = new TextRecognizer(FirebaseVision.getInstance(), options);
                }
            }
            Integer handle = (Integer)call.argument("handle");
            this.addDetector(handle, detector);
        }
        detector.handleDetection(image, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeDetector(MethodCall call, MethodChannel.Result result) {
        Detector detector = this.getDetector(call);
        if (detector == null) {
            Integer handle = (Integer)call.argument("handle");
            String message = String.format("Object for handle does not exists: %s", handle);
            throw new IllegalArgumentException(message);
        }
        try {
            detector.close();
            result.success(null);
        }
        catch (IOException e) {
            String code = String.format("%sIOError", detector.getClass().getSimpleName());
            result.error(code, e.getLocalizedMessage(), null);
        }
        finally {
            Integer handle = (Integer)call.argument("handle");
            this.detectors.remove(handle.intValue());
        }
    }

    private FirebaseVisionImage dataToVisionImage(Map<String, Object> imageData) throws IOException {
        String imageType = (String)imageData.get("type");
        assert (imageType != null);
        switch (imageType) {
            case "file": {
                String imageFilePath = (String)imageData.get("path");
                int rotation = this.getImageExifOrientation(imageFilePath);
                if (rotation == 0) {
                    File file = new File(imageFilePath);
                    return FirebaseVisionImage.fromFilePath((Context)this.registrar.context(), (Uri)Uri.fromFile((File)file));
                }
                Matrix matrix = new Matrix();
                matrix.postRotate((float)rotation);
                Bitmap bitmap = BitmapFactory.decodeFile((String)imageFilePath);
                Bitmap rotatedBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
                return FirebaseVisionImage.fromBitmap((Bitmap)rotatedBitmap);
            }
            case "bytes": {
                Map metadataData = (Map)imageData.get("metadata");
                FirebaseVisionImageMetadata metadata = new FirebaseVisionImageMetadata.Builder().setWidth((int)((Double)metadataData.get("width")).doubleValue()).setHeight((int)((Double)metadataData.get("height")).doubleValue()).setFormat(17).setRotation(this.getRotation((Integer)metadataData.get("rotation"))).build();
                byte[] bytes = (byte[])imageData.get("bytes");
                assert (bytes != null);
                return FirebaseVisionImage.fromByteArray((byte[])bytes, (FirebaseVisionImageMetadata)metadata);
            }
        }
        throw new IllegalArgumentException(String.format("No image type for: %s", imageType));
    }

    private int getImageExifOrientation(String imageFilePath) throws IOException {
        ExifInterface exif = new ExifInterface(imageFilePath);
        int orientation = exif.getAttributeInt("Orientation", 1);
        switch (orientation) {
            case 6: {
                return 90;
            }
            case 3: {
                return 180;
            }
            case 8: {
                return 270;
            }
        }
        return 0;
    }

    private int getRotation(int rotation) {
        switch (rotation) {
            case 0: {
                return 0;
            }
            case 90: {
                return 1;
            }
            case 180: {
                return 2;
            }
            case 270: {
                return 3;
            }
        }
        throw new IllegalArgumentException(String.format("No rotation for: %d", rotation));
    }

    private void addDetector(int handle, Detector detector) {
        if (this.detectors.get(handle) != null) {
            String message = String.format("Object for handle already exists: %s", handle);
            throw new IllegalArgumentException(message);
        }
        this.detectors.put(handle, (Object)detector);
    }

    private Detector getDetector(MethodCall call) {
        Integer handle = (Integer)call.argument("handle");
        return (Detector)this.detectors.get(handle.intValue());
    }
}

