/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.firebasemlvision;

import android.graphics.Point;
import android.graphics.Rect;
import androidx.annotation.NonNull;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.firebase.ml.vision.FirebaseVision;
import com.google.firebase.ml.vision.barcode.FirebaseVisionBarcode;
import com.google.firebase.ml.vision.barcode.FirebaseVisionBarcodeDetector;
import com.google.firebase.ml.vision.barcode.FirebaseVisionBarcodeDetectorOptions;
import com.google.firebase.ml.vision.common.FirebaseVisionImage;
import io.flutter.plugin.common.MethodChannel;
import io.flutter.plugins.firebasemlvision.Detector;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class BarcodeDetector
implements Detector {
    private final FirebaseVisionBarcodeDetector detector;

    BarcodeDetector(FirebaseVision vision, Map<String, Object> options) {
        this.detector = vision.getVisionBarcodeDetector(this.parseOptions(options));
    }

    @Override
    public void handleDetection(FirebaseVisionImage image, final MethodChannel.Result result) {
        this.detector.detectInImage(image).addOnSuccessListener((OnSuccessListener)new OnSuccessListener<List<FirebaseVisionBarcode>>(){

            public void onSuccess(List<FirebaseVisionBarcode> firebaseVisionBarcodes) {
                ArrayList barcodes = new ArrayList();
                for (FirebaseVisionBarcode barcode : firebaseVisionBarcodes) {
                    HashMap<String, Object> barcodeMap = new HashMap<String, Object>();
                    Rect bounds = barcode.getBoundingBox();
                    if (bounds != null) {
                        barcodeMap.put("left", Double.valueOf(bounds.left));
                        barcodeMap.put("top", Double.valueOf(bounds.top));
                        barcodeMap.put("width", Double.valueOf(bounds.width()));
                        barcodeMap.put("height", Double.valueOf(bounds.height()));
                    }
                    ArrayList<double[]> points = new ArrayList<double[]>();
                    if (barcode.getCornerPoints() != null) {
                        for (Point point : barcode.getCornerPoints()) {
                            points.add(new double[]{point.x, point.y});
                        }
                    }
                    barcodeMap.put("points", points);
                    barcodeMap.put("rawValue", barcode.getRawValue());
                    barcodeMap.put("displayValue", barcode.getDisplayValue());
                    barcodeMap.put("format", barcode.getFormat());
                    barcodeMap.put("valueType", barcode.getValueType());
                    HashMap<String, Object> typeValue = new HashMap<String, Object>();
                    switch (barcode.getValueType()) {
                        case 2: {
                            FirebaseVisionBarcode.Email email = barcode.getEmail();
                            typeValue.put("type", email.getType());
                            typeValue.put("address", email.getAddress());
                            typeValue.put("body", email.getBody());
                            typeValue.put("subject", email.getSubject());
                            barcodeMap.put("email", typeValue);
                            break;
                        }
                        case 4: {
                            FirebaseVisionBarcode.Phone phone = barcode.getPhone();
                            typeValue.put("number", phone.getNumber());
                            typeValue.put("type", phone.getType());
                            barcodeMap.put("phone", typeValue);
                            break;
                        }
                        case 6: {
                            FirebaseVisionBarcode.Sms sms = barcode.getSms();
                            typeValue.put("message", sms.getMessage());
                            typeValue.put("phoneNumber", sms.getPhoneNumber());
                            barcodeMap.put("sms", typeValue);
                            break;
                        }
                        case 8: {
                            FirebaseVisionBarcode.UrlBookmark urlBookmark = barcode.getUrl();
                            typeValue.put("title", urlBookmark.getTitle());
                            typeValue.put("url", urlBookmark.getUrl());
                            barcodeMap.put("url", typeValue);
                            break;
                        }
                        case 9: {
                            FirebaseVisionBarcode.WiFi wifi = barcode.getWifi();
                            typeValue.put("ssid", wifi.getSsid());
                            typeValue.put("password", wifi.getPassword());
                            typeValue.put("encryptionType", wifi.getEncryptionType());
                            barcodeMap.put("wifi", typeValue);
                            break;
                        }
                        case 10: {
                            FirebaseVisionBarcode.GeoPoint geoPoint = barcode.getGeoPoint();
                            typeValue.put("latitude", geoPoint.getLat());
                            typeValue.put("longitude", geoPoint.getLng());
                            barcodeMap.put("geoPoint", typeValue);
                            break;
                        }
                        case 1: {
                            Object address2;
                            FirebaseVisionBarcode.ContactInfo contactInfo = barcode.getContactInfo();
                            ArrayList addresses = new ArrayList();
                            for (Object address2 : contactInfo.getAddresses()) {
                                HashMap<String, Object> addressMap = new HashMap<String, Object>();
                                if (address2.getAddressLines() != null) {
                                    addressMap.put("addressLines", Arrays.asList(address2.getAddressLines()));
                                }
                                addressMap.put("type", address2.getType());
                                addresses.add(addressMap);
                            }
                            typeValue.put("addresses", addresses);
                            ArrayList emails = new ArrayList();
                            address2 = contactInfo.getEmails().iterator();
                            while (address2.hasNext()) {
                                FirebaseVisionBarcode.Email contactEmail = (FirebaseVisionBarcode.Email)address2.next();
                                HashMap<String, Object> emailMap = new HashMap<String, Object>();
                                emailMap.put("address", contactEmail.getAddress());
                                emailMap.put("type", contactEmail.getType());
                                emailMap.put("body", contactEmail.getBody());
                                emailMap.put("subject", contactEmail.getSubject());
                                emails.add(emailMap);
                            }
                            typeValue.put("emails", emails);
                            HashMap<String, String> nameMap = new HashMap<String, String>();
                            FirebaseVisionBarcode.PersonName name = contactInfo.getName();
                            if (name != null) {
                                nameMap.put("formattedName", name.getFormattedName());
                                nameMap.put("first", name.getFirst());
                                nameMap.put("last", name.getLast());
                                nameMap.put("middle", name.getMiddle());
                                nameMap.put("prefix", name.getPrefix());
                                nameMap.put("pronunciation", name.getPronunciation());
                                nameMap.put("suffix", name.getSuffix());
                            }
                            typeValue.put("name", nameMap);
                            ArrayList phones = new ArrayList();
                            for (FirebaseVisionBarcode.Phone contactPhone : contactInfo.getPhones()) {
                                HashMap<String, Object> phoneMap = new HashMap<String, Object>();
                                phoneMap.put("number", contactPhone.getNumber());
                                phoneMap.put("type", contactPhone.getType());
                                phones.add(phoneMap);
                            }
                            typeValue.put("phones", phones);
                            if (contactInfo.getUrls() != null) {
                                typeValue.put("urls", Arrays.asList(contactInfo.getUrls()));
                            }
                            typeValue.put("jobTitle", contactInfo.getTitle());
                            typeValue.put("organization", contactInfo.getOrganization());
                            barcodeMap.put("contactInfo", typeValue);
                            break;
                        }
                        case 11: {
                            FirebaseVisionBarcode.CalendarEvent calendarEvent = barcode.getCalendarEvent();
                            typeValue.put("eventDescription", calendarEvent.getDescription());
                            typeValue.put("location", calendarEvent.getLocation());
                            typeValue.put("organizer", calendarEvent.getOrganizer());
                            typeValue.put("status", calendarEvent.getStatus());
                            typeValue.put("summary", calendarEvent.getSummary());
                            if (calendarEvent.getStart() != null) {
                                typeValue.put("start", calendarEvent.getStart().getRawValue());
                            }
                            if (calendarEvent.getEnd() != null) {
                                typeValue.put("end", calendarEvent.getEnd().getRawValue());
                            }
                            barcodeMap.put("calendarEvent", typeValue);
                            break;
                        }
                        case 12: {
                            FirebaseVisionBarcode.DriverLicense driverLicense = barcode.getDriverLicense();
                            typeValue.put("firstName", driverLicense.getFirstName());
                            typeValue.put("middleName", driverLicense.getMiddleName());
                            typeValue.put("lastName", driverLicense.getLastName());
                            typeValue.put("gender", driverLicense.getGender());
                            typeValue.put("addressCity", driverLicense.getAddressCity());
                            typeValue.put("addressStreet", driverLicense.getAddressStreet());
                            typeValue.put("addressState", driverLicense.getAddressState());
                            typeValue.put("addressZip", driverLicense.getAddressZip());
                            typeValue.put("birthDate", driverLicense.getBirthDate());
                            typeValue.put("documentType", driverLicense.getDocumentType());
                            typeValue.put("licenseNumber", driverLicense.getLicenseNumber());
                            typeValue.put("expiryDate", driverLicense.getExpiryDate());
                            typeValue.put("issuingDate", driverLicense.getIssueDate());
                            typeValue.put("issuingCountry", driverLicense.getIssuingCountry());
                            barcodeMap.put("driverLicense", typeValue);
                        }
                    }
                    barcodes.add(barcodeMap);
                }
                result.success(barcodes);
            }
        }).addOnFailureListener(new OnFailureListener(){

            public void onFailure(@NonNull Exception exception) {
                result.error("barcodeDetectorError", exception.getLocalizedMessage(), null);
            }
        });
    }

    private FirebaseVisionBarcodeDetectorOptions parseOptions(Map<String, Object> optionsData) {
        Integer barcodeFormats = (Integer)optionsData.get("barcodeFormats");
        return new FirebaseVisionBarcodeDetectorOptions.Builder().setBarcodeFormats(barcodeFormats.intValue(), new int[0]).build();
    }

    @Override
    public void close() throws IOException {
        this.detector.close();
    }
}

