/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.imagepicker;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.media.MediaScannerConnection;
import android.net.Uri;
import android.os.Parcelable;
import android.support.annotation.VisibleForTesting;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.FileProvider;
import io.flutter.plugin.common.MethodCall;
import io.flutter.plugin.common.MethodChannel;
import io.flutter.plugin.common.PluginRegistry;
import io.flutter.plugins.imagepicker.FileUtils;
import io.flutter.plugins.imagepicker.ImageResizer;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.UUID;

public class ImagePickerDelegate
implements PluginRegistry.ActivityResultListener,
PluginRegistry.RequestPermissionsResultListener {
    @VisibleForTesting
    static final int REQUEST_CODE_CHOOSE_IMAGE_FROM_GALLERY = 2342;
    @VisibleForTesting
    static final int REQUEST_CODE_TAKE_IMAGE_WITH_CAMERA = 2343;
    @VisibleForTesting
    static final int REQUEST_EXTERNAL_IMAGE_STORAGE_PERMISSION = 2344;
    @VisibleForTesting
    static final int REQUEST_CAMERA_IMAGE_PERMISSION = 2345;
    @VisibleForTesting
    static final int REQUEST_CODE_CHOOSE_VIDEO_FROM_GALLERY = 2352;
    @VisibleForTesting
    static final int REQUEST_CODE_TAKE_VIDEO_WITH_CAMERA = 2353;
    @VisibleForTesting
    static final int REQUEST_EXTERNAL_VIDEO_STORAGE_PERMISSION = 2354;
    @VisibleForTesting
    static final int REQUEST_CAMERA_VIDEO_PERMISSION = 2355;
    @VisibleForTesting
    final String fileProviderName;
    private final Activity activity;
    private final File externalFilesDirectory;
    private final ImageResizer imageResizer;
    private final PermissionManager permissionManager;
    private final IntentResolver intentResolver;
    private final FileUriResolver fileUriResolver;
    private final FileUtils fileUtils;
    private Uri pendingCameraMediaUri;
    private MethodChannel.Result pendingResult;
    private MethodCall methodCall;

    public ImagePickerDelegate(final Activity activity, File externalFilesDirectory, ImageResizer imageResizer) {
        this(activity, externalFilesDirectory, imageResizer, null, null, new PermissionManager(){

            @Override
            public boolean isPermissionGranted(String permissionName) {
                return ActivityCompat.checkSelfPermission((Context)activity, (String)permissionName) == 0;
            }

            @Override
            public void askForPermission(String permissionName, int requestCode) {
                ActivityCompat.requestPermissions((Activity)activity, (String[])new String[]{permissionName}, (int)requestCode);
            }
        }, new IntentResolver(){

            @Override
            public boolean resolveActivity(Intent intent) {
                return intent.resolveActivity(activity.getPackageManager()) != null;
            }
        }, new FileUriResolver(){

            @Override
            public Uri resolveFileProviderUriForFile(String fileProviderName, File file) {
                return FileProvider.getUriForFile((Context)activity, (String)fileProviderName, (File)file);
            }

            @Override
            public void getFullImagePath(Uri imageUri, final OnPathReadyListener listener) {
                MediaScannerConnection.scanFile((Context)activity, (String[])new String[]{imageUri.getPath()}, null, (MediaScannerConnection.OnScanCompletedListener)new MediaScannerConnection.OnScanCompletedListener(){

                    public void onScanCompleted(String path, Uri uri) {
                        listener.onPathReady(path);
                    }
                });
            }
        }, new FileUtils());
    }

    @VisibleForTesting
    ImagePickerDelegate(Activity activity, File externalFilesDirectory, ImageResizer imageResizer, MethodChannel.Result result, MethodCall methodCall, PermissionManager permissionManager, IntentResolver intentResolver, FileUriResolver fileUriResolver, FileUtils fileUtils) {
        this.activity = activity;
        this.externalFilesDirectory = externalFilesDirectory;
        this.imageResizer = imageResizer;
        this.fileProviderName = activity.getPackageName() + ".flutter.image_provider";
        this.pendingResult = result;
        this.methodCall = methodCall;
        this.permissionManager = permissionManager;
        this.intentResolver = intentResolver;
        this.fileUriResolver = fileUriResolver;
        this.fileUtils = fileUtils;
    }

    public void chooseVideoFromGallery(MethodCall methodCall, MethodChannel.Result result) {
        if (!this.setPendingMethodCallAndResult(methodCall, result)) {
            this.finishWithAlreadyActiveError();
            return;
        }
        if (!this.permissionManager.isPermissionGranted("android.permission.READ_EXTERNAL_STORAGE")) {
            this.permissionManager.askForPermission("android.permission.READ_EXTERNAL_STORAGE", 2354);
            return;
        }
        this.launchPickVideoFromGalleryIntent();
    }

    private void launchPickVideoFromGalleryIntent() {
        Intent pickVideoIntent = new Intent("android.intent.action.GET_CONTENT");
        pickVideoIntent.setType("video/*");
        this.activity.startActivityForResult(pickVideoIntent, 2352);
    }

    public void takeVideoWithCamera(MethodCall methodCall, MethodChannel.Result result) {
        if (!this.setPendingMethodCallAndResult(methodCall, result)) {
            this.finishWithAlreadyActiveError();
            return;
        }
        if (!this.permissionManager.isPermissionGranted("android.permission.CAMERA")) {
            this.permissionManager.askForPermission("android.permission.CAMERA", 2355);
            return;
        }
        this.launchTakeVideoWithCameraIntent();
    }

    private void launchTakeVideoWithCameraIntent() {
        Intent intent = new Intent("android.media.action.VIDEO_CAPTURE");
        boolean canTakePhotos = this.intentResolver.resolveActivity(intent);
        if (!canTakePhotos) {
            this.finishWithError("no_available_camera", "No cameras available for taking pictures.");
            return;
        }
        File videoFile = this.createTemporaryWritableVideoFile();
        this.pendingCameraMediaUri = Uri.parse((String)("file:" + videoFile.getAbsolutePath()));
        Uri videoUri = this.fileUriResolver.resolveFileProviderUriForFile(this.fileProviderName, videoFile);
        intent.putExtra("output", (Parcelable)videoUri);
        this.grantUriPermissions(intent, videoUri);
        this.activity.startActivityForResult(intent, 2353);
    }

    public void chooseImageFromGallery(MethodCall methodCall, MethodChannel.Result result) {
        if (!this.setPendingMethodCallAndResult(methodCall, result)) {
            this.finishWithAlreadyActiveError();
            return;
        }
        if (!this.permissionManager.isPermissionGranted("android.permission.READ_EXTERNAL_STORAGE")) {
            this.permissionManager.askForPermission("android.permission.READ_EXTERNAL_STORAGE", 2344);
            return;
        }
        this.launchPickImageFromGalleryIntent();
    }

    private void launchPickImageFromGalleryIntent() {
        Intent pickImageIntent = new Intent("android.intent.action.GET_CONTENT");
        pickImageIntent.setType("image/*");
        this.activity.startActivityForResult(pickImageIntent, 2342);
    }

    public void takeImageWithCamera(MethodCall methodCall, MethodChannel.Result result) {
        if (!this.setPendingMethodCallAndResult(methodCall, result)) {
            this.finishWithAlreadyActiveError();
            return;
        }
        if (!this.permissionManager.isPermissionGranted("android.permission.CAMERA")) {
            this.permissionManager.askForPermission("android.permission.CAMERA", 2345);
            return;
        }
        this.launchTakeImageWithCameraIntent();
    }

    private void launchTakeImageWithCameraIntent() {
        Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
        boolean canTakePhotos = this.intentResolver.resolveActivity(intent);
        if (!canTakePhotos) {
            this.finishWithError("no_available_camera", "No cameras available for taking pictures.");
            return;
        }
        File imageFile = this.createTemporaryWritableImageFile();
        this.pendingCameraMediaUri = Uri.parse((String)("file:" + imageFile.getAbsolutePath()));
        Uri imageUri = this.fileUriResolver.resolveFileProviderUriForFile(this.fileProviderName, imageFile);
        intent.putExtra("output", (Parcelable)imageUri);
        this.grantUriPermissions(intent, imageUri);
        this.activity.startActivityForResult(intent, 2343);
    }

    private File createTemporaryWritableImageFile() {
        return this.createTemporaryWritableFile(".jpg");
    }

    private File createTemporaryWritableVideoFile() {
        return this.createTemporaryWritableFile(".mp4");
    }

    private File createTemporaryWritableFile(String suffix) {
        File image;
        String filename = UUID.randomUUID().toString();
        try {
            image = File.createTempFile(filename, suffix, this.externalFilesDirectory);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return image;
    }

    private void grantUriPermissions(Intent intent, Uri imageUri) {
        PackageManager packageManager = this.activity.getPackageManager();
        List compatibleActivities = packageManager.queryIntentActivities(intent, 65536);
        for (ResolveInfo info : compatibleActivities) {
            this.activity.grantUriPermission(info.activityInfo.packageName, imageUri, 3);
        }
    }

    public boolean onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        boolean permissionGranted = grantResults.length > 0 && grantResults[0] == 0;
        switch (requestCode) {
            case 2344: {
                if (!permissionGranted) break;
                this.launchPickImageFromGalleryIntent();
                break;
            }
            case 2354: {
                if (!permissionGranted) break;
                this.launchPickVideoFromGalleryIntent();
                break;
            }
            case 2345: {
                if (!permissionGranted) break;
                this.launchTakeImageWithCameraIntent();
                break;
            }
            case 2355: {
                if (!permissionGranted) break;
                this.launchTakeVideoWithCameraIntent();
                break;
            }
            default: {
                return false;
            }
        }
        if (!permissionGranted) {
            this.finishWithSuccess(null);
        }
        return true;
    }

    public boolean onActivityResult(int requestCode, int resultCode, Intent data) {
        switch (requestCode) {
            case 2342: {
                this.handleChooseImageResult(resultCode, data);
                break;
            }
            case 2343: {
                this.handleCaptureImageResult(resultCode);
                break;
            }
            case 2352: {
                this.handleChooseVideoResult(resultCode, data);
                break;
            }
            case 2353: {
                this.handleCaptureVideoResult(resultCode);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private void handleChooseImageResult(int resultCode, Intent data) {
        if (resultCode == -1 && data != null) {
            String path = this.fileUtils.getPathFromUri((Context)this.activity, data.getData());
            this.handleImageResult(path);
            return;
        }
        this.finishWithSuccess(null);
    }

    private void handleChooseVideoResult(int resultCode, Intent data) {
        if (resultCode == -1 && data != null) {
            String path = this.fileUtils.getPathFromUri((Context)this.activity, data.getData());
            this.handleVideoResult(path);
            return;
        }
        this.finishWithSuccess(null);
    }

    private void handleCaptureImageResult(int resultCode) {
        if (resultCode == -1) {
            this.fileUriResolver.getFullImagePath(this.pendingCameraMediaUri, new OnPathReadyListener(){

                @Override
                public void onPathReady(String path) {
                    ImagePickerDelegate.this.handleImageResult(path);
                }
            });
            return;
        }
        this.finishWithSuccess(null);
    }

    private void handleCaptureVideoResult(int resultCode) {
        if (resultCode == -1) {
            this.fileUriResolver.getFullImagePath(this.pendingCameraMediaUri, new OnPathReadyListener(){

                @Override
                public void onPathReady(String path) {
                    ImagePickerDelegate.this.handleVideoResult(path);
                }
            });
            return;
        }
        this.finishWithSuccess(null);
    }

    private void handleImageResult(String path) {
        if (this.pendingResult == null) {
            throw new IllegalStateException("Received image from picker that was not requested");
        }
        Double maxWidth = (Double)this.methodCall.argument("maxWidth");
        Double maxHeight = (Double)this.methodCall.argument("maxHeight");
        String finalImagePath = this.imageResizer.resizeImageIfNeeded(path, maxWidth, maxHeight);
        this.finishWithSuccess(finalImagePath);
    }

    private void handleVideoResult(String path) {
        if (this.pendingResult == null) {
            throw new IllegalStateException("Received video from picker that was not requested");
        }
        this.finishWithSuccess(path);
    }

    private boolean setPendingMethodCallAndResult(MethodCall methodCall, MethodChannel.Result result) {
        if (this.pendingResult != null) {
            return false;
        }
        this.methodCall = methodCall;
        this.pendingResult = result;
        return true;
    }

    private void finishWithSuccess(String imagePath) {
        this.pendingResult.success((Object)imagePath);
        this.clearMethodCallAndResult();
    }

    private void finishWithAlreadyActiveError() {
        this.finishWithError("already_active", "Image picker is already active");
    }

    private void finishWithError(String errorCode, String errorMessage) {
        this.pendingResult.error(errorCode, errorMessage, null);
        this.clearMethodCallAndResult();
    }

    private void clearMethodCallAndResult() {
        this.methodCall = null;
        this.pendingResult = null;
    }

    static interface OnPathReadyListener {
        public void onPathReady(String var1);
    }

    static interface FileUriResolver {
        public Uri resolveFileProviderUriForFile(String var1, File var2);

        public void getFullImagePath(Uri var1, OnPathReadyListener var2);
    }

    static interface IntentResolver {
        public boolean resolveActivity(Intent var1);
    }

    static interface PermissionManager {
        public boolean isPermissionGranted(String var1);

        public void askForPermission(String var1, int var2);
    }
}

