/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.firebase.core;

import android.content.Context;
import com.google.firebase.FirebaseApp;
import com.google.firebase.FirebaseOptions;
import io.flutter.plugin.common.MethodCall;
import io.flutter.plugin.common.MethodChannel;
import io.flutter.plugin.common.PluginRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class FirebaseCorePlugin
implements MethodChannel.MethodCallHandler {
    private final Context context;

    public static void registerWith(PluginRegistry.Registrar registrar) {
        MethodChannel channel = new MethodChannel(registrar.messenger(), "plugins.flutter.io/firebase_core");
        channel.setMethodCallHandler((MethodChannel.MethodCallHandler)new FirebaseCorePlugin((Context)registrar.activity()));
    }

    private FirebaseCorePlugin(Context context) {
        this.context = context;
    }

    private Map asMap(FirebaseApp app) {
        HashMap<String, Object> appMap = new HashMap<String, Object>();
        appMap.put("name", app.getName());
        FirebaseOptions options = app.getOptions();
        HashMap<String, String> optionsMap = new HashMap<String, String>();
        optionsMap.put("googleAppID", options.getApplicationId());
        optionsMap.put("GCMSenderID", options.getGcmSenderId());
        optionsMap.put("APIKey", options.getApiKey());
        optionsMap.put("databaseURL", options.getDatabaseUrl());
        optionsMap.put("storageBucket", options.getStorageBucket());
        optionsMap.put("projectID", options.getProjectId());
        appMap.put("options", optionsMap);
        return appMap;
    }

    public void onMethodCall(MethodCall call, MethodChannel.Result result) {
        switch (call.method) {
            case "FirebaseApp#configure": {
                Map arguments = (Map)call.arguments();
                String name = (String)arguments.get("name");
                Map optionsMap = (Map)arguments.get("options");
                FirebaseOptions options = new FirebaseOptions.Builder().setApiKey((String)optionsMap.get("APIKey")).setApplicationId((String)optionsMap.get("googleAppID")).setDatabaseUrl((String)optionsMap.get("databaseURL")).setGcmSenderId((String)optionsMap.get("GCMSenderID")).setProjectId((String)optionsMap.get("projectID")).setStorageBucket((String)optionsMap.get("storageBucket")).build();
                FirebaseApp.initializeApp((Context)this.context, (FirebaseOptions)options, (String)name);
                result.success(null);
                break;
            }
            case "FirebaseApp#allApps": {
                ArrayList<Map> apps = new ArrayList<Map>();
                for (FirebaseApp app : FirebaseApp.getApps((Context)this.context)) {
                    apps.add(this.asMap(app));
                }
                result.success(apps);
                break;
            }
            case "FirebaseApp#appNamed": {
                String name = (String)call.arguments();
                try {
                    FirebaseApp app = FirebaseApp.getInstance((String)name);
                    result.success((Object)this.asMap(app));
                }
                catch (IllegalStateException ex) {
                    result.success(null);
                }
                break;
            }
            default: {
                result.notImplemented();
            }
        }
    }
}

