WorkingForumBundle
==================

Setup for Symfony 5 / 6
------------------

This bundle use KnpPaginatorBundle for pagination, KnpMarkdown for markdown rendering

 **Prerequisite**
- You must handle user 
- You must have a database
- You must configure your translator, example in config/framework.yaml :
````yml
framework:
    translator:
        paths:
            - '%kernel.project_dir%/translations'
        fallbacks:
            - 'en'
````
- If you want to enable threads subscription, you must have "mailer" configured

**Steps**

1/ Create the config file "config/packages/yosimitso_working_forum.yaml" with :
````yml
yosimitso_working_forum:
    thread_per_page: 50
    post_per_page: 10
    date_format: 'Y/m/d H:i:s'
    allow_anonymous_read: true             # ALLOW OR NOT ACCESS TO ANONYMOUS USERS
    allow_moderator_delete_thread: false
    theme_color: green                      # GREEN OR DARK_BLUE
    lock_thread_older_than: 0               # DAYS BETWEEN THE LAST THREAD'S POST AND THE AUTOLOCKING OF THE THREAD, 0 MEANS DISABLED
    post_flood_sec: 30                      # SECONDS MINIMUM BETWEEN EACH POST FROM A SAME USER
    site_title: "My website" 
    vote:
        threshold_useful_post: 5            # NUMBER OF VOTE NEEDED FOR A POST TO BE CONSIDERED AS USEFUL
    file_upload:
        enable: true                        # ALLOW OR NOT USERS TO UPLOAD ENCLOSED FILES 
        max_size_ko: 10000
        accepted_format: [image/jpg, image/jpeg, image/png, image/gif, image/tiff, application/pdf]
        preview_file: true                  # FOR IMAGES ONLY, DISPLAY A THUMBNAIL
    thread_subscription:                    
        enable: true                        # ALLOW OR NOT THREAD SUBSCRIPTION
````

2/ OPTIONAL : if you decide to enable the file upload system, create a directory called "wf_uploads" into your public directory with writing rights,
please also check if your PHP configuration allow file upload through forms and adjust the directives "upload_max_filesize" and "post_max_size" to your application's config

3/ Run :
````bash
composer require "yosimitso/workingforumbundle":"^5.0"
````

4/ Create the config file for KNP Paginator "config/packages/knp_paginator.yaml" with :
````yml
knp_paginator:
    page_range: 1                      # default page range used in pagination control
    default_options:
        page_name: page                # page query parameter name
        sort_field_name: sort          # sort field query parameter name
        sort_direction_name: direction # sort direction query parameter name
        distinct: true                 # ensure distinct results, useful when ORM queries are using GROUP BY statements
    template:
        pagination: "@YosimitsoWorkingForum/Common/slidePagination.html.twig"     # sliding pagination controls template
        sortable: "@KnpPaginator/Pagination/sortable_link.html.twig" # sort link template
````

5/ Copy and edit the above code to "config/doctrine.yaml" into "orm" key :
````yml
doctrine:
    orm:
        resolve_target_entities:
            Yosimitso\WorkingForumBundle\Entity\UserInterface: You\YourUserBundle\Entity\YourUser
````

6/ Your User Entity needs to extend : Yosimitso\WorkingForumBundle\Entity\User

The id property must be protected

Example :
````php
use Doctrine\ORM\Mapping as ORM;

 #[ORM\Entity(repositoryClass: "App\Repository\UserRepository")]
 #[ORM\Table(name: "user")]
   class User extends \Yosimitso\WorkingForumBundle\Entity\User
{
    protected int $id;

    // REST OF YOUR ENTITY
}
````

In case your user entity already extends an another bundle (like FOSUserBundle), implement the interface \Yosimitso\WorkingForumBundle\Entity\UserInterface
in your user entity. Then copy/paste the content of \Yosimitso\WorkingForumBundle\Entity\User (attributes, getter, setter) into your user entity

7/ Your User Entity must be PHP compatible with Yosimitso\WorkingForumBundle\Entity\User,
edit the method/properties or remove them to let the bundle handle them.


8/ Import the bundle's routing, add to your "config/routes.yaml" (you are free to modifiy the prefix) :
````yml
yosimitso_working_forum:
    resource: "@YosimitsoWorkingForumBundle/Resources/config/routing.yml"
    prefix:   /forum
````    

9/ Install the assets according to your application, default command is :
````bash
php bin/console assets:install
````

10/ Update the database schema, check the SQL query generated by Doctrine :
````bash
php bin/console doctrine:schema:update --dump-sql
````
Then if the SQL queries looks OK, run :
````bash
php bin/console doctrine:schema:update --force
````

11/ (Optional but necessary in many cases)

Override templates "Common/base.html.twig" and "Common/header.html.twig" to adapt the bundle templates to your application

Example : create the file "templates/bundles/YosimitsoWorkingForumBundle/Common/base.html.twig" with at least :
````twig
{% block forum %}
{% endblock %}
````

12/ Set your mailer DNS in your .env file, example :
````
MAILER_DSN=smtp://user:pass@smtp.example.com
````
13/ (Optional) You can also override the translations files


