﻿# 第二章

第二章实现的操作系统被称为“邓氏鱼”。邓氏鱼是这样一种生物：在它生存的年代，它最大、最强，非常有效的颌、眼睛和尾巴提供了充分强大的咬合力、视力和游泳能力，这些结构在泥盆纪都堪称先进。然而，在泥盆纪末灭绝事件中，以邓氏鱼为代表的所有盾皮鱼类都迅速而彻底地灭绝了。在今天的海洋里，我们没有发现什么与之在演化上接近的生物。演化就是这样短视。一时非常有效的设计，可能随着环境微妙的一点改变就完全不适用了，设计也是一样。

因此，在迈向更复杂的系统之前，就让我们任性地实现一个保持简单的单道批处理系统吧。如你所见，第二章依然只有一个 [main.rs](src/main.rs) 文件，而且算上注释也不到 150 行（当然，它使用了更多的依赖）。重点关注 [`syscall`](src/main.rs#L29) 和 [`Context`](src/main.rs#L36) 的用法，这就是邓氏鱼的大脑和脊椎，这些真正成功的结构是不会随着某些物种的灭绝而消失的。

> **注意** 如果修改了用户程序，需要 `cargo clean` 重新编译才能刷新，不知道怎么优化。

## 实验

提高 `write` 系统调用安全性的实验只需要在第二章代码上做一点修改，没必要再做一个新的 bin crate 了。
