package yaycrawler.common.utils;

/**
 * Created by Administrator on 2016/4/1.
 */

import org.apache.commons.lang3.StringUtils;

import java.io.*;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CSVUtils {

    /**
     * 导出
     *
     * @param file     csv文件(路径+文件名)，csv文件不存在会自动创建
     * @param dataList 数据
     * @return
     */
    public static boolean exportCsv(File file, List<String> dataList) {
        boolean isSucess = false;

        FileOutputStream out = null;
        OutputStreamWriter osw = null;
        BufferedWriter bw = null;
        try {
            out = new FileOutputStream(file);
            osw = new OutputStreamWriter(out,"utf-8");
            bw = new BufferedWriter(osw);
            if (dataList != null && !dataList.isEmpty()) {
                for (String data : dataList) {
                    bw.append(data).append("\r");
                }
            }
            isSucess = true;
        } catch (IOException e) {
            isSucess = false;
        } finally {
            if (bw != null) {
                try {
                    bw.close();
                    bw = null;
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (osw != null) {
                try {
                    osw.close();
                    osw = null;
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (out != null) {
                try {
                    out.close();
                    out = null;
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        return isSucess;
    }

    /**
     * 导入
     *
     * @param inputStream csv文件(路径+文件)
     * @return
     */
    public static List<Map> importCsv(InputStream inputStream) {
        List<Map> dataList = new ArrayList<Map>();
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader(inputStream,"utf-8"));
            String line = br.readLine();
            if(line == null)
                return dataList;
            String[] title = line.split(",");
            while ((line = br.readLine()) != null) {
               Map map = new HashMap();
                String[] value = line.split(",");
                for (int i = 0; i <title.length; i++) {
                    map.put(title[i], StringUtils.trim(value[i]));
                }
                dataList.add(map);
            }
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            if (br != null) {
                try {
                    br.close();
                    br = null;
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        return dataList;
    }

}
