# Commercial License for Yao

This document outlines the terms for the commercial license of the **Yao** project. While the Yao project is primarily licensed under the **Apache License, Version 2.0**, certain commercial use cases require a separate commercial license.

## 1. Commercial License Requirements

The following use cases require a commercial license:

1. **Application Hosting Services**  
   If you use Yao, or any derivative product (such as a forked or modified version of Yao), to provide Yao-based application hosting services (e.g., Software-as-a-Service (SaaS) or Platform-as-a-Service (PaaS)) to users, you must obtain a commercial license. This restriction applies regardless of whether the original Yao code or a modified version is used to host and manage applications on behalf of third-party users for commercial purposes.  
   **In addition**, if you provide hosting services for applications that are built using Yao (even if they are customized or modified versions of Yao), a commercial license is required.

   ### Definition: Application Hosting Services

   "Application Hosting Services" refers to any service that involves hosting Yao-based applications or web applications created with Yao (including modified versions of Yao) for third-party users. This includes, but is not limited to:

   - **Hosting platforms** providing software or services built on top of Yao for third-party users.
   - **SaaS or PaaS offerings** where you manage and host applications that are based on or utilize Yao, either in their original or modified form.
   - **Managed hosting services** where Yao is used as the underlying technology for applications deployed for external clients.

   In these cases, a commercial license is required, whether you are using the original Yao code or a fork/modified version.

2. **AI Web Application Generation Services**  
   If you provide services that generate AI-driven web applications using Yao, or any derivative product (such as a fork or modified version of Yao), to third-party users, you are required to purchase a commercial license.

   ### Definition: AI Web Application Generation Services

   "AI Web Application Generation Services" refers to any service or functionality that utilizes Yao (or any forked or modified version of Yao) to automate the creation of web applications with AI capabilities. This includes, but is not limited to, providing third-party users with:

   - **Automated web application development** driven by AI, where the service generates complete or partial web applications.
   - **Customizable web solutions** that are powered by AI and built using Yao as the core technology.
   - **On-demand application generation** for specific client needs, using Yao to dynamically build, configure, or deploy applications for users.

   In these cases, whether Yao is directly used, forked, or modified, a commercial license is required to operate legally.

## 2. Use Under Apache License 2.0

For all other uses, the **Apache License, Version 2.0** applies. You are free to use, modify, and distribute the Yao project under the terms of Apache 2.0 as long as your usage does not fall within the restricted scenarios outlined above.

## 3. Obtaining a Commercial License

To inquire about or obtain a commercial license, please contact us at:

- **Email**: [friends@iqka.com]
- **Website**: [https://moapi.ai/contact]

Pricing and terms for commercial licenses vary based on usage scenarios, user scale, and other factors.

## 4. Compliance and Auditing

If you have any questions about whether your use case requires a commercial license, please contact us for clarification. We reserve the right to audit usage for compliance and enforce commercial licensing terms where necessary.

## 5. Disclaimer

Failure to comply with these licensing terms may result in a violation of the Yao licensing agreement and could lead to legal action.

---

**Note:** This commercial license is supplementary to the Apache 2.0 license and only applies in specific commercial scenarios outlined above.
