package com.yangdai.opennote.presentation.component.setting

import androidx.compose.animation.AnimatedVisibility
import androidx.compose.animation.expandIn
import androidx.compose.animation.fadeIn
import androidx.compose.animation.fadeOut
import androidx.compose.animation.shrinkOut
import androidx.compose.foundation.background
import androidx.compose.foundation.clickable
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.offset
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.layout.size
import androidx.compose.foundation.shape.CircleShape
import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.outlined.Check
import androidx.compose.material3.ColorScheme
import androidx.compose.material3.Icon
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.Surface
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.draw.clip
import androidx.compose.ui.unit.dp

@Composable
fun SelectableColorPlatte(
    modifier: Modifier = Modifier,
    selected: Boolean,
    colorScheme: ColorScheme,
    onClick: () -> Unit
) = Surface(
    modifier = modifier,
    shape = MaterialTheme.shapes.large,
    color = MaterialTheme.colorScheme.surfaceContainer
) {
    Surface(
        modifier = Modifier
            .clickable { onClick() }
            .padding(12.dp)
            .size(48.dp),
        shape = CircleShape,
        color = colorScheme.primary,
    ) {
        Box {
            Surface(
                modifier = Modifier
                    .size(48.dp)
                    .offset((-24).dp, 24.dp),
                color = colorScheme.tertiary,
            ) {}
            Surface(
                modifier = Modifier
                    .size(48.dp)
                    .offset(24.dp, 24.dp),
                color = colorScheme.secondaryContainer,
            ) {}
            AnimatedVisibility(
                visible = selected,
                modifier = Modifier
                    .align(Alignment.Center)
                    .clip(CircleShape)
                    .background(colorScheme.tertiaryContainer),
                enter = fadeIn() + expandIn(expandFrom = Alignment.Center),
                exit = shrinkOut(shrinkTowards = Alignment.Center) + fadeOut()
            ) {
                Icon(
                    imageVector = Icons.Outlined.Check,
                    contentDescription = "Checked",
                    modifier = Modifier
                        .padding(8.dp)
                        .size(16.dp),
                    tint = MaterialTheme.colorScheme.surface
                )
            }
        }
    }
}
