let qrCodeStyle = '{"width":1024,"height":1024,"data":"","margin":0,"qrOptions":{"typeNumber":"0","mode":"Byte","errorCorrectionLevel":"Q"},"imageOptions":{"hideBackgroundDots":true,"imageSize":0.4,"margin":0},"dotsOptions":{"type":"extra-rounded","color":"#6a1a4c","gradient":{"type":"linear","rotation":0,"colorStops":[{"offset":0,"color":"#377d96"},{"offset":1,"color":"#5a5096"}]}},"backgroundOptions":{"color":"rgba(0,0,0,0)"},"image":"data:image/png;base64,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","dotsOptionsHelper":{"colorType":{"single":true,"gradient":false},"gradient":{"linear":true,"radial":false,"color1":"#6a1a4c","color2":"#6a1a4c","rotation":"0"}},"cornersSquareOptions":{"type":"extra-rounded","color":"#000000","gradient":{"type":"linear","rotation":0,"colorStops":[{"offset":0,"color":"#377d96"},{"offset":1,"color":"#5a5096"}]}},"cornersSquareOptionsHelper":{"colorType":{"single":true,"gradient":false},"gradient":{"linear":true,"radial":false,"color1":"#000000","color2":"#000000","rotation":"0"}},"cornersDotOptions":{"type":"","color":"#000000","gradient":{"type":"linear","rotation":0,"colorStops":[{"offset":0,"color":"#377d96"},{"offset":1,"color":"#5a5096"}]}},"cornersDotOptionsHelper":{"colorType":{"single":true,"gradient":false},"gradient":{"linear":true,"radial":false,"color1":"#000000","color2":"#000000","rotation":"0"}},"backgroundOptionsHelper":{"colorType":{"single":true,"gradient":false},"gradient":{"linear":true,"radial":false,"color1":"#ffffff","color2":"#ffffff","rotation":"0"}}}';

!function(t,r){"object"==typeof exports&&"object"==typeof module?module.exports=r():"function"==typeof define&&define.amd?define([],r):"object"==typeof exports?exports.QRCodeStyling=r():t.QRCodeStyling=r()}(self,(function(){return(()=>{var t={192:(t,r)=>{var e,n,o=function(){var t=function(t,r){var e=t,n=a[r],o=null,i=0,u=null,v=[],y={},x=function(t,r){o=function(t){for(var r=new Array(t),e=0;e<t;e+=1){r[e]=new Array(t);for(var n=0;n<t;n+=1)r[e][n]=null}return r}(i=4*e+17),b(0,0),b(i-7,0),b(0,i-7),M(),_(),S(t,r),e>=7&&m(t),null==u&&(u=C(e,n,v)),O(u,r)},b=function(t,r){for(var e=-1;e<=7;e+=1)if(!(t+e<=-1||i<=t+e))for(var n=-1;n<=7;n+=1)r+n<=-1||i<=r+n||(o[t+e][r+n]=0<=e&&e<=6&&(0==n||6==n)||0<=n&&n<=6&&(0==e||6==e)||2<=e&&e<=4&&2<=n&&n<=4)},_=function(){for(var t=8;t<i-8;t+=1)null==o[t][6]&&(o[t][6]=t%2==0);for(var r=8;r<i-8;r+=1)null==o[6][r]&&(o[6][r]=r%2==0)},M=function(){for(var t=s.getPatternPosition(e),r=0;r<t.length;r+=1)for(var n=0;n<t.length;n+=1){var i=t[r],a=t[n];if(null==o[i][a])for(var u=-2;u<=2;u+=1)for(var c=-2;c<=2;c+=1)o[i+u][a+c]=-2==u||2==u||-2==c||2==c||0==u&&0==c}},m=function(t){for(var r=s.getBCHTypeNumber(e),n=0;n<18;n+=1){var a=!t&&1==(r>>n&1);o[Math.floor(n/3)][n%3+i-8-3]=a}for(n=0;n<18;n+=1)a=!t&&1==(r>>n&1),o[n%3+i-8-3][Math.floor(n/3)]=a},S=function(t,r){for(var e=n<<3|r,a=s.getBCHTypeInfo(e),u=0;u<15;u+=1){var c=!t&&1==(a>>u&1);u<6?o[u][8]=c:u<8?o[u+1][8]=c:o[i-15+u][8]=c}for(u=0;u<15;u+=1)c=!t&&1==(a>>u&1),u<8?o[8][i-u-1]=c:u<9?o[8][15-u-1+1]=c:o[8][15-u-1]=c;o[i-8][8]=!t},O=function(t,r){for(var e=-1,n=i-1,a=7,u=0,c=s.getMaskFunction(r),h=i-1;h>0;h-=2)for(6==h&&(h-=1);;){for(var f=0;f<2;f+=1)if(null==o[n][h-f]){var d=!1;u<t.length&&(d=1==(t[u]>>>a&1)),c(n,h-f)&&(d=!d),o[n][h-f]=d,-1==(a-=1)&&(u+=1,a=7)}if((n+=e)<0||i<=n){n-=e,e=-e;break}}},C=function(t,r,e){for(var n=h.getRSBlocks(t,r),o=f(),i=0;i<e.length;i+=1){var a=e[i];o.put(a.getMode(),4),o.put(a.getLength(),s.getLengthInBits(a.getMode(),t)),a.write(o)}var u=0;for(i=0;i<n.length;i+=1)u+=n[i].dataCount;if(o.getLengthInBits()>8*u)throw"code length overflow. ("+o.getLengthInBits()+">"+8*u+")";for(o.getLengthInBits()+4<=8*u&&o.put(0,4);o.getLengthInBits()%8!=0;)o.putBit(!1);for(;!(o.getLengthInBits()>=8*u||(o.put(236,8),o.getLengthInBits()>=8*u));)o.put(17,8);return function(t,r){for(var e=0,n=0,o=0,i=new Array(r.length),a=new Array(r.length),u=0;u<r.length;u+=1){var h=r[u].dataCount,f=r[u].totalCount-h;n=Math.max(n,h),o=Math.max(o,f),i[u]=new Array(h);for(var d=0;d<i[u].length;d+=1)i[u][d]=255&t.getBuffer()[d+e];e+=h;var l=s.getErrorCorrectPolynomial(f),g=c(i[u],l.getLength()-1).mod(l);for(a[u]=new Array(l.getLength()-1),d=0;d<a[u].length;d+=1){var p=d+g.getLength()-a[u].length;a[u][d]=p>=0?g.getAt(p):0}}var v=0;for(d=0;d<r.length;d+=1)v+=r[d].totalCount;var y=new Array(v),w=0;for(d=0;d<n;d+=1)for(u=0;u<r.length;u+=1)d<i[u].length&&(y[w]=i[u][d],w+=1);for(d=0;d<o;d+=1)for(u=0;u<r.length;u+=1)d<a[u].length&&(y[w]=a[u][d],w+=1);return y}(o,n)};y.addData=function(t,r){var e=null;switch(r=r||"Byte"){case"Numeric":e=d(t);break;case"Alphanumeric":e=l(t);break;case"Byte":e=g(t);break;case"Kanji":e=p(t);break;default:throw"mode:"+r}v.push(e),u=null},y.isDark=function(t,r){if(t<0||i<=t||r<0||i<=r)throw t+","+r;return o[t][r]},y.getModuleCount=function(){return i},y.make=function(){if(e<1){for(var t=1;t<40;t++){for(var r=h.getRSBlocks(t,n),o=f(),i=0;i<v.length;i++){var a=v[i];o.put(a.getMode(),4),o.put(a.getLength(),s.getLengthInBits(a.getMode(),t)),a.write(o)}var u=0;for(i=0;i<r.length;i++)u+=r[i].dataCount;if(o.getLengthInBits()<=8*u)break}e=t}x(!1,function(){for(var t=0,r=0,e=0;e<8;e+=1){x(!0,e);var n=s.getLostPoint(y);(0==e||t>n)&&(t=n,r=e)}return r}())},y.createTableTag=function(t,r){t=t||2;var e="";e+='<table style="',e+=" border-width: 0px; border-style: none;",e+=" border-collapse: collapse;",e+=" padding: 0px; margin: "+(r=void 0===r?4*t:r)+"px;",e+='">',e+="<tbody>";for(var n=0;n<y.getModuleCount();n+=1){e+="<tr>";for(var o=0;o<y.getModuleCount();o+=1)e+='<td style="',e+=" border-width: 0px; border-style: none;",e+=" border-collapse: collapse;",e+=" padding: 0px; margin: 0px;",e+=" width: "+t+"px;",e+=" height: "+t+"px;",e+=" background-color: ",e+=y.isDark(n,o)?"#000000":"#ffffff",e+=";",e+='"/>';e+="</tr>"}return(e+="</tbody>")+"</table>"},y.createSvgTag=function(t,r,e,n){var o={};"object"==typeof arguments[0]&&(t=(o=arguments[0]).cellSize,r=o.margin,e=o.alt,n=o.title),t=t||2,r=void 0===r?4*t:r,(e="string"==typeof e?{text:e}:e||{}).text=e.text||null,e.id=e.text?e.id||"qrcode-description":null,(n="string"==typeof n?{text:n}:n||{}).text=n.text||null,n.id=n.text?n.id||"qrcode-title":null;var i,a,s,u,c=y.getModuleCount()*t+2*r,h="";for(u="l"+t+",0 0,"+t+" -"+t+",0 0,-"+t+"z ",h+='<svg version="1.1" xmlns="http://www.w3.org/2000/svg"',h+=o.scalable?"":' width="'+c+'px" height="'+c+'px"',h+=' viewBox="0 0 '+c+" "+c+'" ',h+=' preserveAspectRatio="xMinYMin meet"',h+=n.text||e.text?' role="img" aria-labelledby="'+k([n.id,e.id].join(" ").trim())+'"':"",h+=">",h+=n.text?'<title id="'+k(n.id)+'">'+k(n.text)+"</title>":"",h+=e.text?'<description id="'+k(e.id)+'">'+k(e.text)+"</description>":"",h+='<rect width="100%" height="100%" fill="white" cx="0" cy="0"/>',h+='<path d="',a=0;a<y.getModuleCount();a+=1)for(s=a*t+r,i=0;i<y.getModuleCount();i+=1)y.isDark(a,i)&&(h+="M"+(i*t+r)+","+s+u);return(h+='" stroke="transparent" fill="black"/>')+"</svg>"},y.createDataURL=function(t,r){t=t||2,r=void 0===r?4*t:r;var e=y.getModuleCount()*t+2*r,n=r,o=e-r;return w(e,e,(function(r,e){if(n<=r&&r<o&&n<=e&&e<o){var i=Math.floor((r-n)/t),a=Math.floor((e-n)/t);return y.isDark(a,i)?0:1}return 1}))},y.createImgTag=function(t,r,e){t=t||2,r=void 0===r?4*t:r;var n=y.getModuleCount()*t+2*r,o="";return o+="<img",o+=' src="',o+=y.createDataURL(t,r),o+='"',o+=' width="',o+=n,o+='"',o+=' height="',o+=n,o+='"',e&&(o+=' alt="',o+=k(e),o+='"'),o+"/>"};var k=function(t){for(var r="",e=0;e<t.length;e+=1){var n=t.charAt(e);switch(n){case"<":r+="&lt;";break;case">":r+="&gt;";break;case"&":r+="&amp;";break;case'"':r+="&quot;";break;default:r+=n}}return r};return y.createASCII=function(t,r){if((t=t||1)<2)return function(t){t=void 0===t?2:t;var r,e,n,o,i,a=1*y.getModuleCount()+2*t,s=t,u=a-t,c={"██":"█","█ ":"▀"," █":"▄","  ":" "},h={"██":"▀","█ ":"▀"," █":" ","  ":" "},f="";for(r=0;r<a;r+=2){for(n=Math.floor((r-s)/1),o=Math.floor((r+1-s)/1),e=0;e<a;e+=1)i="█",s<=e&&e<u&&s<=r&&r<u&&y.isDark(n,Math.floor((e-s)/1))&&(i=" "),s<=e&&e<u&&s<=r+1&&r+1<u&&y.isDark(o,Math.floor((e-s)/1))?i+=" ":i+="█",f+=t<1&&r+1>=u?h[i]:c[i];f+="\n"}return a%2&&t>0?f.substring(0,f.length-a-1)+Array(a+1).join("▀"):f.substring(0,f.length-1)}(r);t-=1,r=void 0===r?2*t:r;var e,n,o,i,a=y.getModuleCount()*t+2*r,s=r,u=a-r,c=Array(t+1).join("██"),h=Array(t+1).join("  "),f="",d="";for(e=0;e<a;e+=1){for(o=Math.floor((e-s)/t),d="",n=0;n<a;n+=1)i=1,s<=n&&n<u&&s<=e&&e<u&&y.isDark(o,Math.floor((n-s)/t))&&(i=0),d+=i?c:h;for(o=0;o<t;o+=1)f+=d+"\n"}return f.substring(0,f.length-1)},y.renderTo2dContext=function(t,r){r=r||2;for(var e=y.getModuleCount(),n=0;n<e;n++)for(var o=0;o<e;o++)t.fillStyle=y.isDark(n,o)?"black":"white",t.fillRect(n*r,o*r,r,r)},y};t.stringToBytes=(t.stringToBytesFuncs={default:function(t){for(var r=[],e=0;e<t.length;e+=1){var n=t.charCodeAt(e);r.push(255&n)}return r}}).default,t.createStringToBytes=function(t,r){var e=function(){for(var e=y(t),n=function(){var t=e.read();if(-1==t)throw"eof";return t},o=0,i={};;){var a=e.read();if(-1==a)break;var s=n(),u=n()<<8|n();i[String.fromCharCode(a<<8|s)]=u,o+=1}if(o!=r)throw o+" != "+r;return i}(),n="?".charCodeAt(0);return function(t){for(var r=[],o=0;o<t.length;o+=1){var i=t.charCodeAt(o);if(i<128)r.push(i);else{var a=e[t.charAt(o)];"number"==typeof a?(255&a)==a?r.push(a):(r.push(a>>>8),r.push(255&a)):r.push(n)}}return r}};var r,e,n,o,i,a={L:1,M:0,Q:3,H:2},s=(r=[[],[6,18],[6,22],[6,26],[6,30],[6,34],[6,22,38],[6,24,42],[6,26,46],[6,28,50],[6,30,54],[6,32,58],[6,34,62],[6,26,46,66],[6,26,48,70],[6,26,50,74],[6,30,54,78],[6,30,56,82],[6,30,58,86],[6,34,62,90],[6,28,50,72,94],[6,26,50,74,98],[6,30,54,78,102],[6,28,54,80,106],[6,32,58,84,110],[6,30,58,86,114],[6,34,62,90,118],[6,26,50,74,98,122],[6,30,54,78,102,126],[6,26,52,78,104,130],[6,30,56,82,108,134],[6,34,60,86,112,138],[6,30,58,86,114,142],[6,34,62,90,118,146],[6,30,54,78,102,126,150],[6,24,50,76,102,128,154],[6,28,54,80,106,132,158],[6,32,58,84,110,136,162],[6,26,54,82,110,138,166],[6,30,58,86,114,142,170]],e=1335,n=7973,i=function(t){for(var r=0;0!=t;)r+=1,t>>>=1;return r},(o={}).getBCHTypeInfo=function(t){for(var r=t<<10;i(r)-i(e)>=0;)r^=e<<i(r)-i(e);return 21522^(t<<10|r)},o.getBCHTypeNumber=function(t){for(var r=t<<12;i(r)-i(n)>=0;)r^=n<<i(r)-i(n);return t<<12|r},o.getPatternPosition=function(t){return r[t-1]},o.getMaskFunction=function(t){switch(t){case 0:return function(t,r){return(t+r)%2==0};case 1:return function(t,r){return t%2==0};case 2:return function(t,r){return r%3==0};case 3:return function(t,r){return(t+r)%3==0};case 4:return function(t,r){return(Math.floor(t/2)+Math.floor(r/3))%2==0};case 5:return function(t,r){return t*r%2+t*r%3==0};case 6:return function(t,r){return(t*r%2+t*r%3)%2==0};case 7:return function(t,r){return(t*r%3+(t+r)%2)%2==0};default:throw"bad maskPattern:"+t}},o.getErrorCorrectPolynomial=function(t){for(var r=c([1],0),e=0;e<t;e+=1)r=r.multiply(c([1,u.gexp(e)],0));return r},o.getLengthInBits=function(t,r){if(1<=r&&r<10)switch(t){case 1:return 10;case 2:return 9;case 4:case 8:return 8;default:throw"mode:"+t}else if(r<27)switch(t){case 1:return 12;case 2:return 11;case 4:return 16;case 8:return 10;default:throw"mode:"+t}else{if(!(r<41))throw"type:"+r;switch(t){case 1:return 14;case 2:return 13;case 4:return 16;case 8:return 12;default:throw"mode:"+t}}},o.getLostPoint=function(t){for(var r=t.getModuleCount(),e=0,n=0;n<r;n+=1)for(var o=0;o<r;o+=1){for(var i=0,a=t.isDark(n,o),s=-1;s<=1;s+=1)if(!(n+s<0||r<=n+s))for(var u=-1;u<=1;u+=1)o+u<0||r<=o+u||0==s&&0==u||a==t.isDark(n+s,o+u)&&(i+=1);i>5&&(e+=3+i-5)}for(n=0;n<r-1;n+=1)for(o=0;o<r-1;o+=1){var c=0;t.isDark(n,o)&&(c+=1),t.isDark(n+1,o)&&(c+=1),t.isDark(n,o+1)&&(c+=1),t.isDark(n+1,o+1)&&(c+=1),0!=c&&4!=c||(e+=3)}for(n=0;n<r;n+=1)for(o=0;o<r-6;o+=1)t.isDark(n,o)&&!t.isDark(n,o+1)&&t.isDark(n,o+2)&&t.isDark(n,o+3)&&t.isDark(n,o+4)&&!t.isDark(n,o+5)&&t.isDark(n,o+6)&&(e+=40);for(o=0;o<r;o+=1)for(n=0;n<r-6;n+=1)t.isDark(n,o)&&!t.isDark(n+1,o)&&t.isDark(n+2,o)&&t.isDark(n+3,o)&&t.isDark(n+4,o)&&!t.isDark(n+5,o)&&t.isDark(n+6,o)&&(e+=40);var h=0;for(o=0;o<r;o+=1)for(n=0;n<r;n+=1)t.isDark(n,o)&&(h+=1);return e+Math.abs(100*h/r/r-50)/5*10},o),u=function(){for(var t=new Array(256),r=new Array(256),e=0;e<8;e+=1)t[e]=1<<e;for(e=8;e<256;e+=1)t[e]=t[e-4]^t[e-5]^t[e-6]^t[e-8];for(e=0;e<255;e+=1)r[t[e]]=e;return{glog:function(t){if(t<1)throw"glog("+t+")";return r[t]},gexp:function(r){for(;r<0;)r+=255;for(;r>=256;)r-=255;return t[r]}}}();function c(t,r){if(void 0===t.length)throw t.length+"/"+r;var e=function(){for(var e=0;e<t.length&&0==t[e];)e+=1;for(var n=new Array(t.length-e+r),o=0;o<t.length-e;o+=1)n[o]=t[o+e];return n}(),n={getAt:function(t){return e[t]},getLength:function(){return e.length},multiply:function(t){for(var r=new Array(n.getLength()+t.getLength()-1),e=0;e<n.getLength();e+=1)for(var o=0;o<t.getLength();o+=1)r[e+o]^=u.gexp(u.glog(n.getAt(e))+u.glog(t.getAt(o)));return c(r,0)},mod:function(t){if(n.getLength()-t.getLength()<0)return n;for(var r=u.glog(n.getAt(0))-u.glog(t.getAt(0)),e=new Array(n.getLength()),o=0;o<n.getLength();o+=1)e[o]=n.getAt(o);for(o=0;o<t.getLength();o+=1)e[o]^=u.gexp(u.glog(t.getAt(o))+r);return c(e,0).mod(t)}};return n}var h=function(){var t=[[1,26,19],[1,26,16],[1,26,13],[1,26,9],[1,44,34],[1,44,28],[1,44,22],[1,44,16],[1,70,55],[1,70,44],[2,35,17],[2,35,13],[1,100,80],[2,50,32],[2,50,24],[4,25,9],[1,134,108],[2,67,43],[2,33,15,2,34,16],[2,33,11,2,34,12],[2,86,68],[4,43,27],[4,43,19],[4,43,15],[2,98,78],[4,49,31],[2,32,14,4,33,15],[4,39,13,1,40,14],[2,121,97],[2,60,38,2,61,39],[4,40,18,2,41,19],[4,40,14,2,41,15],[2,146,116],[3,58,36,2,59,37],[4,36,16,4,37,17],[4,36,12,4,37,13],[2,86,68,2,87,69],[4,69,43,1,70,44],[6,43,19,2,44,20],[6,43,15,2,44,16],[4,101,81],[1,80,50,4,81,51],[4,50,22,4,51,23],[3,36,12,8,37,13],[2,116,92,2,117,93],[6,58,36,2,59,37],[4,46,20,6,47,21],[7,42,14,4,43,15],[4,133,107],[8,59,37,1,60,38],[8,44,20,4,45,21],[12,33,11,4,34,12],[3,145,115,1,146,116],[4,64,40,5,65,41],[11,36,16,5,37,17],[11,36,12,5,37,13],[5,109,87,1,110,88],[5,65,41,5,66,42],[5,54,24,7,55,25],[11,36,12,7,37,13],[5,122,98,1,123,99],[7,73,45,3,74,46],[15,43,19,2,44,20],[3,45,15,13,46,16],[1,135,107,5,136,108],[10,74,46,1,75,47],[1,50,22,15,51,23],[2,42,14,17,43,15],[5,150,120,1,151,121],[9,69,43,4,70,44],[17,50,22,1,51,23],[2,42,14,19,43,15],[3,141,113,4,142,114],[3,70,44,11,71,45],[17,47,21,4,48,22],[9,39,13,16,40,14],[3,135,107,5,136,108],[3,67,41,13,68,42],[15,54,24,5,55,25],[15,43,15,10,44,16],[4,144,116,4,145,117],[17,68,42],[17,50,22,6,51,23],[19,46,16,6,47,17],[2,139,111,7,140,112],[17,74,46],[7,54,24,16,55,25],[34,37,13],[4,151,121,5,152,122],[4,75,47,14,76,48],[11,54,24,14,55,25],[16,45,15,14,46,16],[6,147,117,4,148,118],[6,73,45,14,74,46],[11,54,24,16,55,25],[30,46,16,2,47,17],[8,132,106,4,133,107],[8,75,47,13,76,48],[7,54,24,22,55,25],[22,45,15,13,46,16],[10,142,114,2,143,115],[19,74,46,4,75,47],[28,50,22,6,51,23],[33,46,16,4,47,17],[8,152,122,4,153,123],[22,73,45,3,74,46],[8,53,23,26,54,24],[12,45,15,28,46,16],[3,147,117,10,148,118],[3,73,45,23,74,46],[4,54,24,31,55,25],[11,45,15,31,46,16],[7,146,116,7,147,117],[21,73,45,7,74,46],[1,53,23,37,54,24],[19,45,15,26,46,16],[5,145,115,10,146,116],[19,75,47,10,76,48],[15,54,24,25,55,25],[23,45,15,25,46,16],[13,145,115,3,146,116],[2,74,46,29,75,47],[42,54,24,1,55,25],[23,45,15,28,46,16],[17,145,115],[10,74,46,23,75,47],[10,54,24,35,55,25],[19,45,15,35,46,16],[17,145,115,1,146,116],[14,74,46,21,75,47],[29,54,24,19,55,25],[11,45,15,46,46,16],[13,145,115,6,146,116],[14,74,46,23,75,47],[44,54,24,7,55,25],[59,46,16,1,47,17],[12,151,121,7,152,122],[12,75,47,26,76,48],[39,54,24,14,55,25],[22,45,15,41,46,16],[6,151,121,14,152,122],[6,75,47,34,76,48],[46,54,24,10,55,25],[2,45,15,64,46,16],[17,152,122,4,153,123],[29,74,46,14,75,47],[49,54,24,10,55,25],[24,45,15,46,46,16],[4,152,122,18,153,123],[13,74,46,32,75,47],[48,54,24,14,55,25],[42,45,15,32,46,16],[20,147,117,4,148,118],[40,75,47,7,76,48],[43,54,24,22,55,25],[10,45,15,67,46,16],[19,148,118,6,149,119],[18,75,47,31,76,48],[34,54,24,34,55,25],[20,45,15,61,46,16]],r=function(t,r){var e={};return e.totalCount=t,e.dataCount=r,e},e={getRSBlocks:function(e,n){var o=function(r,e){switch(e){case a.L:return t[4*(r-1)+0];case a.M:return t[4*(r-1)+1];case a.Q:return t[4*(r-1)+2];case a.H:return t[4*(r-1)+3];default:return}}(e,n);if(void 0===o)throw"bad rs block @ typeNumber:"+e+"/errorCorrectionLevel:"+n;for(var i=o.length/3,s=[],u=0;u<i;u+=1)for(var c=o[3*u+0],h=o[3*u+1],f=o[3*u+2],d=0;d<c;d+=1)s.push(r(h,f));return s}};return e}(),f=function(){var t=[],r=0,e={getBuffer:function(){return t},getAt:function(r){var e=Math.floor(r/8);return 1==(t[e]>>>7-r%8&1)},put:function(t,r){for(var n=0;n<r;n+=1)e.putBit(1==(t>>>r-n-1&1))},getLengthInBits:function(){return r},putBit:function(e){var n=Math.floor(r/8);t.length<=n&&t.push(0),e&&(t[n]|=128>>>r%8),r+=1}};return e},d=function(t){var r=t,e={getMode:function(){return 1},getLength:function(t){return r.length},write:function(t){for(var e=r,o=0;o+2<e.length;)t.put(n(e.substring(o,o+3)),10),o+=3;o<e.length&&(e.length-o==1?t.put(n(e.substring(o,o+1)),4):e.length-o==2&&t.put(n(e.substring(o,o+2)),7))}},n=function(t){for(var r=0,e=0;e<t.length;e+=1)r=10*r+o(t.charAt(e));return r},o=function(t){if("0"<=t&&t<="9")return t.charCodeAt(0)-"0".charCodeAt(0);throw"illegal char :"+t};return e},l=function(t){var r=t,e={getMode:function(){return 2},getLength:function(t){return r.length},write:function(t){for(var e=r,o=0;o+1<e.length;)t.put(45*n(e.charAt(o))+n(e.charAt(o+1)),11),o+=2;o<e.length&&t.put(n(e.charAt(o)),6)}},n=function(t){if("0"<=t&&t<="9")return t.charCodeAt(0)-"0".charCodeAt(0);if("A"<=t&&t<="Z")return t.charCodeAt(0)-"A".charCodeAt(0)+10;switch(t){case" ":return 36;case"$":return 37;case"%":return 38;case"*":return 39;case"+":return 40;case"-":return 41;case".":return 42;case"/":return 43;case":":return 44;default:throw"illegal char :"+t}};return e},g=function(r){var e=t.stringToBytes(r);return{getMode:function(){return 4},getLength:function(t){return e.length},write:function(t){for(var r=0;r<e.length;r+=1)t.put(e[r],8)}}},p=function(r){var e=t.stringToBytesFuncs.SJIS;if(!e)throw"sjis not supported.";!function(t,r){var n=e("友");if(2!=n.length||38726!=(n[0]<<8|n[1]))throw"sjis not supported."}();var n=e(r);return{getMode:function(){return 8},getLength:function(t){return~~(n.length/2)},write:function(t){for(var r=n,e=0;e+1<r.length;){var o=(255&r[e])<<8|255&r[e+1];if(33088<=o&&o<=40956)o-=33088;else{if(!(57408<=o&&o<=60351))throw"illegal char at "+(e+1)+"/"+o;o-=49472}o=192*(o>>>8&255)+(255&o),t.put(o,13),e+=2}if(e<r.length)throw"illegal char at "+(e+1)}}},v=function(){var t=[],r={writeByte:function(r){t.push(255&r)},writeShort:function(t){r.writeByte(t),r.writeByte(t>>>8)},writeBytes:function(t,e,n){e=e||0,n=n||t.length;for(var o=0;o<n;o+=1)r.writeByte(t[o+e])},writeString:function(t){for(var e=0;e<t.length;e+=1)r.writeByte(t.charCodeAt(e))},toByteArray:function(){return t},toString:function(){var r="";r+="[";for(var e=0;e<t.length;e+=1)e>0&&(r+=","),r+=t[e];return r+"]"}};return r},y=function(t){var r=t,e=0,n=0,o=0,i={read:function(){for(;o<8;){if(e>=r.length){if(0==o)return-1;throw"unexpected end of file./"+o}var t=r.charAt(e);if(e+=1,"="==t)return o=0,-1;t.match(/^\s$/)||(n=n<<6|a(t.charCodeAt(0)),o+=6)}var i=n>>>o-8&255;return o-=8,i}},a=function(t){if(65<=t&&t<=90)return t-65;if(97<=t&&t<=122)return t-97+26;if(48<=t&&t<=57)return t-48+52;if(43==t)return 62;if(47==t)return 63;throw"c:"+t};return i},w=function(t,r,e){for(var n=function(t,r){var e=t,n=r,o=new Array(t*r),i={setPixel:function(t,r,n){o[r*e+t]=n},write:function(t){t.writeString("GIF87a"),t.writeShort(e),t.writeShort(n),t.writeByte(128),t.writeByte(0),t.writeByte(0),t.writeByte(0),t.writeByte(0),t.writeByte(0),t.writeByte(255),t.writeByte(255),t.writeByte(255),t.writeString(","),t.writeShort(0),t.writeShort(0),t.writeShort(e),t.writeShort(n),t.writeByte(0);var r=a(2);t.writeByte(2);for(var o=0;r.length-o>255;)t.writeByte(255),t.writeBytes(r,o,255),o+=255;t.writeByte(r.length-o),t.writeBytes(r,o,r.length-o),t.writeByte(0),t.writeString(";")}},a=function(t){for(var r=1<<t,e=1+(1<<t),n=t+1,i=s(),a=0;a<r;a+=1)i.add(String.fromCharCode(a));i.add(String.fromCharCode(r)),i.add(String.fromCharCode(e));var u,c,h,f=v(),d=(u=f,c=0,h=0,{write:function(t,r){if(t>>>r!=0)throw"length over";for(;c+r>=8;)u.writeByte(255&(t<<c|h)),r-=8-c,t>>>=8-c,h=0,c=0;h|=t<<c,c+=r},flush:function(){c>0&&u.writeByte(h)}});d.write(r,n);var l=0,g=String.fromCharCode(o[l]);for(l+=1;l<o.length;){var p=String.fromCharCode(o[l]);l+=1,i.contains(g+p)?g+=p:(d.write(i.indexOf(g),n),i.size()<4095&&(i.size()==1<<n&&(n+=1),i.add(g+p)),g=p)}return d.write(i.indexOf(g),n),d.write(e,n),d.flush(),f.toByteArray()},s=function(){var t={},r=0,e={add:function(n){if(e.contains(n))throw"dup key:"+n;t[n]=r,r+=1},size:function(){return r},indexOf:function(r){return t[r]},contains:function(r){return void 0!==t[r]}};return e};return i}(t,r),o=0;o<r;o+=1)for(var i=0;i<t;i+=1)n.setPixel(i,o,e(i,o));var a=v();n.write(a);for(var s=function(){var t=0,r=0,e=0,n="",o={},i=function(t){n+=String.fromCharCode(a(63&t))},a=function(t){if(t<0);else{if(t<26)return 65+t;if(t<52)return t-26+97;if(t<62)return t-52+48;if(62==t)return 43;if(63==t)return 47}throw"n:"+t};return o.writeByte=function(n){for(t=t<<8|255&n,r+=8,e+=1;r>=6;)i(t>>>r-6),r-=6},o.flush=function(){if(r>0&&(i(t<<6-r),t=0,r=0),e%3!=0)for(var o=3-e%3,a=0;a<o;a+=1)n+="="},o.toString=function(){return n},o}(),u=a.toByteArray(),c=0;c<u.length;c+=1)s.writeByte(u[c]);return s.flush(),"data:image/gif;base64,"+s};return t}();o.stringToBytesFuncs["UTF-8"]=function(t){return function(t){for(var r=[],e=0;e<t.length;e++){var n=t.charCodeAt(e);n<128?r.push(n):n<2048?r.push(192|n>>6,128|63&n):n<55296||n>=57344?r.push(224|n>>12,128|n>>6&63,128|63&n):(e++,n=65536+((1023&n)<<10|1023&t.charCodeAt(e)),r.push(240|n>>18,128|n>>12&63,128|n>>6&63,128|63&n))}return r}(t)},void 0===(n="function"==typeof(e=function(){return o})?e.apply(r,[]):e)||(t.exports=n)},669:(t,r,e)=>{"use strict";e.d(r,{default:()=>O});var n=function(){return(n=Object.assign||function(t){for(var r,e=1,n=arguments.length;e<n;e++)for(var o in r=arguments[e])Object.prototype.hasOwnProperty.call(r,o)&&(t[o]=r[o]);return t}).apply(this,arguments)},o=function(){for(var t=0,r=0,e=arguments.length;r<e;r++)t+=arguments[r].length;var n=Array(t),o=0;for(r=0;r<e;r++)for(var i=arguments[r],a=0,s=i.length;a<s;a++,o++)n[o]=i[a];return n},i=function(t){return!!t&&"object"==typeof t&&!Array.isArray(t)};function a(t){for(var r=[],e=1;e<arguments.length;e++)r[e-1]=arguments[e];if(!r.length)return t;var s=r.shift();return void 0!==s&&i(t)&&i(s)?(t=n({},t),Object.keys(s).forEach((function(r){var e=t[r],n=s[r];Array.isArray(e)&&Array.isArray(n)?t[r]=n:i(e)&&i(n)?t[r]=a(Object.assign({},e),n):t[r]=n})),a.apply(void 0,o([t],r))):t}const s={L:.07,M:.15,Q:.25,H:.3};var u=function(){return(u=Object.assign||function(t){for(var r,e=1,n=arguments.length;e<n;e++)for(var o in r=arguments[e])Object.prototype.hasOwnProperty.call(r,o)&&(t[o]=r[o]);return t}).apply(this,arguments)};const c=function(){function t(t){var r=t.context,e=t.type;this._context=r,this._type=e}return t.prototype.draw=function(t,r,e,n){var o,i=this._context;switch(this._type){case"dots":o=this._drawDot;break;case"classy":o=this._drawClassy;break;case"classy-rounded":o=this._drawClassyRounded;break;case"rounded":o=this._drawRounded;break;case"extra-rounded":o=this._drawExtraRounded;break;case"square":default:o=this._drawSquare}o.call(this,{x:t,y:r,size:e,context:i,getNeighbor:n})},t.prototype._rotateFigure=function(t){var r=t.x,e=t.y,n=t.size,o=t.context,i=t.rotation,a=t.draw,s=r+n/2,u=e+n/2;o.translate(s,u),i&&o.rotate(i),a(),o.closePath(),i&&o.rotate(-i),o.translate(-s,-u)},t.prototype._basicDot=function(t){var r=t.size,e=t.context;this._rotateFigure(u(u({},t),{draw:function(){e.arc(0,0,r/2,0,2*Math.PI)}}))},t.prototype._basicSquare=function(t){var r=t.size,e=t.context;this._rotateFigure(u(u({},t),{draw:function(){e.rect(-r/2,-r/2,r,r)}}))},t.prototype._basicSideRounded=function(t){var r=t.size,e=t.context;this._rotateFigure(u(u({},t),{draw:function(){e.arc(0,0,r/2,-Math.PI/2,Math.PI/2),e.lineTo(-r/2,r/2),e.lineTo(-r/2,-r/2),e.lineTo(0,-r/2)}}))},t.prototype._basicCornerRounded=function(t){var r=t.size,e=t.context;this._rotateFigure(u(u({},t),{draw:function(){e.arc(0,0,r/2,-Math.PI/2,0),e.lineTo(r/2,r/2),e.lineTo(-r/2,r/2),e.lineTo(-r/2,-r/2),e.lineTo(0,-r/2)}}))},t.prototype._basicCornerExtraRounded=function(t){var r=t.size,e=t.context;this._rotateFigure(u(u({},t),{draw:function(){e.arc(-r/2,r/2,r,-Math.PI/2,0),e.lineTo(-r/2,r/2),e.lineTo(-r/2,-r/2)}}))},t.prototype._basicCornersRounded=function(t){var r=t.size,e=t.context;this._rotateFigure(u(u({},t),{draw:function(){e.arc(0,0,r/2,-Math.PI/2,0),e.lineTo(r/2,r/2),e.lineTo(0,r/2),e.arc(0,0,r/2,Math.PI/2,Math.PI),e.lineTo(-r/2,-r/2),e.lineTo(0,-r/2)}}))},t.prototype._basicCornersExtraRounded=function(t){var r=t.size,e=t.context;this._rotateFigure(u(u({},t),{draw:function(){e.arc(-r/2,r/2,r,-Math.PI/2,0),e.arc(r/2,-r/2,r,Math.PI/2,Math.PI)}}))},t.prototype._drawDot=function(t){var r=t.x,e=t.y,n=t.size,o=t.context;this._basicDot({x:r,y:e,size:n,context:o,rotation:0})},t.prototype._drawSquare=function(t){var r=t.x,e=t.y,n=t.size,o=t.context;this._basicSquare({x:r,y:e,size:n,context:o,rotation:0})},t.prototype._drawRounded=function(t){var r=t.x,e=t.y,n=t.size,o=t.context,i=t.getNeighbor,a=+i(-1,0),s=+i(1,0),u=+i(0,-1),c=+i(0,1),h=a+s+u+c;if(0!==h)if(h>2||a&&s||u&&c)this._basicSquare({x:r,y:e,size:n,context:o,rotation:0});else{if(2===h){var f=0;return a&&u?f=Math.PI/2:u&&s?f=Math.PI:s&&c&&(f=-Math.PI/2),void this._basicCornerRounded({x:r,y:e,size:n,context:o,rotation:f})}if(1===h)return f=0,u?f=Math.PI/2:s?f=Math.PI:c&&(f=-Math.PI/2),void this._basicSideRounded({x:r,y:e,size:n,context:o,rotation:f})}else this._basicDot({x:r,y:e,size:n,context:o,rotation:0})},t.prototype._drawExtraRounded=function(t){var r=t.x,e=t.y,n=t.size,o=t.context,i=t.getNeighbor,a=+i(-1,0),s=+i(1,0),u=+i(0,-1),c=+i(0,1),h=a+s+u+c;if(0!==h)if(h>2||a&&s||u&&c)this._basicSquare({x:r,y:e,size:n,context:o,rotation:0});else{if(2===h){var f=0;return a&&u?f=Math.PI/2:u&&s?f=Math.PI:s&&c&&(f=-Math.PI/2),void this._basicCornerExtraRounded({x:r,y:e,size:n,context:o,rotation:f})}if(1===h)return f=0,u?f=Math.PI/2:s?f=Math.PI:c&&(f=-Math.PI/2),void this._basicSideRounded({x:r,y:e,size:n,context:o,rotation:f})}else this._basicDot({x:r,y:e,size:n,context:o,rotation:0})},t.prototype._drawClassy=function(t){var r=t.x,e=t.y,n=t.size,o=t.context,i=t.getNeighbor,a=+i(-1,0),s=+i(1,0),u=+i(0,-1),c=+i(0,1);0!==a+s+u+c?a||u?s||c?this._basicSquare({x:r,y:e,size:n,context:o,rotation:0}):this._basicCornerRounded({x:r,y:e,size:n,context:o,rotation:Math.PI/2}):this._basicCornerRounded({x:r,y:e,size:n,context:o,rotation:-Math.PI/2}):this._basicCornersRounded({x:r,y:e,size:n,context:o,rotation:Math.PI/2})},t.prototype._drawClassyRounded=function(t){var r=t.x,e=t.y,n=t.size,o=t.context,i=t.getNeighbor,a=+i(-1,0),s=+i(1,0),u=+i(0,-1),c=+i(0,1);0!==a+s+u+c?a||u?s||c?this._basicSquare({x:r,y:e,size:n,context:o,rotation:0}):this._basicCornerExtraRounded({x:r,y:e,size:n,context:o,rotation:Math.PI/2}):this._basicCornerExtraRounded({x:r,y:e,size:n,context:o,rotation:-Math.PI/2}):this._basicCornersRounded({x:r,y:e,size:n,context:o,rotation:Math.PI/2})},t}();var h=function(){return(h=Object.assign||function(t){for(var r,e=1,n=arguments.length;e<n;e++)for(var o in r=arguments[e])Object.prototype.hasOwnProperty.call(r,o)&&(t[o]=r[o]);return t}).apply(this,arguments)};const f=function(){function t(t){var r=t.context,e=t.type;this._context=r,this._type=e}return t.prototype.draw=function(t,r,e,n){var o,i=this._context;switch(this._type){case"square":o=this._drawSquare;break;case"extra-rounded":o=this._drawExtraRounded;break;case"dot":default:o=this._drawDot}o.call(this,{x:t,y:r,size:e,context:i,rotation:n})},t.prototype._rotateFigure=function(t){var r=t.x,e=t.y,n=t.size,o=t.context,i=t.rotation,a=t.draw,s=r+n/2,u=e+n/2;o.translate(s,u),i&&o.rotate(i),a(),o.closePath(),i&&o.rotate(-i),o.translate(-s,-u)},t.prototype._basicDot=function(t){var r=t.size,e=t.context,n=r/7;this._rotateFigure(h(h({},t),{draw:function(){e.arc(0,0,r/2,0,2*Math.PI),e.arc(0,0,r/2-n,0,2*Math.PI)}}))},t.prototype._basicSquare=function(t){var r=t.size,e=t.context,n=r/7;this._rotateFigure(h(h({},t),{draw:function(){e.rect(-r/2,-r/2,r,r),e.rect(-r/2+n,-r/2+n,r-2*n,r-2*n)}}))},t.prototype._basicExtraRounded=function(t){var r=t.size,e=t.context,n=r/7;this._rotateFigure(h(h({},t),{draw:function(){e.arc(-n,-n,2.5*n,Math.PI,-Math.PI/2),e.lineTo(n,-3.5*n),e.arc(n,-n,2.5*n,-Math.PI/2,0),e.lineTo(3.5*n,-n),e.arc(n,n,2.5*n,0,Math.PI/2),e.lineTo(-n,3.5*n),e.arc(-n,n,2.5*n,Math.PI/2,Math.PI),e.lineTo(-3.5*n,-n),e.arc(-n,-n,1.5*n,Math.PI,-Math.PI/2),e.lineTo(n,-2.5*n),e.arc(n,-n,1.5*n,-Math.PI/2,0),e.lineTo(2.5*n,-n),e.arc(n,n,1.5*n,0,Math.PI/2),e.lineTo(-n,2.5*n),e.arc(-n,n,1.5*n,Math.PI/2,Math.PI),e.lineTo(-2.5*n,-n)}}))},t.prototype._drawDot=function(t){var r=t.x,e=t.y,n=t.size,o=t.context,i=t.rotation;this._basicDot({x:r,y:e,size:n,context:o,rotation:i})},t.prototype._drawSquare=function(t){var r=t.x,e=t.y,n=t.size,o=t.context,i=t.rotation;this._basicSquare({x:r,y:e,size:n,context:o,rotation:i})},t.prototype._drawExtraRounded=function(t){var r=t.x,e=t.y,n=t.size,o=t.context,i=t.rotation;this._basicExtraRounded({x:r,y:e,size:n,context:o,rotation:i})},t}();var d=function(){return(d=Object.assign||function(t){for(var r,e=1,n=arguments.length;e<n;e++)for(var o in r=arguments[e])Object.prototype.hasOwnProperty.call(r,o)&&(t[o]=r[o]);return t}).apply(this,arguments)};const l=function(){function t(t){var r=t.context,e=t.type;this._context=r,this._type=e}return t.prototype.draw=function(t,r,e,n){var o,i=this._context;switch(this._type){case"square":o=this._drawSquare;break;case"dot":default:o=this._drawDot}o.call(this,{x:t,y:r,size:e,context:i,rotation:n})},t.prototype._rotateFigure=function(t){var r=t.x,e=t.y,n=t.size,o=t.context,i=t.rotation,a=t.draw,s=r+n/2,u=e+n/2;o.translate(s,u),i&&o.rotate(i),a(),o.closePath(),i&&o.rotate(-i),o.translate(-s,-u)},t.prototype._basicDot=function(t){var r=t.size,e=t.context;this._rotateFigure(d(d({},t),{draw:function(){e.arc(0,0,r/2,0,2*Math.PI)}}))},t.prototype._basicSquare=function(t){var r=t.size,e=t.context;this._rotateFigure(d(d({},t),{draw:function(){e.rect(-r/2,-r/2,r,r)}}))},t.prototype._drawDot=function(t){var r=t.x,e=t.y,n=t.size,o=t.context,i=t.rotation;this._basicDot({x:r,y:e,size:n,context:o,rotation:i})},t.prototype._drawSquare=function(t){var r=t.x,e=t.y,n=t.size,o=t.context,i=t.rotation;this._basicSquare({x:r,y:e,size:n,context:o,rotation:i})},t}();var g=[[1,1,1,1,1,1,1],[1,0,0,0,0,0,1],[1,0,0,0,0,0,1],[1,0,0,0,0,0,1],[1,0,0,0,0,0,1],[1,0,0,0,0,0,1],[1,1,1,1,1,1,1]],p=[[0,0,0,0,0,0,0],[0,0,0,0,0,0,0],[0,0,1,1,1,0,0],[0,0,1,1,1,0,0],[0,0,1,1,1,0,0],[0,0,0,0,0,0,0],[0,0,0,0,0,0,0]];const v=function(){function t(t){this._canvas=document.createElement("canvas"),this._canvas.width=t.width,this._canvas.height=t.height,this._options=t}return Object.defineProperty(t.prototype,"context",{get:function(){return this._canvas.getContext("2d")},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"width",{get:function(){return this._canvas.width},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"height",{get:function(){return this._canvas.height},enumerable:!1,configurable:!0}),t.prototype.getCanvas=function(){return this._canvas},t.prototype.clear=function(){var t=this.context;t&&t.clearRect(0,0,this._canvas.width,this._canvas.height)},t.prototype.drawQR=function(t){return r=this,e=void 0,o=function(){var r,e,n,o,i,a,u,c,h,f=this;return function(t,r){var e,n,o,i,a={label:0,sent:function(){if(1&o[0])throw o[1];return o[1]},trys:[],ops:[]};return i={next:s(0),throw:s(1),return:s(2)},"function"==typeof Symbol&&(i[Symbol.iterator]=function(){return this}),i;function s(i){return function(s){return function(i){if(e)throw new TypeError("Generator is already executing.");for(;a;)try{if(e=1,n&&(o=2&i[0]?n.return:i[0]?n.throw||((o=n.return)&&o.call(n),0):n.next)&&!(o=o.call(n,i[1])).done)return o;switch(n=0,o&&(i=[2&i[0],o.value]),i[0]){case 0:case 1:o=i;break;case 4:return a.label++,{value:i[1],done:!1};case 5:a.label++,n=i[1],i=[0];continue;case 7:i=a.ops.pop(),a.trys.pop();continue;default:if(!((o=(o=a.trys).length>0&&o[o.length-1])||6!==i[0]&&2!==i[0])){a=0;continue}if(3===i[0]&&(!o||i[1]>o[0]&&i[1]<o[3])){a.label=i[1];break}if(6===i[0]&&a.label<o[1]){a.label=o[1],o=i;break}if(o&&a.label<o[2]){a.label=o[2],a.ops.push(i);break}o[2]&&a.ops.pop(),a.trys.pop();continue}i=r.call(t,a)}catch(t){i=[6,t],n=0}finally{e=o=0}if(5&i[0])throw i[1];return{value:i[0]?i[1]:void 0,done:!0}}([i,s])}}}(this,(function(d){switch(d.label){case 0:return r=t.getModuleCount(),e=Math.min(this._options.width,this._options.height),n=Math.floor(e/r),o={hideXDots:0,hideYDots:0,width:0,height:0},this._qr=t,this._options.image?[4,this.loadImage()]:[3,2];case 1:if(d.sent(),!this._image)return[2];i=this._options,a=i.imageOptions,u=i.qrOptions,c=a.imageSize*s[u.errorCorrectionLevel],h=Math.floor(c*r*r),o=function(t){var r=t.originalHeight,e=t.originalWidth,n=t.maxHiddenDots,o=t.maxHiddenAxisDots,i=t.dotSize,a={x:0,y:0},s={x:0,y:0};if(r<=0||e<=0||n<=0||i<=0)return{height:0,width:0,hideYDots:0,hideXDots:0};var u=r/e;return a.x=Math.floor(Math.sqrt(n/u)),a.x<=0&&(a.x=1),o&&o<a.x&&(a.x=o),a.x%2==0&&a.x--,s.x=a.x*i,a.y=1+2*Math.ceil((a.x*u-1)/2),s.y=Math.round(s.x*u),(a.y*a.x>n||o&&o<a.y)&&(o&&o<a.y?(a.y=o,a.y%2==0&&a.x--):a.y-=2,s.y=a.y*i,a.x=1+2*Math.ceil((a.y/u-1)/2),s.x=Math.round(s.y/u)),{height:s.y,width:s.x,hideYDots:a.y,hideXDots:a.x}}({originalWidth:this._image.width,originalHeight:this._image.height,maxHiddenDots:h,maxHiddenAxisDots:r-14,dotSize:n}),d.label=2;case 2:return this.clear(),this.drawBackground(),this.drawDots((function(t,e){var n,i,a,s,u,c;return!(f._options.imageOptions.hideBackgroundDots&&t>=(r-o.hideXDots)/2&&t<(r+o.hideXDots)/2&&e>=(r-o.hideYDots)/2&&e<(r+o.hideYDots)/2||(null===(n=g[t])||void 0===n?void 0:n[e])||(null===(i=g[t-r+7])||void 0===i?void 0:i[e])||(null===(a=g[t])||void 0===a?void 0:a[e-r+7])||(null===(s=p[t])||void 0===s?void 0:s[e])||(null===(u=p[t-r+7])||void 0===u?void 0:u[e])||(null===(c=p[t])||void 0===c?void 0:c[e-r+7]))})),this.drawCorners(),this._options.image&&this.drawImage({width:o.width,height:o.height,count:r,dotSize:n}),[2]}}))},new((n=void 0)||(n=Promise))((function(t,i){function a(t){try{u(o.next(t))}catch(t){i(t)}}function s(t){try{u(o.throw(t))}catch(t){i(t)}}function u(r){var e;r.done?t(r.value):(e=r.value,e instanceof n?e:new n((function(t){t(e)}))).then(a,s)}u((o=o.apply(r,e||[])).next())}));var r,e,n,o},t.prototype.drawBackground=function(){var t=this.context,r=this._options;if(t){if(r.backgroundOptions.gradient){var e=r.backgroundOptions.gradient,n=this._createGradient({context:t,options:e,additionalRotation:0,x:0,y:0,size:this._canvas.width>this._canvas.height?this._canvas.width:this._canvas.height});e.colorStops.forEach((function(t){var r=t.offset,e=t.color;n.addColorStop(r,e)})),t.fillStyle=n}else r.backgroundOptions.color&&(t.fillStyle=r.backgroundOptions.color);t.fillRect(0,0,this._canvas.width,this._canvas.height)}},t.prototype.drawDots=function(t){var r=this;if(!this._qr)throw"QR code is not defined";var e=this.context;if(!e)throw"QR code is not defined";var n=this._options,o=this._qr.getModuleCount();if(o>n.width||o>n.height)throw"The canvas is too small.";var i=Math.min(n.width,n.height),a=Math.floor(i/o),s=Math.floor((n.width-o*a)/2),u=Math.floor((n.height-o*a)/2),h=new c({context:e,type:n.dotsOptions.type});e.beginPath();for(var f=function(e){for(var n=function(n){return t&&!t(e,n)?"continue":d._qr.isDark(e,n)?void h.draw(s+e*a,u+n*a,a,(function(i,a){return!(e+i<0||n+a<0||e+i>=o||n+a>=o)&&!(t&&!t(e+i,n+a))&&!!r._qr&&r._qr.isDark(e+i,n+a)})):"continue"},i=0;i<o;i++)n(i)},d=this,l=0;l<o;l++)f(l);if(n.dotsOptions.gradient){var g=n.dotsOptions.gradient,p=this._createGradient({context:e,options:g,additionalRotation:0,x:s,y:u,size:o*a});g.colorStops.forEach((function(t){var r=t.offset,e=t.color;p.addColorStop(r,e)})),e.fillStyle=e.strokeStyle=p}else n.dotsOptions.color&&(e.fillStyle=e.strokeStyle=n.dotsOptions.color);e.fill("evenodd")},t.prototype.drawCorners=function(t){var r=this;if(!this._qr)throw"QR code is not defined";var e=this.context;if(!e)throw"QR code is not defined";var n=this._options,o=this._qr.getModuleCount(),i=Math.min(n.width,n.height),a=Math.floor(i/o),s=7*a,u=3*a,h=Math.floor((n.width-o*a)/2),d=Math.floor((n.height-o*a)/2);[[0,0,0],[1,0,Math.PI/2],[0,1,-Math.PI/2]].forEach((function(i){var v,y,w,x,b,_,M,m,S,O,C=i[0],k=i[1],P=i[2];if(!t||t(C,k)){var D=h+C*a*(o-7),I=d+k*a*(o-7);if(null===(v=n.cornersSquareOptions)||void 0===v?void 0:v.type){var z=new f({context:e,type:null===(y=n.cornersSquareOptions)||void 0===y?void 0:y.type});e.beginPath(),z.draw(D,I,s,P)}else{var B=new c({context:e,type:n.dotsOptions.type});e.beginPath();for(var A=function(t){for(var r=function(r){if(!(null===(w=g[t])||void 0===w?void 0:w[r]))return"continue";B.draw(D+t*a,I+r*a,a,(function(e,n){var o;return!!(null===(o=g[t+e])||void 0===o?void 0:o[r+n])}))},e=0;e<g[t].length;e++)r(e)},q=0;q<g.length;q++)A(q)}if(null===(x=n.cornersSquareOptions)||void 0===x?void 0:x.gradient){var R=n.cornersSquareOptions.gradient,L=r._createGradient({context:e,options:R,additionalRotation:P,x:D,y:I,size:s});R.colorStops.forEach((function(t){var r=t.offset,e=t.color;L.addColorStop(r,e)})),e.fillStyle=e.strokeStyle=L}else(null===(b=n.cornersSquareOptions)||void 0===b?void 0:b.color)&&(e.fillStyle=e.strokeStyle=n.cornersSquareOptions.color);if(e.fill("evenodd"),null===(_=n.cornersDotOptions)||void 0===_?void 0:_.type){var T=new l({context:e,type:null===(M=n.cornersDotOptions)||void 0===M?void 0:M.type});e.beginPath(),T.draw(D+2*a,I+2*a,u,P)}else{B=new c({context:e,type:n.dotsOptions.type}),e.beginPath();var j=function(t){for(var r=function(r){if(!(null===(m=p[t])||void 0===m?void 0:m[r]))return"continue";B.draw(D+t*a,I+r*a,a,(function(e,n){var o;return!!(null===(o=p[t+e])||void 0===o?void 0:o[r+n])}))},e=0;e<p[t].length;e++)r(e)};for(q=0;q<p.length;q++)j(q)}if(null===(S=n.cornersDotOptions)||void 0===S?void 0:S.gradient){R=n.cornersDotOptions.gradient;var E=r._createGradient({context:e,options:R,additionalRotation:P,x:D+2*a,y:I+2*a,size:u});R.colorStops.forEach((function(t){var r=t.offset,e=t.color;E.addColorStop(r,e)})),e.fillStyle=e.strokeStyle=E}else(null===(O=n.cornersDotOptions)||void 0===O?void 0:O.color)&&(e.fillStyle=e.strokeStyle=n.cornersDotOptions.color);e.fill("evenodd")}}))},t.prototype.loadImage=function(){var t=this;return new Promise((function(r,e){var n=t._options,o=new Image;if(!n.image)return e("Image is not defined");"string"==typeof n.imageOptions.crossOrigin&&(o.crossOrigin=n.imageOptions.crossOrigin),t._image=o,o.onload=function(){r()},o.src=n.image}))},t.prototype.drawImage=function(t){var r=t.width,e=t.height,n=t.count,o=t.dotSize,i=this.context;if(!i)throw"canvasContext is not defined";if(!this._image)throw"image is not defined";var a=this._options,s=Math.floor((a.width-n*o)/2),u=Math.floor((a.height-n*o)/2),c=s+a.imageOptions.margin+(n*o-r)/2,h=u+a.imageOptions.margin+(n*o-e)/2,f=r-2*a.imageOptions.margin,d=e-2*a.imageOptions.margin;i.drawImage(this._image,c,h,f<0?0:f,d<0?0:d)},t.prototype._createGradient=function(t){var r,e=t.context,n=t.options,o=t.additionalRotation,i=t.x,a=t.y,s=t.size;if("radial"===n.type)r=e.createRadialGradient(i+s/2,a+s/2,0,i+s/2,a+s/2,s/2);else{var u=((n.rotation||0)+o)%(2*Math.PI),c=(u+2*Math.PI)%(2*Math.PI),h=i+s/2,f=a+s/2,d=i+s/2,l=a+s/2;c>=0&&c<=.25*Math.PI||c>1.75*Math.PI&&c<=2*Math.PI?(h-=s/2,f-=s/2*Math.tan(u),d+=s/2,l+=s/2*Math.tan(u)):c>.25*Math.PI&&c<=.75*Math.PI?(f-=s/2,h-=s/2/Math.tan(u),l+=s/2,d+=s/2/Math.tan(u)):c>.75*Math.PI&&c<=1.25*Math.PI?(h+=s/2,f+=s/2*Math.tan(u),d-=s/2,l-=s/2*Math.tan(u)):c>1.25*Math.PI&&c<=1.75*Math.PI&&(f+=s/2,h+=s/2/Math.tan(u),l-=s/2,d-=s/2/Math.tan(u)),r=e.createLinearGradient(Math.round(h),Math.round(f),Math.round(d),Math.round(l))}return r},t}();for(var y={},w=0;w<=40;w++)y[w]=w;const x={width:300,height:300,data:"",qrOptions:{typeNumber:y[0],mode:void 0,errorCorrectionLevel:"Q"},imageOptions:{hideBackgroundDots:!0,imageSize:.4,crossOrigin:void 0,margin:0},dotsOptions:{type:"square",color:"#000"},backgroundOptions:{color:"#fff"}};var b=function(){return(b=Object.assign||function(t){for(var r,e=1,n=arguments.length;e<n;e++)for(var o in r=arguments[e])Object.prototype.hasOwnProperty.call(r,o)&&(t[o]=r[o]);return t}).apply(this,arguments)};function _(t){var r=b({},t);if(!r.colorStops||!r.colorStops.length)throw"Field 'colorStops' is required in gradient";return r.rotation?r.rotation=Number(r.rotation):r.rotation=0,r.colorStops=r.colorStops.map((function(t){return b(b({},t),{offset:Number(t.offset)})})),r}function M(t){var r=b({},t);return r.width=Number(r.width),r.height=Number(r.height),r.imageOptions=b(b({},r.imageOptions),{hideBackgroundDots:Boolean(r.imageOptions.hideBackgroundDots),imageSize:Number(r.imageOptions.imageSize),margin:Number(r.imageOptions.margin)}),r.dotsOptions=b({},r.dotsOptions),r.dotsOptions.gradient&&(r.dotsOptions.gradient=_(r.dotsOptions.gradient)),r.cornersSquareOptions&&(r.cornersSquareOptions=b({},r.cornersSquareOptions),r.cornersSquareOptions.gradient&&(r.cornersSquareOptions.gradient=_(r.cornersSquareOptions.gradient))),r.cornersDotOptions&&(r.cornersDotOptions=b({},r.cornersDotOptions),r.cornersDotOptions.gradient&&(r.cornersDotOptions.gradient=_(r.cornersDotOptions.gradient))),r.backgroundOptions&&(r.backgroundOptions=b({},r.backgroundOptions),r.backgroundOptions.gradient&&(r.backgroundOptions.gradient=_(r.backgroundOptions.gradient))),r}var m=e(192),S=e.n(m);const O=function(){function t(t){this._options=t?M(a(x,t)):x,this.update()}return t._clearContainer=function(t){t&&(t.innerHTML="")},t.prototype.update=function(r){t._clearContainer(this._container),this._options=r?M(a(this._options,r)):this._options,this._options.data&&(this._qr=S()(this._options.qrOptions.typeNumber,this._options.qrOptions.errorCorrectionLevel),this._qr.addData(this._options.data,this._options.qrOptions.mode||function(t){switch(!0){case/^[0-9]*$/.test(t):return"Numeric";case/^[0-9A-Z $%*+\-./:]*$/.test(t):return"Alphanumeric";default:return"Byte"}}(this._options.data)),this._qr.make(),this._canvas=new v(this._options),this._drawingPromise=this._canvas.drawQR(this._qr),this.append(this._container))},t.prototype.append=function(t){if(t){if("function"!=typeof t.appendChild)throw"Container should be a single DOM node";this._canvas&&t.appendChild(this._canvas.getCanvas()),this._container=t}},t.prototype.download=function(t){var r=this;this._drawingPromise&&this._drawingPromise.then((function(){if(r._canvas){var e="png",n="qr";"string"==typeof t?(e=t,console.warn("Extension is deprecated as argument for 'download' method, please pass object { name: '...', extension: '...' } as argument")):"object"==typeof t&&null!==t&&(t.name&&(n=t.name),t.extension&&(e=t.extension)),function(t,r){var e=document.createElement("a");e.download=r,e.href=t,document.body.appendChild(e),e.click(),document.body.removeChild(e)}(r._canvas.getCanvas().toDataURL("image/"+e),n+"."+e)}}))},t}()}},r={};function e(n){if(r[n])return r[n].exports;var o=r[n]={exports:{}};return t[n](o,o.exports,e),o.exports}return e.n=t=>{var r=t&&t.__esModule?()=>t.default:()=>t;return e.d(r,{a:r}),r},e.d=(t,r)=>{for(var n in r)e.o(r,n)&&!e.o(t,n)&&Object.defineProperty(t,n,{enumerable:!0,get:r[n]})},e.o=(t,r)=>Object.prototype.hasOwnProperty.call(t,r),e(669)})().default}));