{ *********************************************************************************** }
{ *                              CryptoLib Library                                  * }
{ *                Copyright (c) 2018 - 20XX Ugochukwu Mmaduekwe                    * }
{ *                 Github Repository <https://github.com/Xor-el>                   * }

{ *  Distributed under the MIT software license, see the accompanying file LICENSE  * }
{ *          or visit http://www.opensource.org/licenses/mit-license.php.           * }

{ *                              Acknowledgements:                                  * }
{ *                                                                                 * }
{ *      Thanks to Sphere 10 Software (http://www.sphere10.com/) for sponsoring     * }
{ *                           development of this library                           * }

{ * ******************************************************************************* * }

(* &&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&& *)

unit ClpIBlockCipherModes;

{$I ..\Include\CryptoLib.inc}

interface

uses
  ClpIBlockCipher,
  ClpIBufferedBlockCipher,
  ClpCryptoLibTypes;

type
  ICbcBlockCipher = interface(IBlockCipher)

    ['{A95FD7C2-02FE-4600-B496-B7A757737BFF}']

    /// <summary>
    /// return the underlying block cipher that we are wrapping.
    /// </summary>
    /// <returns>
    /// return the underlying block cipher that we are wrapping.
    /// </returns>
    function GetUnderlyingCipher(): IBlockCipher;

  end;

type
  ICfbBlockCipher = interface(IBlockCipher)

    ['{A58FD8F1-EECF-402F-9007-4E884FF7D325}']

    /// <summary>
    /// return the underlying block cipher that we are wrapping.
    /// </summary>
    /// <returns>
    /// return the underlying block cipher that we are wrapping.
    /// </returns>
    function GetUnderlyingCipher(): IBlockCipher;

  end;

type
  IOfbBlockCipher = interface(IBlockCipher)

    ['{17D4977F-C9D8-466D-8E46-7E23A03471FC}']

    /// <summary>
    /// return the underlying block cipher that we are wrapping.
    /// </summary>
    /// <returns>
    /// return the underlying block cipher that we are wrapping.
    /// </returns>
    function GetUnderlyingCipher(): IBlockCipher;

  end;

type
  ISicBlockCipher = interface(IBlockCipher)

    ['{85CC4B84-8E49-40E1-B2F9-6C271C1FB5E7}']

    /// <summary>
    /// return the underlying block cipher that we are wrapping.
    /// </summary>
    /// <returns>
    /// return the underlying block cipher that we are wrapping.
    /// </returns>
    function GetUnderlyingCipher(): IBlockCipher;

  end;

type
  ICtsBlockCipher = interface(IBufferedBlockCipher)

    ['{4D02FD0B-47D6-4914-B31F-5869FF364558}']

  end;

implementation

end.
