{ *********************************************************************************** }
{ *                              CryptoLib Library                                  * }
{ *                Copyright (c) 2018 - 20XX Ugochukwu Mmaduekwe                    * }
{ *                 Github Repository <https://github.com/Xor-el>                   * }

{ *  Distributed under the MIT software license, see the accompanying file LICENSE  * }
{ *          or visit http://www.opensource.org/licenses/mit-license.php.           * }

{ *                              Acknowledgements:                                  * }
{ *                                                                                 * }
{ *      Thanks to Sphere 10 Software (http://www.sphere10.com/) for sponsoring     * }
{ *                           development of this library                           * }

{ * ******************************************************************************* * }

(* &&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&& *)

unit AESTestVectors;

interface

{$IFDEF FPC}
{$MODE DELPHI}
{$ENDIF FPC}

uses
  ClpCryptoLibTypes;

type

  TAESTestVectors = class sealed(TObject)

  public
    class var

      FBlockCipherVectorKeys, FBlockCipherVectorInputs,
      FBlockCipherVectorOutputs, FBlockCipherMonteCarloIterations,
      FBlockCipherMonteCarloKeys, FBlockCipherMonteCarloInputs,
      FBlockCipherMonteCarloOutputs, FOfficialVectorKeys_AES_CBC,
      FOfficialVectorIVs_AES_CBC, FOfficialVectorInputs_AES_CBC,
      FOfficialVectorOutputs_AES_CBC, FOfficialVectorKeys_AES_CFB,
      FOfficialVectorIVs_AES_CFB, FOfficialVectorInputs_AES_CFB,
      FOfficialVectorOutputs_AES_CFB, FOfficialVectorKeys_AES_CTR,
      FOfficialVectorIVs_AES_CTR, FOfficialVectorInputs_AES_CTR,
      FOfficialVectorOutputs_AES_CTR, FOfficialVectorKeys_AES_ECB,
      FOfficialVectorInputs_AES_ECB, FOfficialVectorOutputs_AES_ECB,
      FOfficialVectorKeys_AES_OFB, FOfficialVectorIVs_AES_OFB,
      FOfficialVectorInputs_AES_OFB, FOfficialVectorOutputs_AES_OFB
      : TCryptoLibStringArray;

    class constructor AESTestVectors();

  end;

implementation

{ TAESTestVectors }

class constructor TAESTestVectors.AESTestVectors;
begin

  // Test vectors from the NIST standard tests and Brian Gladman's
  // vector set
  // http://fp.gladman.plus.com/cryptography_technology/rijndael
  FBlockCipherVectorKeys := TCryptoLibStringArray.Create

    (
    // keylength 128 bits
    '80000000000000000000000000000000', '00000000000000000000000000000080',
    // keylength 192 bits
    '000000000000000000000000000000000000000000000000',
    // keylength 256 bits
    '0000000000000000000000000000000000000000000000000000000000000000');

  FBlockCipherVectorInputs := TCryptoLibStringArray.Create
    ('00000000000000000000000000000000', '00000000000000000000000000000000',

    '80000000000000000000000000000000',

    '80000000000000000000000000000000');

  FBlockCipherVectorOutputs := TCryptoLibStringArray.Create
    ('0EDD33D3C621E546455BD8BA1418BEC8', '172AEAB3D507678ECAF455C12587ADB7',

    '6CD02513E8D4DC986B4AFE087A60BD0C',

    'DDC6BF790C15760D8D9AEB6F9A75FD4E');

  FBlockCipherMonteCarloIterations := TCryptoLibStringArray.Create('10000',
    '10000', '10000', '10000', '10000', '10000', '10000', '10000', '10000',
    '10000', '10000', '10000');

  FBlockCipherMonteCarloKeys := TCryptoLibStringArray.Create
    ('00000000000000000000000000000000', '5F060D3716B345C253F6749ABAC10917',
    'AAFE47EE82411A2BF3F6752AE8D7831138F041560631B114',
    '28E79E2AFC5F7745FCCABE2F6257C2EF4C4EDFB37324814ED4137C288711A386',
    '00000000000000000000000000000000', '5F060D3716B345C253F6749ABAC10917',
    'AAFE47EE82411A2BF3F6752AE8D7831138F041560631B114',
    '28E79E2AFC5F7745FCCABE2F6257C2EF4C4EDFB37324814ED4137C288711A386',
    '00000000000000000000000000000000', '5F060D3716B345C253F6749ABAC10917',
    'AAFE47EE82411A2BF3F6752AE8D7831138F041560631B114',
    '28E79E2AFC5F7745FCCABE2F6257C2EF4C4EDFB37324814ED4137C288711A386');

  FBlockCipherMonteCarloInputs := TCryptoLibStringArray.Create
    ('00000000000000000000000000000000', '355F697E8B868B65B25A04E18D782AFA',
    'F3F6752AE8D7831138F041560631B114', 'C737317FE0846F132B23C8C2A672CE22',
    '00000000000000000000000000000000', '355F697E8B868B65B25A04E18D782AFA',
    'F3F6752AE8D7831138F041560631B114', 'C737317FE0846F132B23C8C2A672CE22',
    '00000000000000000000000000000000', '355F697E8B868B65B25A04E18D782AFA',
    'F3F6752AE8D7831138F041560631B114', 'C737317FE0846F132B23C8C2A672CE22');

  FBlockCipherMonteCarloOutputs := TCryptoLibStringArray.Create
    ('C34C052CC0DA8D73451AFE5F03BE297F', 'ACC863637868E3E068D2FD6E3508454A',
    '77BA00ED5412DFF27C8ED91F3C376172', 'E58B82BFBA53C0040DC610C642121168',
    'C34C052CC0DA8D73451AFE5F03BE297F', 'ACC863637868E3E068D2FD6E3508454A',
    '77BA00ED5412DFF27C8ED91F3C376172', 'E58B82BFBA53C0040DC610C642121168',
    'C34C052CC0DA8D73451AFE5F03BE297F', 'ACC863637868E3E068D2FD6E3508454A',
    '77BA00ED5412DFF27C8ED91F3C376172', 'E58B82BFBA53C0040DC610C642121168');

  // test vectors gotten from here
  // https://github.com/ircmaxell/quality-checker/blob/master/tmp/gh_18/PHP-PasswordLib-master/test/Data/Vectors/aes-cbc.test-vectors

  // CBC

  FOfficialVectorKeys_AES_CBC := TCryptoLibStringArray.Create(
    // 128
    '2B7E151628AED2A6ABF7158809CF4F3C', '2B7E151628AED2A6ABF7158809CF4F3C',
    '2B7E151628AED2A6ABF7158809CF4F3C', '2B7E151628AED2A6ABF7158809CF4F3C',
    // 192
    '8E73B0F7DA0E6452C810F32B809079E562F8EAD2522C6B7B',
    '8E73B0F7DA0E6452C810F32B809079E562F8EAD2522C6B7B',
    '8E73B0F7DA0E6452C810F32B809079E562F8EAD2522C6B7B',
    '8E73B0F7DA0E6452C810F32B809079E562F8EAD2522C6B7B',
    // 256
    '603DEB1015CA71BE2B73AEF0857D77811F352C073B6108D72D9810A30914DFF4',
    '603DEB1015CA71BE2B73AEF0857D77811F352C073B6108D72D9810A30914DFF4',
    '603DEB1015CA71BE2B73AEF0857D77811F352C073B6108D72D9810A30914DFF4',
    '603DEB1015CA71BE2B73AEF0857D77811F352C073B6108D72D9810A30914DFF4');

  FOfficialVectorIVs_AES_CBC := TCryptoLibStringArray.Create(
    // 128
    '000102030405060708090A0B0C0D0E0F', '7649ABAC8119B246CEE98E9B12E9197D',
    '5086CB9B507219EE95DB113A917678B2', '73BED6B8E3C1743B7116E69E22229516',
    // 192
    '000102030405060708090A0B0C0D0E0F', '4F021DB243BC633D7178183A9FA071E8',
    'B4D9ADA9AD7DEDF4E5E738763F69145A', '571B242012FB7AE07FA9BAAC3DF102E0',
    // 256
    '000102030405060708090A0B0C0D0E0F', 'F58C4C04D6E5F1BA779EABFB5F7BFBD6',
    '9CFC4E967EDB808D679F777BC6702C7D', '39F23369A9D9BACFA530E26304231461');

  FOfficialVectorInputs_AES_CBC := TCryptoLibStringArray.Create(
    // 128
    '6BC1BEE22E409F96E93D7E117393172A', 'AE2D8A571E03AC9C9EB76FAC45AF8E51',
    '30C81C46A35CE411E5FBC1191A0A52EF', 'F69F2445DF4F9B17AD2B417BE66C3710',
    // 192
    '6BC1BEE22E409F96E93D7E117393172A', 'AE2D8A571E03AC9C9EB76FAC45AF8E51',
    '30C81C46A35CE411E5FBC1191A0A52EF', 'F69F2445DF4F9B17AD2B417BE66C3710',
    // 256
    '6BC1BEE22E409F96E93D7E117393172A', 'AE2D8A571E03AC9C9EB76FAC45AF8E51',
    '30C81C46A35CE411E5FBC1191A0A52EF', 'F69F2445DF4F9B17AD2B417BE66C3710');

  FOfficialVectorOutputs_AES_CBC := TCryptoLibStringArray.Create(
    // 128
    '7649ABAC8119B246CEE98E9B12E9197D', '5086CB9B507219EE95DB113A917678B2',
    '73BED6B8E3C1743B7116E69E22229516', '3FF1CAA1681FAC09120ECA307586E1A7',
    // 192
    '4F021DB243BC633D7178183A9FA071E8', 'B4D9ADA9AD7DEDF4E5E738763F69145A',
    '571B242012FB7AE07FA9BAAC3DF102E0', '08B0E27988598881D920A9E64F5615CD',
    // 256
    'F58C4C04D6E5F1BA779EABFB5F7BFBD6', '9CFC4E967EDB808D679F777BC6702C7D',
    '39F23369A9D9BACFA530E26304231461', 'B2EB05E2C39BE9FCDA6C19078C6A9D1B');

  // test vectors gotten from here
  // https://github.com/ircmaxell/quality-checker/blob/master/tmp/gh_18/PHP-PasswordLib-master/test/Data/Vectors/aes-cfb.test-vectors

  // CFB

  FOfficialVectorKeys_AES_CFB := TCryptoLibStringArray.Create(
    // 128
    '2B7E151628AED2A6ABF7158809CF4F3C', '2B7E151628AED2A6ABF7158809CF4F3C',
    '2B7E151628AED2A6ABF7158809CF4F3C', '2B7E151628AED2A6ABF7158809CF4F3C',
    // 192
    '8E73B0F7DA0E6452C810F32B809079E562F8EAD2522C6B7B',
    '8E73B0F7DA0E6452C810F32B809079E562F8EAD2522C6B7B',
    '8E73B0F7DA0E6452C810F32B809079E562F8EAD2522C6B7B',
    '8E73B0F7DA0E6452C810F32B809079E562F8EAD2522C6B7B',
    // 256
    '603DEB1015CA71BE2B73AEF0857D77811F352C073B6108D72D9810A30914DFF4',
    '603DEB1015CA71BE2B73AEF0857D77811F352C073B6108D72D9810A30914DFF4',
    '603DEB1015CA71BE2B73AEF0857D77811F352C073B6108D72D9810A30914DFF4',
    '603DEB1015CA71BE2B73AEF0857D77811F352C073B6108D72D9810A30914DFF4');

  FOfficialVectorIVs_AES_CFB := TCryptoLibStringArray.Create(
    // 128
    '000102030405060708090A0B0C0D0E0F', '3B3FD92EB72DAD20333449F8E83CFB4A',
    'C8A64537A0B3A93FCDE3CDAD9F1CE58B', '26751F67A3CBB140B1808CF187A4F4DF',
    // 192
    '000102030405060708090A0B0C0D0E0F', 'CDC80D6FDDF18CAB34C25909C99A4174',
    '67CE7F7F81173621961A2B70171D3D7A', '2E1E8A1DD59B88B1C8E60FED1EFAC4C9',
    // 256
    '000102030405060708090A0B0C0D0E0F', 'DC7E84BFDA79164B7ECD8486985D3860',
    '39FFED143B28B1C832113C6331E5407B', 'DF10132415E54B92A13ED0A8267AE2F9');

  FOfficialVectorInputs_AES_CFB := TCryptoLibStringArray.Create(
    // 128
    '6BC1BEE22E409F96E93D7E117393172A', 'AE2D8A571E03AC9C9EB76FAC45AF8E51',
    '30C81C46A35CE411E5FBC1191A0A52EF', 'F69F2445DF4F9B17AD2B417BE66C3710',
    // 192
    '6BC1BEE22E409F96E93D7E117393172A', 'AE2D8A571E03AC9C9EB76FAC45AF8E51',
    '30C81C46A35CE411E5FBC1191A0A52EF', 'F69F2445DF4F9B17AD2B417BE66C3710',
    // 256
    '6BC1BEE22E409F96E93D7E117393172A', 'AE2D8A571E03AC9C9EB76FAC45AF8E51',
    '30C81C46A35CE411E5FBC1191A0A52EF', 'F69F2445DF4F9B17AD2B417BE66C3710');

  FOfficialVectorOutputs_AES_CFB := TCryptoLibStringArray.Create(
    // 128
    '3B3FD92EB72DAD20333449F8E83CFB4A', 'C8A64537A0B3A93FCDE3CDAD9F1CE58B',
    '26751F67A3CBB140B1808CF187A4F4DF', 'C04B05357C5D1C0EEAC4C66F9FF7F2E6',
    // 192
    'CDC80D6FDDF18CAB34C25909C99A4174', '67CE7F7F81173621961A2B70171D3D7A',
    '2E1E8A1DD59B88B1C8E60FED1EFAC4C9', 'C05F9F9CA9834FA042AE8FBA584B09FF',
    // 256
    'DC7E84BFDA79164B7ECD8486985D3860', '39FFED143B28B1C832113C6331E5407B',
    'DF10132415E54B92A13ED0A8267AE2F9', '75A385741AB9CEF82031623D55B1E471');


  // test vectors gotten from here
  // https://nvlpubs.nist.gov/nistpubs/Legacy/SP/nistspecialpublication800-38a.pdf

  // CTR

  FOfficialVectorKeys_AES_CTR := TCryptoLibStringArray.Create(
    // 128
    '2B7E151628AED2A6ABF7158809CF4F3C', '2B7E151628AED2A6ABF7158809CF4F3C',
    '2B7E151628AED2A6ABF7158809CF4F3C', '2B7E151628AED2A6ABF7158809CF4F3C',
    // 192
    '8E73B0F7DA0E6452C810F32B809079E562F8EAD2522C6B7B',
    '8E73B0F7DA0E6452C810F32B809079E562F8EAD2522C6B7B',
    '8E73B0F7DA0E6452C810F32B809079E562F8EAD2522C6B7B',
    '8E73B0F7DA0E6452C810F32B809079E562F8EAD2522C6B7B',
    // 256
    '603DEB1015CA71BE2B73AEF0857D77811F352C073B6108D72D9810A30914DFF4',
    '603DEB1015CA71BE2B73AEF0857D77811F352C073B6108D72D9810A30914DFF4',
    '603DEB1015CA71BE2B73AEF0857D77811F352C073B6108D72D9810A30914DFF4',
    '603DEB1015CA71BE2B73AEF0857D77811F352C073B6108D72D9810A30914DFF4');

  FOfficialVectorIVs_AES_CTR := TCryptoLibStringArray.Create(
    // 128
    'F0F1F2F3F4F5F6F7F8F9FAFBFCFDFEFF', 'F0F1F2F3F4F5F6F7F8F9FAFBFCFDFF00',
    'F0F1F2F3F4F5F6F7F8F9FAFBFCFDFF01', 'F0F1F2F3F4F5F6F7F8F9FAFBFCFDFF02',
    // 192
    'F0F1F2F3F4F5F6F7F8F9FAFBFCFDFEFF', 'F0F1F2F3F4F5F6F7F8F9FAFBFCFDFF00',
    'F0F1F2F3F4F5F6F7F8F9FAFBFCFDFF01', 'F0F1F2F3F4F5F6F7F8F9FAFBFCFDFF02',
    // 256
    'F0F1F2F3F4F5F6F7F8F9FAFBFCFDFEFF', 'F0F1F2F3F4F5F6F7F8F9FAFBFCFDFF00',
    'F0F1F2F3F4F5F6F7F8F9FAFBFCFDFF01', 'F0F1F2F3F4F5F6F7F8F9FAFBFCFDFF02');

  FOfficialVectorInputs_AES_CTR := TCryptoLibStringArray.Create(
    // 128
    '6BC1BEE22E409F96E93D7E117393172A', 'AE2D8A571E03AC9C9EB76FAC45AF8E51',
    '30C81C46A35CE411E5FBC1191A0A52EF', 'F69F2445DF4F9B17AD2B417BE66C3710',
    // 192
    '6BC1BEE22E409F96E93D7E117393172A', 'AE2D8A571E03AC9C9EB76FAC45AF8E51',
    '30C81C46A35CE411E5FBC1191A0A52EF', 'F69F2445DF4F9B17AD2B417BE66C3710',
    // 256
    '6BC1BEE22E409F96E93D7E117393172A', 'AE2D8A571E03AC9C9EB76FAC45AF8E51',
    '30C81C46A35CE411E5FBC1191A0A52EF', 'F69F2445DF4F9B17AD2B417BE66C3710');

  FOfficialVectorOutputs_AES_CTR := TCryptoLibStringArray.Create(
    // 128
    '874D6191B620E3261BEF6864990DB6CE', '9806F66B7970FDFF8617187BB9FFFDFF',
    '5AE4DF3EDBD5D35E5B4F09020DB03EAB', '1E031DDA2FBE03D1792170A0F3009CEE',
    // 192
    '1ABC932417521CA24F2B0459FE7E6E0B', '090339EC0AA6FAEFD5CCC2C6F4CE8E94',
    '1E36B26BD1EBC670D1BD1D665620ABF7', '4F78A7F6D29809585A97DAEC58C6B050',
    // 256
    '601EC313775789A5B7A7F504BBF3D228', 'F443E3CA4D62B59ACA84E990CACAF5C5',
    '2B0930DAA23DE94CE87017BA2D84988D', 'DFC9C58DB67AADA613C2DD08457941A6');


  // test vectors gotten from here
  // https://github.com/ircmaxell/quality-checker/blob/master/tmp/gh_18/PHP-PasswordLib-master/test/Data/Vectors/aes-ecb.test-vectors

  // ECB

  FOfficialVectorKeys_AES_ECB := TCryptoLibStringArray.Create(
    // 128
    '2B7E151628AED2A6ABF7158809CF4F3C', '2B7E151628AED2A6ABF7158809CF4F3C',
    '2B7E151628AED2A6ABF7158809CF4F3C', '2B7E151628AED2A6ABF7158809CF4F3C',
    // 192
    '8E73B0F7DA0E6452C810F32B809079E562F8EAD2522C6B7B',
    '8E73B0F7DA0E6452C810F32B809079E562F8EAD2522C6B7B',
    '8E73B0F7DA0E6452C810F32B809079E562F8EAD2522C6B7B',
    '8E73B0F7DA0E6452C810F32B809079E562F8EAD2522C6B7B',
    // 256
    '603DEB1015CA71BE2B73AEF0857D77811F352C073B6108D72D9810A30914DFF4',
    '603DEB1015CA71BE2B73AEF0857D77811F352C073B6108D72D9810A30914DFF4',
    '603DEB1015CA71BE2B73AEF0857D77811F352C073B6108D72D9810A30914DFF4',
    '603DEB1015CA71BE2B73AEF0857D77811F352C073B6108D72D9810A30914DFF4');

  FOfficialVectorInputs_AES_ECB := TCryptoLibStringArray.Create(
    // 128
    '6BC1BEE22E409F96E93D7E117393172A', 'AE2D8A571E03AC9C9EB76FAC45AF8E51',
    '30C81C46A35CE411E5FBC1191A0A52EF', 'F69F2445DF4F9B17AD2B417BE66C3710',
    // 192
    '6BC1BEE22E409F96E93D7E117393172A', 'AE2D8A571E03AC9C9EB76FAC45AF8E51',
    '30C81C46A35CE411E5FBC1191A0A52EF', 'F69F2445DF4F9B17AD2B417BE66C3710',
    // 256
    '6BC1BEE22E409F96E93D7E117393172A', 'AE2D8A571E03AC9C9EB76FAC45AF8E51',
    '30C81C46A35CE411E5FBC1191A0A52EF', 'F69F2445DF4F9B17AD2B417BE66C3710');

  FOfficialVectorOutputs_AES_ECB := TCryptoLibStringArray.Create(
    // 128
    '3AD77BB40D7A3660A89ECAF32466EF97', 'F5D3D58503B9699DE785895A96FDBAAF',
    '43B1CD7F598ECE23881B00E3ED030688', '7B0C785E27E8AD3F8223207104725DD4',
    // 192
    'BD334F1D6E45F25FF712A214571FA5CC', '974104846D0AD3AD7734ECB3ECEE4EEF',
    'EF7AFD2270E2E60ADCE0BA2FACE6444E', '9A4B41BA738D6C72FB16691603C18E0E',
    // 256
    'F3EED1BDB5D2A03C064B5A7E3DB181F8', '591CCB10D410ED26DC5BA74A31362870',
    'B6ED21B99CA6F4F9F153E7B1BEAFED1D', '23304B7A39F9F3FF067D8D8F9E24ECC7');

  // test vectors gotten from here
  // https://github.com/ircmaxell/quality-checker/blob/master/tmp/gh_18/PHP-PasswordLib-master/test/Data/Vectors/aes-ofb.test-vectors

  // OFB

  FOfficialVectorKeys_AES_OFB := TCryptoLibStringArray.Create(
    // 128
    '2B7E151628AED2A6ABF7158809CF4F3C', '2B7E151628AED2A6ABF7158809CF4F3C',
    '2B7E151628AED2A6ABF7158809CF4F3C', '2B7E151628AED2A6ABF7158809CF4F3C',
    // 192
    '8E73B0F7DA0E6452C810F32B809079E562F8EAD2522C6B7B',
    '8E73B0F7DA0E6452C810F32B809079E562F8EAD2522C6B7B',
    '8E73B0F7DA0E6452C810F32B809079E562F8EAD2522C6B7B',
    '8E73B0F7DA0E6452C810F32B809079E562F8EAD2522C6B7B',
    // 256
    '603DEB1015CA71BE2B73AEF0857D77811F352C073B6108D72D9810A30914DFF4',
    '603DEB1015CA71BE2B73AEF0857D77811F352C073B6108D72D9810A30914DFF4',
    '603DEB1015CA71BE2B73AEF0857D77811F352C073B6108D72D9810A30914DFF4',
    '603DEB1015CA71BE2B73AEF0857D77811F352C073B6108D72D9810A30914DFF4');

  FOfficialVectorIVs_AES_OFB := TCryptoLibStringArray.Create(
    // 128
    '000102030405060708090A0B0C0D0E0F', '50FE67CC996D32B6DA0937E99BAFEC60',
    'D9A4DADA0892239F6B8B3D7680E15674', 'A78819583F0308E7A6BF36B1386ABF23',
    // 192
    '000102030405060708090A0B0C0D0E0F', 'A609B38DF3B1133DDDFF2718BA09565E',
    '52EF01DA52602FE0975F78AC84BF8A50', 'BD5286AC63AABD7EB067AC54B553F71D',
    // 256
    '000102030405060708090A0B0C0D0E0F', 'B7BF3A5DF43989DD97F0FA97EBCE2F4A',
    'E1C656305ED1A7A6563805746FE03EDC', '41635BE625B48AFC1666DD42A09D96E7');

  FOfficialVectorInputs_AES_OFB := TCryptoLibStringArray.Create(
    // 128
    '6BC1BEE22E409F96E93D7E117393172A', 'AE2D8A571E03AC9C9EB76FAC45AF8E51',
    '30C81C46A35CE411E5FBC1191A0A52EF', 'F69F2445DF4F9B17AD2B417BE66C3710',
    // 192
    '6BC1BEE22E409F96E93D7E117393172A', 'AE2D8A571E03AC9C9EB76FAC45AF8E51',
    '30C81C46A35CE411E5FBC1191A0A52EF', 'F69F2445DF4F9B17AD2B417BE66C3710',
    // 256
    '6BC1BEE22E409F96E93D7E117393172A', 'AE2D8A571E03AC9C9EB76FAC45AF8E51',
    '30C81C46A35CE411E5FBC1191A0A52EF', 'F69F2445DF4F9B17AD2B417BE66C3710');

  FOfficialVectorOutputs_AES_OFB := TCryptoLibStringArray.Create(
    // 128
    '3B3FD92EB72DAD20333449F8E83CFB4A', '7789508D16918F03F53C52DAC54ED825',
    '9740051E9C5FECF64344F7A82260EDCC', '304C6528F659C77866A510D9C1D6AE5E',
    // 192
    'CDC80D6FDDF18CAB34C25909C99A4174', 'FCC28B8D4C63837C09E81700C1100401',
    '8D9A9AEAC0F6596F559C6D4DAF59A5F2', '6D9F200857CA6C3E9CAC524BD9ACC92A',
    // 256
    'DC7E84BFDA79164B7ECD8486985D3860', '4FEBDC6740D20B3AC88F6AD82A4FB08D',
    '71AB47A086E86EEDF39D1C5BBA97C408', '0126141D67F37BE8538F5A8BE740E484');

end;

end.
