[返回目录](/docs/README-zh-CN.md) / [English](./Vulnerability_Analysis.md)

- [连接到漏洞数据库](#连接到漏洞数据库)
- [分析漏洞](#分析漏洞)
  - [使用 OpenSCA SaaS 漏洞库](#使用-opensca-saas-漏洞库)
    - [基本命令](#基本命令)
    - [示例](#示例)
  - [使用 OpenSCA 本地漏洞库](#使用-opensca-本地漏洞库)
  - [使用 json 文件](#使用-json-文件)
  - [使用 MySQL 数据库](#使用-mysql-数据库)
  - [使用 SQLite 数据库](#使用-sqlite-数据库)

# 连接到漏洞数据库

OpenSCA 支持通过连接到漏洞数据库来获取漏洞信息。目前支持的漏洞数据库有：

- 在线
  - [OpenSCA SaaS](https://opensca.xmirror.cn)
- 本地
  - OpenSCA 本地漏洞库
  - json 文件
  - MySQL 数据库
  - SQLite 数据库

关于漏洞数据库的配置，请参考[配置文件说明](../Configuration-and-Parameters-zh_CN.md#漏洞数据库配置示例)。

# 分析漏洞

在扫描时，OpenSCA 会根据配置文件中的漏洞数据库连接信息，自动连接到漏洞数据库，获取漏洞信息。在扫描完成后，OpenSCA 会将扫描结果与漏洞数据库中的漏洞信息进行对比，生成漏洞报告。

## 使用 OpenSCA SaaS 漏洞库

OpenSCA 默认云端漏洞库地址为 `https://opensca.xmirror.cn` ，使用云端漏洞库需要先[注册](https://opensca.xmirror.cn/register)并获取 token


### 基本命令

```shell
opensca-cli -path {项目路径} -token {token} 
```

### 示例

<table>
<tr>
<th align="center">在命令行中传入 token</th>
<th align="center">使用用户名密码登录，自动获取 token(仅本次命令生效)</th>
<th align="center">将 token 写入配置文件</th>
<th align="center">将检测结果同步至 OpenSCA SaaS 进行管理</th>
</tr>
<tr>
<td>

```shell
opensca-cli -path ~/workspace/myproject -token *************
```

</td>
<td>

```shell
opensca-cli -path ~/workspace/myproject -login
# 安装提示输入用户名密码
```

</td>

<td>

编辑配置文件 config.json, 将 token 填入 `origin.token` 从 [这里](https://raw.githubusercontent.com/XmirrorSecurity/OpenSCA-cli/master/config.json) 获取配置文件模板

```json
  // ...
  
  "origin": {

    // opensca web service url
    "url": "https://opensca.xmirror.cn",
    // opensca web service token
    "token": "",

  // ... 
```

执行 opensca-cli 命令时，不再需要传入 token

```shell
opensca-cli -path ~/workspace/myproject -config ~/workspace/myproject/config.json
```

</td>
<td>

使用 OpenSCA SaaS 方便进行项目管理、团队协作、漏洞跟踪等，并获得更详细的漏洞信息、许可证信息以及最新的漏洞情报和修复建议。

* 使用 `-proj` 传入空值，可将结果同步至快速检测(方便个人查看)
  ```shell
  opensca-cli -path ~/workspace/myproject -token ************* -proj ""
  ```
* 使用 `-proj` 传入项目 id， 可将结果同步至项目管理(支持团队协作)
  ```shell
  opensca-cli -path ~/workspace/myproject -token ************* -proj ************
  ```

</td>
</tr>
</table>

## 使用 OpenSCA 本地漏洞库

OpenSCA 本地漏洞库暂未开放，敬请期待

## 使用 json 文件

按照 [漏洞数据库配置示例](../Configuration-and-Parameters-zh_CN.md#漏洞数据库配置示例) 配置好本地数据库后，在配置文件中指定 json 文件作为漏洞数据源：

```json
  // ...
  
  "origin": {

    "json": "/path/to/vulnerability.json"

  // ...
```

使用 OpenSCA-cli 分析漏洞

```shell
opensca-cli -path {项目路径} -config {配置文件路径}
```

## 使用 MySQL 数据库

按照 [漏洞数据库配置示例](../Configuration-and-Parameters-zh_CN.md#漏洞数据库配置示例) 配置好本地数据库后，在配置文件中指定 MySQL 数据库作为漏洞数据源：

```json
  // ...
  
  "origin": {

    "mysql": {
      "dsn": "user:password@tcp(ip:port)/database_name",
      "table": "vulnerability"
    }

  // ...
```

使用 OpenSCA-cli 分析漏洞

```shell
opensca-cli -path {项目路径} -config {配置文件路径}
```

## 使用 SQLite 数据库

按照 [漏洞数据库配置示例](../Configuration-and-Parameters-zh_CN.md#漏洞数据库配置示例) 配置好本地数据库后，在配置文件中指定 SQLite 数据库作为漏洞数据源：

```json
  // ...
  
  "origin": {

    "dsn": "/path/to/vulnerability.db",
    "table": "vulnerability"

  // ...
```

使用 OpenSCA-cli 分析漏洞

```shell
opensca-cli -path {项目路径} -config {配置文件路径}
```
