[中文](./CONTRIBUTING-zh_CN.md) | [English](./CONTRIBUTING.md)

# Contributing Guideline-en

## Contribution Guideline on OpenSCA Project v1.0

OpenSCA project is an open-source tool of software composition analysis originally developed by X-mirror. Situated in the fast-paced rhythm of development and an environment where open-source code and software are widely applied, the security problem of the software supply chain is glaring. To rise to the challenges, our solution is to manage the open-source risks through our open-source project. Everyone is warmly welcomed to be part of our community, constructing the future of OpenSCA project and fulfilling the potential of the open-source solution.

We value all forms of contributions, including but not limited to:

- Reviewing of the existing code
- Documents and examples of deployment
- Participating in the discussion through “Issue” on Github, our Wechat official account, Wechat group as well as QQ group 
- Improving the functionality of the project practically 
- Sharing the experience, offering using tips, and communicating on relevant topics to assist the further development of the project.

To help the one gets interested in contributing to multiple aspects more effectively, we drafted this contribution guideline. It will be updated in accordance with the development of the project. The main parts of this guideline are as follows:

- Code of Conduct and Contributing System
- Report a BUG
- Types of BUG
- Contributing Code
- Code Standard

### Code of Conduct and Contributing System

OpenSCA community aims to create a contributor-friendly atmosphere, where the open and inclusive environment of mutual respect requires our joint effort to build and maintain. The inappropriate behavior would face warnings or even punishments.

#### Code of Conduct

The community cares about the feelings of every member. For the promotion of a favorable atmosphere, please check our [Code of Conduct](https://github.com/XmirrorSecurity/OpenSCA-cli/blob/master/docs/CODE_OF_CONDUCT.md) in advance, and keep it in mind during your participation.

#### Contributing System

The emerging community is now run by OpenSCA project team. As the development of the community, we are expecting more people to make contributions and join our team, maintaining the operation of our community together.

The current contributing system can be roughly divided into two parts: one about code and the other about points. For the code branch, you will become a contributor after contributing code through **Pull Request**s and getting accepted by the team. Then you'll be able to participate in the further plan and implementation for the project, judgment for the BUG, review the PR and verify new contributors.

For the points branch, apart from gaining them through contributing code, it also works to actively get involved in reporting BUG, discussing relevant technology and sharing your experience of using OpenSCA. The points could exchange for gifts. The detailed rules of gaining and exchanging points could differ according to time or diverse activities. Please feel free to throw an email to Opensca@anpro-tech.com for the latest rules. 

### Report a BUG

If you find a BUG while deploying or using OpenSCA, you can report it on "Issue". Should there be any problems with our docs, you can contact us through the aforementioned mailbox.

Before reporting a BUG, it is advised to make sure that the latest version has been deployed. What's more, the BUG might have been reported on "Issue" by the others. If it indeed is a fresh one related to the latest version, you can either report it on "Issue" and wait for other members to deal with it, or make a PR to offer your solution and wait for verification.

*Vulnerabilities are not suitable for open discussion. If you find any security vulnerabilities of OpenSCA, please contact us through the aforementioned mailbox. 

### Types of BUG

Different types of BUG make different influences on the users who use OpenSCA. According to these differences, We classify the BUG into three types:

**Major BUG**: the ones that affect major functionality (the analysis of the components and the identification of vulnerabilities in Java、PHP and other languages )

**Minor BUG**: the ones only cause inconvenience while using without affecting any functionality

**Fake BUG**: the ones which caused by improper operation or using the old version

The major ones call for the top priority and our members will actively follow-up. But you can submit a PR for fixing it if you have any solution. It will be checked by our members. 

We will deal with the minor ones by tweaking parts of the existing code. As for the fake ones, we will reply in "Issue" to help you find the problem so that you can use OpenSCA smoothly.

### Contributing Code

Code contributions are indispensable to the maintaining, improving and extension of OpenSCA. It can be done by submitting PR on Github.

Our team will review your PR, where both fixing a BUG or improving the functionality is welcome. In order to make it more effective, we hope that you can have a look at our code standard before organizing your PR. We advise that make ONE PR for ONE task at once. The readability also matters, so extra pieces of comments will be appreciated.

If your PR is about **fixing a BUG**, based on the code standard, we will mainly focus on the quality of your code while verifying your contribution.

If your PR is about **improving the functionality**, based on the code standard, we will review the code quality, creativity, functionality and algorithm.

We will reach out and invite you to sign our CLA (Contributor License Agreement) after we decide to approve your code. As long as CLA get signed, your code contribution will become part of OpenSCA project, and you will be one of our contributors. Contributors can take part in the further plan and implementation of the project, judgment for the BUG, review the PR and verify new contributors.


---


We appreciate all the contributions to OpenSCA.

Thanks again for your interest in OpenSCA and your support for our solution to open source vulnerabilities.

For the Chinese version of our contributing guideline, please check [贡献指南（中文版）v1.0](./Contributing_Guideline-v1.0-zh_CN.md)。
