# Issues

## Best practices for opening a new issue

   GitHub issues are used for everything from bug reporting to suggesting long-term ideas. Please follow the rules below.

### First and foremost

   The title is the first thing anyone will see, so it should be as meaningful as possible.

### Bug reports

   Before you submit a bug always search the current list of issues to see if it has been reported already.

   Please see [bug_report_template.md](bug_report_template.md) for guidelines.

### New ideas and features

   While the game growing is always wonderful, we should attempt to fully flesh out one or two systems at a time.

   That being said, ideas are always welcome, as this is intended to be a game for anyone and everyone. Please remember to first check if your idea has already been suggested, and after submitting yours make sure to take part in the discussion of your suggestions.

### Questions

   First see if your question is answered within any of this game's documentation, and if not please join us on [Discord](https://discord.gg/6aW7DFB)

## Issue resolution

   People will not be assigned to projects, just comment on the relevant issue if you are tackling it.
