[Setup]
AppName=7-ZIP overlay DLL test
CreateAppDir=no
Uninstallable=no
AppVersion=0.1.2.3
OutputDir=.

[Files]
Source: "7zOverlay.dll"; DestDir: "{tmp}"; Flags: dontcopy
Source: "7z.dll"; DestDir: "{tmp}"; Flags: dontcopy

[Messages]
SetupAppTitle=7-ZIP overlay DLL test

[code]
Function CommandFor7ZIP(const args: PAnsiChar; var Output, Errors: PAnsiChar): Integer;
  External 'CommandFor7ZIP@files:7zOverlay.dll stdcall';

Function InitializeSetup(): Boolean;
  var
    DllResult: Integer;
    Output, Errors: PAnsiChar;
    OutputHelp, HelpErrors, OutputInfo, InfoErrors: String;
    ErrorsStringsArray: Array of String;
    DllReturnMSG: String;
  begin
    result := False;
    ExtractTemporaryFile( '7z.dll' );
    DllResult := CommandFor7ZIP('-h', Output, Errors);
    OutputHelp := Output;
    HelpErrors := Errors;
    DllResult := CommandFor7ZIP('i', Output, Errors);
    OutputInfo := Output;
    InfoErrors := Errors;
    ErrorsStringsArray := [
      'Successful operation',                           // kSuccess       = 0
      'Non fatal error(s) occurred',                    // kWarning       = 1
      'A fatal error occurred',                         // kFatalError    = 2
      'A CRC error occurred when unpacking',            // kCRCError      = 3
      'Attempt to modify an archive previously locked', // kLockedArchive = 4
      'Write to disk error',                            // kWriteError    = 5
      'Open file error',                                // kOpenError     = 6
      'Command line option error',                      // kUserError     = 7
      'Not enough memory for operation',                // kMemoryError   = 8
      'Create file error'                               // kCreateFileError = 9
      ];
    If (DllResult < 0) Then
      DllReturnMSG := 'No params.'
    Else
      DllReturnMSG := ErrorsStringsArray[DllResult];
    MsgBox('DLL result: ' + DllReturnMSG, mbInformation, mb_OK);
//    MessageBox( 0, IntToStr(Return), 'DLL result', MB_ICONINFORMATION, mb_ok );
    MsgBox('Supported archives/codecs { CommandFor7ZIP("i") }:' + #10#13 + OutputInfo, mbInformation, mb_OK);
//    MessageBox( 0, OutputInfo, 'Supported archives/codecs { CommandFor7ZIP("i") }', MB_ICONINFORMATION, mb_ok );
    MsgBox('Supported commands { CommandFor7ZIP("-h") }:' + #10#13 + OutputHelp, mbInformation, mb_OK);
//    MessageBox( 0, OutputHelp, 'Supported commands { CommandFor7ZIP("-h") }', MB_ICONINFORMATION, mb_ok );
end;