// Overlay7ZipDllTest.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"

#include <windows.h>
#include <string>
#include <conio.h>

extern "C" {
	typedef int(WINAPI *Func_CommandFor7zipA)(
		const char * args,
		char * &OutputBuffer,
		char * &ErrorsBuffer
		);
}

char * ErrorsStringsArray[] = {
	"Successful operation",                           // kSuccess       = 0
	"Non fatal error(s) occurred",                    // kWarning       = 1
	"A fatal error occurred",                         // kFatalError    = 2
	"A CRC error occurred when unpacking",            // kCRCError      = 3
	"Attempt to modify an archive previously locked", // kLockedArchive = 4
	"Write to disk error",                            // kWriteError    = 5
	"Open file error",                                // kOpenError     = 6
	"Command line option error",                      // kUserError     = 7
	"Not enough memory for operation",                // kMemoryError   = 8
	"Create file error"                               // kCreateFileError = 9
	};

int main(int argsCount, char * args[])
{
	int Ret;
	HMODULE Overlay7Z = LoadLibraryA("7zOverlay.dll");
	if (Overlay7Z == NULL)
	{
		printf("Can't load the '7zOverlay.dll'.");
		Ret = -3210;
	}
	else
	{
		std::string test = GetCommandLineA();
		size_t pos = test.find(args[0]);
		if (pos > 0) {
			test.replace(pos, strlen(args[0]), "");
			pos = test.find("\"\"");
			if(pos != std::string::npos)
				test.replace(pos, strlen("\"\""), "");
		}
		const char * Params = test.c_str();

		printf("Params: %s\n---\n", Params);

		char * OutputBuffer;
		char * ErrorsBuffer;

		Func_CommandFor7zipA CommandFor7zipA = (Func_CommandFor7zipA)GetProcAddress(Overlay7Z, "CommandFor7zipA");
		try
		{
			Ret = CommandFor7zipA(Params, OutputBuffer, ErrorsBuffer);
			printf(OutputBuffer);
		}
		catch (...)
		{
			printf("DLL exception caught!");
			Ret = -890;
		}
		FreeLibrary(Overlay7Z);

		printf("\n---\n");

		if (Ret >= 0)
			printf("Result: %s", ErrorsStringsArray[Ret]);
		else
			if(Ret == -1)
				printf("No params.");
			else
				printf("Result: %d", Ret);
	}

	printf("\n---\nPress any key to exit.\n");
	_getch();
    return Ret;
}
