Attribute VB_Name = "Overlay7ZipDllTest"
Option Explicit

Private Declare Sub CopyMemory Lib "kernel32.dll" Alias "RtlMoveMemory" (ByRef Destination As Any, ByRef Source As Any, ByVal Length As Long)
Private Declare Function SysAllocString Lib "oleaut32.dll" (ByVal nString As Long) As Long
Private Declare Function MessageBoxW Lib "User32.dll" (ByVal hWnd As Long, ByVal lpText As String, ByVal lpCaption As String, ByVal uType As Long) As Integer

Private Declare Function CommandFor7zipW Lib "7zOverlay.dll" (ByVal params As String, ByRef outBuffer As Long, ByRef errBuffer As Long) As Integer

Private Declare Sub ExitProcess Lib "kernel32.dll" (ByVal uExitCode As Long)
Private Sub Main()

        Dim strCommandLine As String
        strCommandLine = Command

        Dim outBuffer      As Long
        Dim errBuffer      As Long

        Dim ret As Long
        ret = CommandFor7zipW( StrConv(strCommandLine, vbUnicode), outBuffer, errBuffer )

        Dim Result       As String
        CopyMemory Result, SysAllocString(outBuffer), 4

        Dim ErrorsStringsArray(10) As String
            ErrorsStringsArray(0) = "Successful operation"                           ' kSuccess       = 0
            ErrorsStringsArray(1) = "Non fatal error(s) occurred"                    ' kWarning       = 1
            ErrorsStringsArray(2) = "A fatal error occurred"                         ' kFatalError    = 2
            ErrorsStringsArray(3) = "A CRC error occurred when unpacking"            ' kCRCError      = 3
            ErrorsStringsArray(4) = "Attempt to modify an archive previously locked" ' kLockedArchive = 4
            ErrorsStringsArray(5) = "Write to disk error"                            ' kWriteError    = 5
            ErrorsStringsArray(6) = "Open file error"                                ' kOpenError     = 6
            ErrorsStringsArray(7) = "Command line option error"                      ' kUserError     = 7
            ErrorsStringsArray(8) = "Not enough memory for operation"                ' kMemoryError   = 8
            ErrorsStringsArray(9) = "Create file error"                              ' kCreateFileError = 9
        
        Dim ResultMSG As String
        If (ret < 0) Then
            ResultMSG = "No params."
        Else
            ResultMSG = ErrorsStringsArray(ret)
        End If

        MessageBoxW 0, Result & vbNullChar, StrConv("Dll result: ", vbUnicode) & StrConv(ResultMSG, vbUnicode) & vbNullChar, vbInformation
'        MsgBox Result, vbInformation, "Dll result: " & ResultMSG

    ExitProcess(ret)

End Sub

