Program Overlay7ZipDllTest;

{$APPTYPE CONSOLE}

Uses
  Windows,
  SysUtils;

Function CommandFor7zipW(const args: PWideChar; var Output, Errors: PWideChar): Integer; stdcall;
  external '7zOverlay.dll' name 'CommandFor7zipW';

Var
  ErrorsStringsArray: Array[0..9] of String = (
    'Successful operation',                           // kSuccess       = 0
    'Non fatal error(s) occurred',                    // kWarning       = 1
    'A fatal error occurred',                         // kFatalError    = 2
    'A CRC error occurred when unpacking',            // kCRCError      = 3
    'Attempt to modify an archive previously locked', // kLockedArchive = 4
    'Write to disk error',                            // kWriteError    = 5
    'Open file error',                                // kOpenError     = 6
    'Command line option error',                      // kUserError     = 7
    'Not enough memory for operation',                // kMemoryError   = 8
    'Create file error'                               // kCreateFileError = 9
    );
  Params: WideString;
  OutputBuffer, ErrorsBuffer: PWideChar;
  Output: PAnsiChar;
  DefaultCharUsed: PBool;

Begin
  Params := StringReplace(GetCommandLineW(), ParamStr(0), '', [rfReplaceAll, rfIgnoreCase]);
  Params := StringReplace(Params, '""', '', [rfReplaceAll]);
  WriteLn( 'Params:' + Params );
  WriteLn( '---' );
  Try
    Try
      ExitCode := CommandFor7zipW( PWideChar(Params), OutputBuffer, ErrorsBuffer );
    except
      WriteLn('DLL exception caught!');
			ExitCode := -890;
    end;
  finally
    Output := PAnsiChar( StringOfChar( #1, Length(OutputBuffer) ) );
    WideCharToMultiByte( CP_OEMCP, 0, OutputBuffer, Length(OutputBuffer), Output, Length(Output), PAnsiChar(#0), DefaultCharUsed );
    Write( Output );
    WriteLn( '---' );
    if (ExitCode >= 0) then
      WriteLn( 'Result: ' + ErrorsStringsArray[ExitCode] )
    else
      WriteLn( 'No params.' );
  end;
  WriteLn( '---' );
  WriteLn('Press [enter] to exit.');
  ReadLn;
end.