Program Overlay7ZipDllTest;

{$APPTYPE CONSOLE}

Uses
  Windows,
  SysUtils;

Function CommandFor7zipA(const args: PAnsiChar; var Output, Errors: PAnsiChar): Integer; stdcall;
  external '7zOverlay.dll' name 'CommandFor7zipA';

Var
  ErrorsStringsArray: Array[0..9] of String = (
    'Successful operation',                           // kSuccess       = 0
    'Non fatal error(s) occurred',                    // kWarning       = 1
    'A fatal error occurred',                         // kFatalError    = 2
    'A CRC error occurred when unpacking',            // kCRCError      = 3
    'Attempt to modify an archive previously locked', // kLockedArchive = 4
    'Write to disk error',                            // kWriteError    = 5
    'Open file error',                                // kOpenError     = 6
    'Command line option error',                      // kUserError     = 7
    'Not enough memory for operation',                // kMemoryError   = 8
    'Create file error'                               // kCreateFileError = 9
    );
  Params: String;
  OutputBuffer, ErrorsBuffer: PAnsiChar;

Begin
  Params := StringReplace(GetCommandLineA(), ParamStr(0), '', [rfReplaceAll, rfIgnoreCase]);
  Params := StringReplace(Params, '""', '', [rfReplaceAll]);
  WriteLn( 'Params:' + Params );
  WriteLn( '---' );
  Try
    Try
      ExitCode := CommandFor7zipA( PAnsiChar(Params), OutputBuffer, ErrorsBuffer );
    except
      WriteLn('DLL exception caught!');
			ExitCode := -890;
    end;
  finally
    Write( OutputBuffer );
    WriteLn( '---' );
    if (ExitCode >= 0) then
      WriteLn( 'Result: ' + ErrorsStringsArray[ExitCode] )
    else
      WriteLn( 'No params.' );
  end;
  WriteLn( '---' );
  WriteLn('Press [enter] to exit.');
  ReadLn;
end.