using AsmResolver.PE.DotNet.Metadata.Tables;
using Xunit;

namespace AsmResolver.PE.Tests.DotNet.Metadata
{
    public class TypeReferenceHashTest
    {
        [Fact]
        public void HelloWorldTypeRefHash()
        {
            var image = PEImage.FromBytes(Properties.Resources.HelloWorld, TestReaderParameters);
            byte[] hash = image.GetTypeReferenceHash();

            Assert.Equal(new byte[]
            {
                0xa4, 0xb5, 0xdb, 0x27, 0x28, 0x6e, 0xc3, 0x6c, 0xb2, 0xd2, 0xcc, 0x9b, 0xbe, 0x60, 0x6c, 0xe7, 0xe4,
                0x7b, 0x61, 0x95, 0x22, 0x5c, 0xb4, 0x72, 0x81, 0xc7, 0xb9, 0xc3, 0xdb, 0xdd, 0x16, 0xca
            }, hash);
        }

        [Fact]
        public void TheAnswerTypeRefHash()
        {
            var image = PEImage.FromBytes(Properties.Resources.TheAnswer_NetCore, TestReaderParameters);
            byte[] hash = image.GetTypeReferenceHash();

            Assert.Equal(new byte[]
            {
                0xe0, 0xb6, 0x02, 0xb7, 0x71, 0x1c, 0xc3, 0x49, 0x77, 0x72, 0x6d, 0xf0, 0x97, 0x5f, 0xf1, 0xf2, 0xeb,
                0x47, 0xbe, 0x77, 0xec, 0x73, 0x50, 0x4b, 0x29, 0xe3, 0xa8, 0x1e, 0x3d, 0x96, 0x33, 0x10,
            }, hash);
        }
    }
}
