# 深度学习在图像处理中的应用教程

## 前言
* 本教程是对本人研究生期间的研究内容进行整理总结，总结的同时也希望能够帮助更多的小伙伴。后期如果有学习到新的知识也会与大家一起分享。
* 本教程会以视频的方式进行分享，教学流程如下：  
1）介绍网络的结构与创新点  
2）使用Pytorch进行网络的搭建与训练  
3）使用Tensorflow（内部的keras模块）进行网络的搭建与训练 
* 课程中所有PPT都放在`course_ppt`文件夹下，需要的自行下载。


## 教程目录，点击跳转相应视频（后期会根据学习内容增加）

* 图像分类
  * LeNet（已完成）
    * [Pytorch官方demo(Lenet)](https://www.bilibili.com/video/BV187411T7Ye)
    * [Tensorflow2官方demo](https://www.bilibili.com/video/BV1n7411T7o6)

  * AlexNet（已完成）
    * [AlexNet网络讲解](https://www.bilibili.com/video/BV1p7411T7Pc)
    * [Pytorch搭建AlexNet](https://www.bilibili.com/video/BV1W7411T7qc)
    * [Tensorflow2搭建Alexnet](https://www.bilibili.com/video/BV1s7411T7vs)

  * VggNet（已完成）
    * [VggNet网络讲解](https://www.bilibili.com/video/BV1q7411T7Y6)
    * [Pytorch搭建VGG网络](https://www.bilibili.com/video/BV1i7411T7ZN)
    * [Tensorflow2搭建VGG网络](https://www.bilibili.com/video/BV1q7411T76b)

  * GoogLeNet（已完成）
    * [GoogLeNet网络讲解](https://www.bilibili.com/video/BV1z7411T7ie)
    * [Pytorch搭建GoogLeNet网络](https://www.bilibili.com/video/BV1r7411T7M5)
    * [Tensorflow2搭建GoogLeNet网络](https://www.bilibili.com/video/BV1a7411T7Ht)

  * ResNet（已完成）
    * [ResNet网络讲解](https://www.bilibili.com/video/BV1T7411T7wa)
    * [Pytorch搭建ResNet网络](https://www.bilibili.com/video/BV14E411H7Uw)
    * [Tensorflow2搭建ResNet网络](https://www.bilibili.com/video/BV1WE41177Ya)

  * ResNeXt (已完成)
    * [ResNeXt网络讲解](https://www.bilibili.com/video/BV1Ap4y1p71v/)
    * [Pytorch搭建ResNeXt网络](https://www.bilibili.com/video/BV1rX4y1N7tE)

  * MobileNet_V1_V2（已完成）
    * [MobileNet_V1_V2网络讲解](https://www.bilibili.com/video/BV1yE411p7L7)
    * [Pytorch搭建MobileNetV2网络](https://www.bilibili.com/video/BV1qE411T7qZ)
    * [Tensorflow2搭建MobileNetV2网络](https://www.bilibili.com/video/BV1NE411K7tX)

  * MobileNet_V3（已完成）
    * [MobileNet_V3网络讲解](https://www.bilibili.com/video/BV1GK4y1p7uE)
    * [Pytorch搭建MobileNetV3网络](https://www.bilibili.com/video/BV1zT4y1P7pd)
    * [Tensorflow2搭建MobileNetV3网络](https://www.bilibili.com/video/BV1KA411g7wX)

  * ShuffleNet_V1_V2 (已完成)
    * [ShuffleNet_V1_V2网络讲解](https://www.bilibili.com/video/BV15y4y1Y7SY)
    * [使用Pytorch搭建ShuffleNetV2](https://www.bilibili.com/video/BV1dh411r76X)
    * [使用Tensorflow2搭建ShuffleNetV2](https://www.bilibili.com/video/BV1kr4y1N7bh)

  * EfficientNet_V1（已完成）
    * [EfficientNet网络讲解](https://www.bilibili.com/video/BV1XK4y1U7PX)
    * [使用Pytorch搭建EfficientNet](https://www.bilibili.com/video/BV19z4y1179h/)
    * [使用Tensorflow2搭建EfficientNet](https://www.bilibili.com/video/BV1PK4y1S7Jf)

  * EfficientNet_V2 (已完成)
    * [EfficientNetV2网络讲解](https://b23.tv/NDR7Ug)
    * [使用Pytorch搭建EfficientNetV2](https://b23.tv/M4hagB)
    * [使用Tensorflow搭建EfficientNetV2](https://b23.tv/KUPbdr)
  
  * RepVGG（已完成）
    * [RepVGG网络讲解](https://www.bilibili.com/video/BV15f4y1o7QR)

  * Vision Transformer(已完成)
    * [Multi-Head Attention讲解](https://b23.tv/gucpvt)
    * [Vision Transformer网络讲解](https://www.bilibili.com/video/BV1Jh411Y7WQ)
    * [使用Pytorch搭建Vision Transformer](https://b23.tv/TT4VBM)
    * [使用tensorflow2搭建Vision Transformer](https://www.bilibili.com/video/BV1q64y1X7GY)

  * Swin Transformer(已完成)
    * [Swin Transformer网络讲解](https://www.bilibili.com/video/BV1pL4y1v7jC)
    * [使用Pytorch搭建Swin Transformer](https://b23.tv/vZnpJf)
    * [使用Tensorflow2搭建Swin Transformer](https://b23.tv/UHLMSF)

  * ConvNeXt(已完成)
    * [ConvNeXt网络讲解](https://www.bilibili.com/video/BV1SS4y157fu)
    * [使用Pytorch搭建ConvNeXt](https://b23.tv/gzpCv5z)
    * [使用Tensorflow2搭建ConvNeXt](https://b23.tv/zikVoch)

  * MobileViT(已完成)
    * [MobileViT网络讲解](https://www.bilibili.com/video/BV1TG41137sb)
    * [使用Pytorch搭建MobileViT](https://www.bilibili.com/video/BV1ae411L7Ki)

* 目标检测
  * Faster-RCNN/FPN（已完成）
    * [Faster-RCNN网络讲解](https://www.bilibili.com/video/BV1af4y1m7iL)
    * [FPN网络讲解](https://b23.tv/Qhn6xA)
    * [Faster-RCNN源码解析(Pytorch)](https://www.bilibili.com/video/BV1of4y1m7nj)

  * SSD/RetinaNet (已完成)
    * [SSD网络讲解](https://www.bilibili.com/video/BV1fT4y1L7Gi)
    * [RetinaNet网络讲解](https://b23.tv/ZYCfd2)
    * [SSD源码解析(Pytorch)](https://www.bilibili.com/video/BV1vK411H771)

  * YOLO Series (已完成)
    * [YOLO系列网络讲解(V1~V3)](https://www.bilibili.com/video/BV1yi4y1g7ro)
    * [YOLOv3 SPP源码解析(Pytorch版)](https://www.bilibili.com/video/BV1t54y1C7ra)
    * [YOLOV4网络讲解](https://b23.tv/WLptQ7Q)
    * [YOLOV5网络讲解](https://www.bilibili.com/video/BV1T3411p7zR)
    * [YOLOX 网络讲解](https://www.bilibili.com/video/BV1JW4y1k76c)
  
  * FCOS（已完成）
    * [FCOS网络讲解](https://www.bilibili.com/video/BV1G5411X7jw)

* 语义分割 
  * FCN (已完成)
    * [FCN网络讲解](https://www.bilibili.com/video/BV1J3411C7zd)
    * [FCN源码解析(Pytorch版)](https://www.bilibili.com/video/BV19q4y1971Q)

  * DeepLabV3 (已完成)
    * [DeepLabV1网络讲解](https://www.bilibili.com/video/BV1SU4y1N7Ao)
    * [DeepLabV2网络讲解](https://www.bilibili.com/video/BV1gP4y1G7TC)
    * [DeepLabV3网络讲解](https://www.bilibili.com/video/BV1Jb4y1q7j7)
    * [DeepLabV3源码解析(Pytorch版)](https://www.bilibili.com/video/BV1TD4y1c7Wx)

  * LR-ASPP (已完成)
    * [LR-ASPP网络讲解](https://www.bilibili.com/video/BV1LS4y1M76E)
    * [LR-ASPP源码解析(Pytorch版)](https://www.bilibili.com/video/bv13D4y1F7ML)
  
  * U-Net (已完成)
    * [U-Net网络讲解](https://www.bilibili.com/video/BV1Vq4y127fB/)
    * [U-Net源码解析(Pytorch版)](https://b23.tv/PCJJmqN)
  
  * U2Net (已完成)
    * [U2Net网络讲解](https://www.bilibili.com/video/BV1yB4y1z7mj)
    * [U2Net源码解析(Pytorch版)](https://www.bilibili.com/video/BV1Kt4y137iS)

* 实例分割
  * Mask R-CNN（已完成）
    * [Mask R-CNN网络讲解](https://www.bilibili.com/video/BV1ZY411774T)
    * [Mask R-CNN源码解析(Pytorch版)](https://www.bilibili.com/video/BV1hY411E7wD)

* 关键点检测
  * DeepPose（已完成）
    * [DeepPose网络讲解](https://www.bilibili.com/video/BV1bm421g7aJ)
    * [DeepPose源码解析(Pytorch版)](https://www.bilibili.com/video/BV1bm421g7aJ)

  * HRNet（已完成）
    * [HRNet网络讲解](https://www.bilibili.com/video/BV1bB4y1y7qP)
    * [HRNet源码解析(Pytorch版)](https://www.bilibili.com/video/BV1ar4y157JM)

**[更多相关视频请进入我的bilibili频道查看](https://space.bilibili.com/18161609/channel/index)**

---

## 所需环境
* Anaconda3（建议使用）
* python3.6/3.7/3.8
* pycharm (IDE)
* pytorch 1.10 (pip package)
* torchvision 0.11.1 (pip package)
* tensorflow 2.4.1 (pip package)

欢迎大家关注下我的微信公众号（**阿喆学习小记**），平时会总结些相关学习博文。    

如果有什么问题，也可以到我的CSDN中一起讨论。
[https://blog.csdn.net/qq_37541097/article/details/103482003](https://blog.csdn.net/qq_37541097/article/details/103482003)

我的bilibili频道：
[https://space.bilibili.com/18161609/channel/index](https://space.bilibili.com/18161609/channel/index)
