# 什么是设计模式？

> 顾名思义，无论是什么领域出现了模式相关的东西，那么这些模式一定是相对于`原生`来说，更加高效、更加优雅、可维护更强。

> 在[软件工程](https://zh.wikipedia.org/wiki/軟體工程)中，**设计模式**（design pattern）是对[软件设计](https://zh.wikipedia.org/wiki/軟件設計)中普遍存在（反复出现）的各种问题，所提出的解决方案。这个术语是由[埃里希·伽玛](https://zh.wikipedia.org/wiki/埃里希·伽瑪)（Erich Gamma）等人在1990年代从[建筑设计](https://zh.wikipedia.org/wiki/建筑设计)领域引入到[计算机科学](https://zh.wikipedia.org/wiki/計算機科學)的。
>
> 设计模式并不直接用来完成[代码](https://zh.wikipedia.org/wiki/程式碼)的编写，而是描述在各种不同情况下，要怎么解决问题的一种方案。[面向对象](https://zh.wikipedia.org/wiki/面向对象程序设计)设计模式通常以[类别](https://zh.wikipedia.org/wiki/类_(计算机科学))或[物件](https://zh.wikipedia.org/wiki/物件_(電腦科學))来描述其中的关系和相互作用，但不涉及用来完成应用程序的特定类别或物件。设计模式能使不稳定依赖于相对稳定、具体依赖于相对抽象，避免会引起麻烦的紧耦合，以增强软件设计面对并适应变化的能力。
>
> 并非所有的软件模式都是设计模式，设计模式特指软件“设计”层次上的问题。还有其他非设计模式的模式，如[架构模式](https://zh.wikipedia.org/wiki/架构模式)。同时，[算法](https://zh.wikipedia.org/wiki/演算法)不能算是一种设计模式，因为算法主要是用来解决计算上的问题，而非设计上的问题。
>
> 随着软件开发社群对设计模式的兴趣日益增长，已经出版了一些相关的专著，定期召开相应的研讨会，而且[沃德·坎宁安](https://zh.wikipedia.org/wiki/沃德·坎宁安)（Ward Cunningham）为此发明了[WikiWiki](https://zh.wikipedia.org/wiki/WikiWiki)用来交流设计模式的经验。
>
> <div style = "text-align: right">
>     <a>--摘自维基百科</a>
> </div>

**总结：**

我认为设计模式就是前人针对于各种各样的总结下来的精华。是完全可以直接复用，并且能够提高开发效率的一种模式。



