## 什么是微服务

> 维基百科

![image.png](https://cs-wlei224.obs.cn-south-1.myhuaweicloud.com/blog-imgs/202401011735991.png)

> ### 一个微服务框架的应用程序有下列特性：

- 每个服务都容易被取代。
- 服务是以能力来组织的，例如用户界面、前端、推荐系统、账单或是物流等。
- 由于功能被拆成多个服务，因此可以由不同的编程语言、数据库实现。
- 架构是对称而非分层（即生产者与消费者的关系）。

> ### 一个微服务框架：

- 适用于具持续交付（Continuous Delivery）的软件开发流程。
- 与服务导向架构（Service-Oriented Architecture）不同，后者是集成各种业务的应用程序，但微服务只属于一个应用程序。

> ### 杂谈：

- 为什么一些高并发平台都属于微服务架构？

比如说语雀 APP ，虽然不小心挂掉之后，经过长达多个小时的紧急抢修，服务得意重新上线。

- 从这次 P0 级事故，我们可以学到什么？

![image.png](https://cs-wlei224.obs.cn-south-1.myhuaweicloud.com/blog-imgs/202401011736181.png)

## 微服务实现技术

- `Spring Cloud`
- `Spring Cloud Alibaba`
- `Dubbo`
- `RPC`（`GRPC`、`TRPC`）

**微服务的本质：**
就是通过HTTP、或者其他网络通讯协议进行相互调用而实现的。

> 知识扩展

### 分布式与微服务的区别

**简单来说：**
分布式就是把一个大的项目拆分，部署到多台机器；微服务是把项目按照功能进行拆分。

> #### 面试问题：什么是分布式锁？什么是单机锁？
>
> #### 分布式锁？顾名思义，分布式锁就是要考虑到多台机器的场景

**总结：**
分布式项目对标**单机项目**；
微服务项目是与**整个项目的业务逻辑**进行对比的。
