# 什么是关系型数据库与非关系型数据库

### 维基百科介绍

![image-20231222200953482](https://cs-wlei224.obs.cn-south-1.myhuaweicloud.com/blog-imgs/202312222009902.png)

### 我的理解

- **常见的关系型数据库有`MySQL`和`Oracle`等，关系型数据库就是采用了一种关系模型的数据库。**
  - 这个关系模型通常可以理解为表格的行与列
- **非关系型数据库就是`NOSQL`数据库，有`Redis`和`MongoDB`等。**
  - 这个关系模型通常可以理解为键值对存储

### 二者的特点与区别


1. 🤖传统关系型数据库的数据是以行列的方式进行存储的，

   👾非关系型数据库以键值对的形式存储

2. 🤖关系型数据库的数据通常是存储于硬盘的，

   👾非关系型数据库基于内存

3. 🤖关系型数据库强调数据的读写一致性，不惜降低读写性能，

   👾非关系型数据库不强调

4. 🤖强调事务的`ACID`原则，即原子性(Atomatic)、一致性(Consistency)、隔离性(Isolation)、持久性(Durability)

   👾

5. 🤖关系型数据库采用结构化查询语言，

   👾非关系型数据库采用根据`Key`进行查询

> 区别

|          | 关系型数据库               | 非关系型数据库     |
| -------- | -------------------------- | ------------------ |
| 代表语言 | `MySQL`、`Oracle`          | `Redis`、`MongoDB` |
| 存储形式 | 通常是基于硬盘（有内存表） | 通常基于内存       |
| 查询方式 | 结构化查询                 | 根据`Key`查询      |
| 强调事务 | 强调                       | 不强调             |

### 知识扩展

> 那么还有什么模型的数据库呢？

1. 键值型————`Redis`
2. 文档型————`MongoDB`
3. 向量型————例如腾讯自研的向量数据库
4. ·······

> `MySQL`有几种存储引擎？

1. MyISAM
2. InNoDB
3. MEMORY
4. ······