> 什么是多态？

多态就是，对于同一个父类，指向不同子类对象的同一个行为，运行出来结果不同。

例如伪代码：

```java
class Animals {
    public void sleep() {
        sout("坐着睡！");
    }
}

class Dog extends Animals {
    @Override
    public void sleep() {
        sout("站立着睡！");
    }
}

class Cat extends Animals {
    @Override
    public void sleep() {
        sout("睁眼睡！");
    }
}
// 同一个父类 Animals，指向不同子类 Dog、Cat
Animals animals1 = new Dog();
Animals animals2 = new Cat();
```

对于`animals1.sleep()`和`animals2.sleep()`，最后运行出来可能会有不用的结果，但是这取决于几个条件：

- 继承类或实现接口

- 子类重写方法

- 同一个父类，指向不同子类

> 重载与重写什么区别？

引用 Wiki 百科：

> ## 函数重载规则
>
> - 多个函数定义使用相同的函数名称
> - 函数参数的数量或类型必须有区别
>
> 函数重载是静态多态的一种类别，其使用某种“最佳匹配”算法解析函数调用，通过找到形式参数类型与实际参数类型的最佳匹配来解析要调用的具体函数。该算法的细节因语言而异。
>
> 函数重载通常与[静态类型](https://zh.wikipedia.org/wiki/類型系統)编程语言（在[函数调用](https://zh.wikipedia.org/wiki/子程序)中强制执行[类型检查](https://zh.wikipedia.org/wiki/類型系統#型別檢查)）有关。重载函数实际上只是一组具有相同名称的不同函数。具体调用使用哪个函数是在[**编译期**](https://zh.wikipedia.org/wiki/编译期)决定的。
>
> 在 [Java](https://zh.wikipedia.org/wiki/Java) 中，函数重载也被称为编译时多态和静态多态。
>
> 函数重载不应与在运行时进行选择的[多态](https://zh.wikipedia.org/wiki/多态_(计算机科学))形式混淆，例如通过[虚函数](https://zh.wikipedia.org/wiki/虚函数)而不是静态函数。



因此我们大概明白：

- 重载是编译时重载的，编译时根据参数，决定调用哪个方法
- 重写是运行期重写的，运行时根据父类指向的子类，调用方法



**总结：**

重载和重写都是多态的体现，维基百科中也有说明[多态分为动态多态和静态多态](https://zh.wikipedia.org/wiki/%E5%A4%9A%E6%80%81_(%E8%AE%A1%E7%AE%97%E6%9C%BA%E7%A7%91%E5%AD%A6))

如图：

![image-20231214103612773](https://cs-wlei224.obs.cn-south-1.myhuaweicloud.com/blog-imgs/202312141036730.png)



那么我们不妨理解为重载为静态动态（编译器决定）、重写为运行期决定的，为动态多态。

