## 我的理解

> `JDK`、`JRE`、`JVM`三者关系？

- `JDK` -- `Java`开发工具包，是一个功能齐全的开发`SDK`，具有编译器（javac）和工具（javadoc、jdb）功能，可以创建和编译程序。
- ``JRE` -- `Java`运行时环境，用于运行已经编译的`Java`程序（.class）所需要的内容集合，包括`JVM`以及`Java`核心类库或者其他构件，他只是运行环境，并不能创建程序。
- `JVM` -- `Java`虚拟机，`Java`程序运行于`Java`虚拟机中，针对不同的系统实现，因此Java语言可以实现跨平台

三者之间的关系是：`JDK > JRE > JVM`

![JVM、JDK、JRE？](https://cs-wlei224.obs.cn-south-1.myhuaweicloud.com/blog-imgs/202312281017330.png)

## 知识扩展

> 什么是字节码？为什么从编译到执行还要多一个字节码文件？

![平台无关性](https://cs-wlei224.obs.cn-south-1.myhuaweicloud.com/blog-imgs/202312281052947.png)

字节码是经过Java编译之后的字节码文件，是实现跨平台的关键。

所谓平台无关性呢，指的就是在不同的操作系统之间运行不受限制，一次编译，到处执行（Write once, Run anywhere）。

但是针对不同的硬件和操作系统来说，平台之间比如说二进制指令还是有区别的，所以此时就体现出了`JVM`的作用。不同的平台下载相应的`JVM`，`JVM`对字节码文件进行解释成对应平台的二进制文件，这样就解决了不同平台的二进制指令不同，然后就可以实现跨平台运行了。所以字节码文件在此提现了关键性的作用。