/*
 *   Copyright 2024 Vonage
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 */
package com.vonage.client.kt

/**
 * Base class for top-level endpoint domain objects with IDs.
 * This factors out the ID field and provides a common `toString`, `equals`, and `hashCode` implementation.
 *
 * @param id The unique resource identifier.
 */
open class ExistingResource internal constructor(val id: String) {

    @Override
    override fun toString(): String = "${this::class.qualifiedName} {id=$id}"

    @Override
    override fun equals(other: Any?): Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false
        other as ExistingResource
        return id == other.id
    }

    @Override
    override fun hashCode(): Int {
        return id.hashCode()
    }
}