**Read in other languages: [Українська](README.md), [English](README.en.md).**

# Критерії приймання

- Створено репозиторій `goit-js-hw-11`.
- Домашня робота містить два посилання: на вихідні файли і робочу сторінку на
  `GitHub Pages`.
- В консолі відсутні помилки і попередження під час відкриття живої сторінки
  завдання.
- Проект зібраний за допомогою
  [parcel-project-template](https://github.com/goitacademy/parcel-project-template).
- Для HTTP-запитів використана бібліотека [axios](https://axios-http.com/).
- Використовується синтаксис `async/await`.
- Для повідомлень використана бібліотека
  [notiflix](https://github.com/notiflix/Notiflix#readme).
- Код відформатований за допомогою `Prettier`.

# Завдання - пошук зображень

Створи фронтенд частину застосунку пошуку і перегляду зображень за ключовим
словом. Додай оформлення елементів інтерфейсу. Подивись демо-відео роботи
застосунку.

https://user-images.githubusercontent.com/17479434/125040406-49a6f600-e0a0-11eb-975d-e7d8eaf2af6b.mp4

## Форма пошуку

Форма спочатку міститья в HTML документі. Користувач буде вводити рядок для
пошуку у текстове поле, а по сабміту форми необхідно виконувати HTTP-запит.

```html
<form class="search-form" id="search-form">
  <input
    type="text"
    name="searchQuery"
    autocomplete="off"
    placeholder="Search images..."
  />
  <button type="submit">Search</button>
</form>
```

## HTTP-запити

Для бекенду використовуй публічний API сервісу
[Pixabay](https://pixabay.com/api/docs/). Зареєструйся, отримай свій унікальний
ключ доступу і ознайомся з документацією.

Список параметрів рядка запиту, які тобі обов'язково необхідно вказати:

- `key` - твій унікальний ключ доступу до API.
- `q` - термін для пошуку. Те, що буде вводити користувач.
- `image_type` - тип зображення. На потрібні тільки фотографії, тому постав
  значення `photo`.
- `orientation` - орієнтація фотографії. Постав значення `horizontal`.
- `safesearch` - фільтр за віком. Постав значення `true`.

У відповіді буде масив зображень, що задовольнили критерії параметрів запиту.
Кожне зображення описується об'єктом, з якого тобі цікаві тільки наступні
властивості:

- `webformatURL` - посилання на маленьке зображення для списку карток.
- `largeImageURL` - посилання на велике зображення.
- `tags` - рядок з описом зображення. Підійде для атрибуту `alt`.
- `likes` - кількість лайків.
- `views` - кількість переглядів.
- `comments` - кількість коментарів.
- `downloads` - кількість завантажень.

Якщо бекенд повертає порожній масив, значить нічого підходящого не було
знайдено. У такому разі показуй повідомлення з текстом
`"Sorry, there are no images matching your search query. Please try again."`.
Для повідомлень використовуй бібліотеку
[notiflix](https://github.com/notiflix/Notiflix#readme).

## Галерея і картка зображення

Елемент `div.gallery` спочатку міститься в HTML документі, і в нього необхідно
рендерити розмітку карток зображень. Під час пошуку за новим ключовим словом
необхідно повністю очищати вміст галереї, щоб не змішувати результати.

```html
<div class="gallery">
  <!-- Картки зображень -->
</div>
```

Шаблон розмітки картки одного зображення для галереї.

```html
<div class="photo-card">
  <img src="" alt="" loading="lazy" />
  <div class="info">
    <p class="info-item">
      <b>Likes</b>
    </p>
    <p class="info-item">
      <b>Views</b>
    </p>
    <p class="info-item">
      <b>Comments</b>
    </p>
    <p class="info-item">
      <b>Downloads</b>
    </p>
  </div>
</div>
```

## Пагінація

Pixabay API підтримує пагінацію і надає параметри `page` і `per_page`. Зроби
так, щоб в кожній відповіді приходило 40 об'єктів (за замовчуванням 20).

- Початкове значення параметра `page` повинно бути `1`.
- З кожним наступним запитом, його необхідно збільшити на `1`.
- У разі пошуку за новим ключовим словом, значення `page` потрібно повернути до
  початкового, оскільки буде пагінація по новій колекції зображень.

HTML документ вже містить розмітку кнопки, по кліку на яку, необхідно виконувати
запит за наступною групою зображень і додавати розмітку до вже існуючих
елементів галереї.

```html
<button type="button" class="load-more">Load more</button>
```

- В початковому стані кнопка повинна бути прихована.
- Після першого запиту кнопка з'являється в інтерфейсі під галереєю.
- При повторному сабміті форми кнопка спочатку ховається, а після запиту знову
  відображається.

У відповіді бекенд повертає властивість `totalHits` - загальна кількість
зображень, які відповідають критерію пошуку (для безкоштовного акаунту). Якщо
користувач дійшов до кінця колекції, ховай кнопку і виводь повідомлення з
текстом `"We're sorry, but you've reached the end of search results."`.

## Додатково

> ⚠️ Наступний функціонал не обов'язковий для здавання завдання, але буде
> хорошою додатковою практикою.

### Повідомлення

Після першого запиту з кожним новим пошуком отримувати повідомлення, в якому
буде написано, скільки всього знайшли зображень (властивість `totalHits`). Текст
повідомлення - `"Hooray! We found totalHits images."`

### Бібліотека `SimpleLightbox`

Додати відображення великої версії зображення з бібліотекою
[SimpleLightbox](https://simplelightbox.com/) для повноцінної галереї.

- У розмітці необхідно буде обгорнути кожну картку зображення у посилання, як
  зазначено в документації.
- Бібліотека містить матод `refresh()`, який обов'язково потрібно викликати
  щоразу після додавання нової групи карток зображень.

Для того щоб підключити CSS код бібліотеки в проект, необхідно додати ще один
імпорт, крім того, що описаний в документації.

```js
// Описаний в документації
import SimpleLightbox from 'simplelightbox';
// Додатковий імпорт стилів
import 'simplelightbox/dist/simple-lightbox.min.css';
```

### Прокручування сторінки

Зробити плавне прокручування сторінки після запиту і відтворення кожної
наступної групи зображень. Ось тобі код-підказка, але розберися у ньому
самостійно.

```js
const { height: cardHeight } = document
  .querySelector('.gallery')
  .firstElementChild.getBoundingClientRect();

window.scrollBy({
  top: cardHeight * 2,
  behavior: 'smooth',
});
```

### Нескінченний скрол

Замість кнопки «Load more», можна зробити нескінченне завантаження зображень під
час прокручування сторінки. Ми надаємо тобі повну свободу дій в реалізації,
можеш використовувати будь-які бібліотеки.

---

# Parcel template

Этот проект был создан при помощи Parcel. Для знакомства и настройки
дополнительных возможностей [обратись к документации](https://parceljs.org/).

## Подготовка нового проекта

1. Убедись что на компьютере установлена LTS-версия Node.js.
   [Скачай и установи](https://nodejs.org/en/) её если необходимо.
2. Склонируй этот репозиторий.
3. Измени имя папки с `parcel-project-template` на имя своего проекта.
4. Создай новый пустой репозиторий на GitHub.
5. Открой проект в VSCode, запусти терминал и свяжи проект с GitHub-репозиторием
   [по инструкции](https://docs.github.com/en/get-started/getting-started-with-git/managing-remote-repositories#changing-a-remote-repositorys-url).
6. Установи зависимости проекта в терминале командой `npm install` .
7. Запусти режим разработки, выполнив команду `npm start`.
8. Перейди в браузере по адресу [http://localhost:1234](http://localhost:1234).
   Эта страница будет автоматически перезагружаться после сохранения изменений в
   файлах проекта.

## Файлы и папки

- Все паршалы файлов стилей должны лежать в папке `src/sass` и импортироваться в
  файлы стилей страниц. Например, для `index.html` файл стилей называется
  `index.scss`.
- Изображения добавляй в папку `src/images`. Сборщик оптимизирует их, но только
  при деплое продакшн версии проекта. Все это происходит в облаке, чтобы не
  нагружать твой компьютер, так как на слабых машинах это может занять много
  времени.

## Деплой

Для настройки деплоя проекта необходимо выполнить несколько дополнительных шагов
по настройке твоего репозитория. Зайди во вкладку `Settings` и в подсекции
`Actions` выбери выбери пункт `General`.

![GitHub actions settings](./assets/actions-config-step-1.png)

Пролистай страницу до последней секции, в которой убедись что выбраны опции как
на следующем изображении и нажми `Save`. Без этих настроек у сборки будет
недостаточно прав для автоматизации процесса деплоя.

![GitHub actions settings](./assets/actions-config-step-2.png)

Продакшн версия проекта будет автоматически собираться и деплоиться на GitHub
Pages, в ветку `gh-pages`, каждый раз когда обновляется ветка `main`. Например,
после прямого пуша или принятого пул-реквеста. Для этого необходимо в файле
`package.json` отредактировать поле `homepage` и скрипт `build`, заменив
`your_username` и `your_repo_name` на свои, и отправить изменения на GitHub.

```json
"homepage": "https://your_username.github.io/your_repo_name/",
"scripts": {
  "build": "parcel build src/*.html --public-url /your_repo_name/"
},
```

Далее необходимо зайти в настройки GitHub-репозитория (`Settings` > `Pages`) и
выставить раздачу продакшн версии файлов из папки `/root` ветки `gh-pages`, если
это небыло сделано автоматически.

![GitHub Pages settings](./assets/repo-settings.png)

### Статус деплоя

Статус деплоя крайнего коммита отображается иконкой возле его идентификатора.

- **Желтый цвет** - выполняется сборка и деплой проекта.
- **Зеленый цвет** - деплой завершился успешно.
- **Красный цвет** - во время линтинга, сборки или деплоя произошла ошибка.

Более детальную информацию о статусе можно посмотреть кликнув по иконке, и в
выпадающем окне перейти по ссылке `Details`.

![Deployment status](./assets/status.png)

### Живая страница

Через какое-то время, обычно пару минут, живую страницу можно будет посмотреть
по адресу указанному в отредактированном свойстве `homepage`. Например, вот
ссылка на живую версию для этого репозитория
[https://goitacademy.github.io/parcel-project-template](https://goitacademy.github.io/parcel-project-template).

Если открывается пустая страница, убедись что во вкладке `Console` нет ошибок
связанных с неправильными путями к CSS и JS файлам проекта (**404**). Скорее
всего у тебя неправильное значение свойства `homepage` или скрипта `build` в
файле `package.json`.

## Как это работает

![How it works](./assets/how-it-works.png)

1. После каждого пуша в ветку `main` GitHub-репозитория, запускается специальный
   скрипт (GitHub Action) из файла `.github/workflows/deploy.yml`.
2. Все файлы репозитория копируются на сервер, где проект инициализируется и
   проходит сборку перед деплоем.
3. Если все шаги прошли успешно, собранная продакшн версия файлов проекта
   отправляется в ветку `gh-pages`. В противном случае, в логе выполнения
   скрипта будет указано в чем проблема.
