# Welcome to My Repository!

After many years in the Visual FX industry, I’ve decided to share some of the tools I’ve developed.  

## Usage License

There are free to use and royalty-free.

You are allowed to use them in commercial productions, provided that I am credited as the author.

However, resale of these content is strictly __prohibited__.

## What's Inside

- **MaxScript**: MaxScript is the native scripting language for 3ds Max. You can drag and drop the `.ms` files into 3ds Max to run them, or create a custom macro for quick access.
  
- **Max Files**: Some setups not only involve scripting but require a full scene, including rigs, tyFlow setups, objects, etc.

- **tyFlow Scripts**: These are written in C# and need to be loaded into a script operator in the tyFlow editor.

- **Houdini HDAs**: Ready-to-use assets you can easily import into your Houdini projects.

- **Houdini Python Scripts**: These Python scripts can be added to your Houdini shelf to automate common tasks.

## Quick Tips

### Creating a Macro Script in 3ds Max

To quickly access an external script in 3ds Max, use the following code:

```maxscript
scriptPath = @"C:\yourFolder\yourScript.ms"
if doesfileexist scriptPath do filein scriptPath
```
### Maxscript & tyFlow

Improve your worflow using [maxscript](https://www.youtube.com/watch?v=VMQv5TyddVA&). 

[How to batch export](https://www.youtube.com/watch?v=T489-QfWMMg).

[How to use the tyCache control script](https://www.youtube.com/watch?v=Q3q3P92XOYg&list=PL4Fltnv41D9PCAp6L5GAXB9XbF0XZ-NGI&index=12).


## Contact

For suggestions or bug reports, feel free to reach out at **victorburtman@gmail.com**.

Explore more of my work on my [website](https://www.victorburtman.com/).

Enjoy!

