#include "styledbar.h"
#include "stylehelper.h"
#include <QPainter>
#include <QStyleOption>

StyledBar::StyledBar(QWidget *parent) : QWidget(parent)
{
    setProperty("panelwidget", true);
    setProperty("panelwidget_singlerow", true);
    setProperty("lightColored", false);
    setFixedHeight(StyleHelper::navigationWidgetHeight());
}

void StyledBar::paintEvent(QPaintEvent *event)
{
    Q_UNUSED(event)
    QPainter painter(this);
    QStyleOption option;
    option.rect = rect();
    option.state = QStyle::State_Horizontal;
    style()->drawControl(QStyle::CE_ToolBar, &option, &painter, this);
    QWidget::paintEvent(event);
}
