; The point here is to test the ability to pass runtime information to analysis.
;
; The same `call ebx` is executed 4 times, see label ".dispatch".
; The first two times are with functions identified by analysis.
; The second two times evade analysis and require runtime information.
; Binja should make functions in the second two cases and add comments of runtime
; annotation option is enabled.

default rel

%ifdef OS_IS_LINUX
	global _start
	section .text
	_start:
%endif

%ifdef OS_IS_MACOS
	global start, junk, mapper
	section .text
	start:
%endif

%ifdef OS_IS_WINDOWS
	global WinMain
	extern ExitProcess, GetStdHandle, WriteConsoleA
	section .text
	WinMain:
%endif

	mov		rcx, 4					; <------- LOOP VAR

.next:
	push	rcx

.test4:
	cmp		rcx, 4
	jne		.test3
	lea		rbx, [sub_00]
	jmp		.dispatch

.test3:
	cmp		rcx, 3
	jne		.test2
	lea		rbx, [sub_01]
	jmp		.dispatch

.test2:
	cmp		rcx, 2
	jne		.test1
	lea		rbx, [junk]
	mov		rdi, 0x60 ; -> 0x30
	call	mapper
	add		rbx, rax
	jmp		.dispatch

.test1:
	cmp		rcx, 1
	lea		rbx, [junk]
	mov		rdi, 0xC6 ; -> 0x63
	call	mapper
	add		rbx, rax

.dispatch:
	call	rbx						; <-------- HERE

.check:
	pop		rcx
	loop	.next

; exit

%ifdef OS_IS_LINUX
	mov		rdi, 0 ; arg0: status
	mov		rax, 60 ; __NR_exit
	syscall
%endif

%ifdef OS_IS_MACOS
	mov		rax, 0x2000001 ; exit
	mov		rdi, 0
	syscall
%endif

%ifdef OS_IS_WINDOWS
    mov		rcx, 0
    call    ExitProcess
%endif

	ret

sub_00:
	ret

sub_01:
	nop
	ret

junk:
; junk
db 0xEF, 0x3D, 0x53, 0x7C, 0xFB, 0x80, 0x3B, 0x28
db 0x15, 0xD1, 0xA2, 0xCD, 0x5E, 0x7E, 0xBC, 0xE1
db 0xC6, 0x1B, 0x63, 0x05, 0xB7, 0xD3, 0xBA, 0x3B
db 0x39, 0xCA, 0x46, 0xA1, 0x32, 0xD9, 0x8A, 0xB5
db 0x8F, 0xD6, 0xFA, 0xAE, 0x08, 0x2D, 0xD5, 0x6F
db 0x1E, 0xD6, 0xB8, 0x72, 0xA9, 0x8D, 0x86, 0xE8

; junk + 0x30
; hidden function									; sub_02()
db 0x90												; nop
db 0x90												; nop
db 0xC3												; ret

; junk + 0x33
db 0xB4, 0xDE, 0xF0, 0x6B, 0x54, 0x40, 0x08, 0x46
db 0xF6, 0xAC, 0xDD, 0x82, 0x8C, 0x74, 0x2C, 0x7F
db 0xBD, 0x0B, 0xC1, 0xBA, 0x12, 0x1F, 0xD0, 0x7C
db 0x44, 0xFF, 0x43, 0x5F, 0xC6, 0x85, 0xF3, 0x23
db 0x6B, 0x65, 0x41, 0x2C, 0xB4, 0x4A, 0x5E, 0x24
db 0x35, 0xBA, 0x57, 0x76, 0x18, 0xAB, 0xE0, 0x51

; junk + 0x63
; hidden function									; sub_03()
db 0x90												; nop
db 0x90												; nop
db 0x90												; nop
db 0xC3												; ret

db 0xB9, 0x57, 0x18, 0x13, 0x61, 0xB0, 0x86, 0xBF
db 0x1F, 0x6B, 0xB7, 0x72, 0x07, 0x35, 0xB1, 0x02
db 0x7E, 0x6A, 0x2E, 0x1B, 0x7A, 0x0B, 0xEB, 0xDA
db 0x05, 0xCF, 0xC9, 0xBD, 0x9E, 0xB6, 0x07, 0xBF

mapper:
	mov		rax, rdi	; arg0: number to map
	shr		rax, 1
	ret
