export const success = (res, status) => entity => {
	if (entity) {
		res.status(status || 200).json(entity);
	}
	return null;
};

export const validationError = res => err => {
	if (err instanceof Error) {
		res.status(422).send(err.message);
	} else {
		res.status(500).json(err);
	}

	return null;
};

export const notFound = res => entity => {
	if (entity) {
		return entity;
	}
	res.status(404).end();
	return null;
};

export const authorOrAdmin = (res, user, userField) => entity => {
	if (entity) {
		const isAdmin = user.role === 'admin';
		const isAuthor = entity[userField] && entity[userField].equals(user.id);

		if (isAuthor || isAdmin) {
			return entity;
		}

		res.status(401).end();
	}
	return null;
};
